/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.hadoop;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;

public abstract class AbstractIOMapper<T>
extends Configured
implements Mapper<Text, LongWritable, Text, Text> {
    protected byte[] mBuffer;
    protected int mBufferSize;
    protected FileSystem mFS;
    protected String mHostname;
    protected Closeable mStream;

    public void configure(JobConf conf) {
        this.setConf((Configuration)conf);
        try {
            this.mFS = FileSystem.get((Configuration)conf);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create file system.", e);
        }
        this.mBufferSize = conf.getInt("test.io.file.buffer.size", 4096);
        this.mBuffer = new byte[this.mBufferSize];
        try {
            this.mHostname = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            this.mHostname = "localhost";
        }
    }

    public void close() throws IOException {
    }

    abstract T doIO(Reporter var1, String var2, long var3) throws IOException;

    @Nullable
    public Closeable getIOStream(String name) throws IOException {
        return null;
    }

    abstract void collectStats(OutputCollector<Text, Text> var1, String var2, long var3, T var5) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void map(Text key, LongWritable value, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
        String name = key.toString();
        long longValue = value.get();
        reporter.setStatus("starting " + name + " ::host = " + this.mHostname);
        this.mStream = this.getIOStream(name);
        T statValue = null;
        long tStart = System.currentTimeMillis();
        try {
            statValue = this.doIO(reporter, name, longValue);
        }
        finally {
            if (this.mStream != null) {
                this.mStream.close();
            }
        }
        long tEnd = System.currentTimeMillis();
        long execTime = tEnd - tStart;
        this.collectStats(output, name, execTime, statValue);
        reporter.setStatus("finished " + name + " ::host = " + this.mHostname);
    }
}

