/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.hadoop;

import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.grpc.WritePType;
import alluxio.hadoop.FileSystem;
import alluxio.hadoop.HadoopConfigurationUtils;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import java.net.URI;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.REMOVE, owner="bowen", comment="recycle the test cases after we remove BlockStore")
public class FileSystemBlockLocationIntegrationTest
extends BaseIntegrationTest {
    private static final int BLOCK_SIZE = 1024;
    private static final int FILE_LEN = 3072;
    @ClassRule
    public static LocalAlluxioClusterResource sLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().build();
    private static org.apache.hadoop.fs.FileSystem sTFS;

    @BeforeClass
    public static void beforeClass() throws Exception {
        org.apache.hadoop.conf.Configuration conf = new org.apache.hadoop.conf.Configuration();
        conf.set("fs.alluxio.impl", FileSystem.class.getName());
        alluxio.client.file.FileSystem alluxioFS = sLocalAlluxioClusterResource.get().getClient();
        FileSystemTestUtils.createByteFile((alluxio.client.file.FileSystem)alluxioFS, (String)"/testFile1", (WritePType)WritePType.CACHE_THROUGH, (int)3072);
        URI uri = URI.create(sLocalAlluxioClusterResource.get().getMasterURI());
        sTFS = org.apache.hadoop.fs.FileSystem.get((URI)uri, (org.apache.hadoop.conf.Configuration)HadoopConfigurationUtils.mergeAlluxioConfiguration((org.apache.hadoop.conf.Configuration)conf, (AlluxioConfiguration)Configuration.global()));
    }

    @Test
    public void basicBlockLocation() throws Exception {
        FileStatus fStatus = sTFS.getFileStatus(new Path("/testFile1"));
        long start = 0L;
        long len = 1023L;
        Assert.assertEquals((long)1L, (long)sTFS.getFileBlockLocations(fStatus, start, len).length);
        start = 1L;
        len = 1022L;
        Assert.assertEquals((long)1L, (long)sTFS.getFileBlockLocations(fStatus, start, len).length);
        start = 1L;
        len = 0L;
        Assert.assertEquals((long)1L, (long)sTFS.getFileBlockLocations(fStatus, start, len).length);
        start = 0L;
        len = 1024L;
        Assert.assertEquals((long)2L, (long)sTFS.getFileBlockLocations(fStatus, start, len).length);
        start = 0L;
        len = 1025L;
        Assert.assertEquals((long)2L, (long)sTFS.getFileBlockLocations(fStatus, start, len).length);
        start = 1L;
        len = 1024L;
        Assert.assertEquals((long)2L, (long)sTFS.getFileBlockLocations(fStatus, start, len).length);
        start = 0L;
        len = 2048L;
        Assert.assertEquals((long)3L, (long)sTFS.getFileBlockLocations(fStatus, start, len).length);
        start = 0L;
        len = 3072L;
        Assert.assertEquals((long)3L, (long)sTFS.getFileBlockLocations(fStatus, start, len).length);
        start = 3073L;
        len = 1L;
        Assert.assertEquals((long)0L, (long)sTFS.getFileBlockLocations(fStatus, start, len).length);
    }
}

