/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.hadoop;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.hadoop.FileSystem;
import alluxio.hadoop.HadoopConfigurationUtils;
import alluxio.security.authentication.AuthType;
import alluxio.testutils.LocalAlluxioClusterResource;
import java.net.URI;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class FileSystemIntegrationTest {
    @ClassRule
    public static LocalAlluxioClusterResource sLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.SECURITY_AUTHENTICATION_TYPE, AuthType.SIMPLE).setProperty(PropertyKey.SECURITY_AUTHORIZATION_PERMISSION_ENABLED, true).build();
    private static org.apache.hadoop.fs.FileSystem sTFS;

    @BeforeClass
    public static void beforeClass() throws Exception {
        org.apache.hadoop.conf.Configuration conf = new org.apache.hadoop.conf.Configuration();
        conf.set("fs.alluxio.impl", FileSystem.class.getName());
        URI uri = URI.create(sLocalAlluxioClusterResource.get().getMasterURI());
        sTFS = org.apache.hadoop.fs.FileSystem.get((URI)uri, (org.apache.hadoop.conf.Configuration)HadoopConfigurationUtils.mergeAlluxioConfiguration((org.apache.hadoop.conf.Configuration)conf, (AlluxioConfiguration)Configuration.global()));
    }

    @Test
    public void closeFileSystem() throws Exception {
        Path file = new Path("/createfile");
        FsPermission permission = FsPermission.createImmutable((short)438);
        FSDataOutputStream o = sTFS.create(file, permission, false, 10, (short)1, 512L, null);
        o.writeBytes("Test Bytes");
        o.close();
        sTFS.deleteOnExit(file);
        sTFS.close();
    }
}

