/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.hadoop;

import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.WriteType;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.hadoop.FileSystem;
import alluxio.hadoop.HadoopConfigurationUtils;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.underfs.UnderFileSystem;
import alluxio.util.io.PathUtils;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.REMOVE, owner="jiaming", comment="adapt rename to the new arch")
public final class FileSystemRenameIntegrationTest
extends BaseIntegrationTest {
    @ClassRule
    public static LocalAlluxioClusterResource sLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT, WriteType.CACHE_THROUGH).build();
    private static String sUfsRoot;
    private static UnderFileSystem sUfs;
    private static org.apache.hadoop.fs.FileSystem sTFS;

    private static void create(org.apache.hadoop.fs.FileSystem fs, Path path) throws IOException {
        FSDataOutputStream o = fs.create(path);
        o.writeBytes("Test Bytes");
        o.close();
    }

    public static void cleanup(org.apache.hadoop.fs.FileSystem fs) throws IOException {
        FileStatus[] statuses;
        for (FileStatus f : statuses = fs.listStatus(new Path("/"))) {
            fs.delete(f.getPath(), true);
        }
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        org.apache.hadoop.conf.Configuration conf = new org.apache.hadoop.conf.Configuration();
        conf.set("fs.alluxio.impl", FileSystem.class.getName());
        URI uri = URI.create(sLocalAlluxioClusterResource.get().getMasterURI());
        sTFS = org.apache.hadoop.fs.FileSystem.get((URI)uri, (org.apache.hadoop.conf.Configuration)HadoopConfigurationUtils.mergeAlluxioConfiguration((org.apache.hadoop.conf.Configuration)conf, (AlluxioConfiguration)Configuration.global()));
        sUfsRoot = Configuration.getString((PropertyKey)PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS);
        sUfs = UnderFileSystem.Factory.createForRoot((AlluxioConfiguration)Configuration.global());
    }

    @Test
    @Ignore
    public void basicRenameTest1() throws Exception {
        Path fileA = new Path("/fileA");
        Path fileB = new Path("/fileB");
        FileSystemRenameIntegrationTest.create(sTFS, fileA);
        Assert.assertTrue((boolean)sTFS.rename(fileA, fileB));
        Assert.assertFalse((boolean)sTFS.exists(fileA));
        Assert.assertTrue((boolean)sTFS.exists(fileB));
        Assert.assertFalse((boolean)sUfs.isFile(PathUtils.concatPath((Object)sUfsRoot, (Object)"fileA")));
        Assert.assertTrue((boolean)sUfs.isFile(PathUtils.concatPath((Object)sUfsRoot, (Object)"fileB")));
        FileSystemRenameIntegrationTest.cleanup(sTFS);
        Assert.assertFalse((boolean)sTFS.exists(fileB));
        Assert.assertFalse((boolean)sUfs.isFile(PathUtils.concatPath((Object)sUfsRoot, (Object)"fileB")));
    }

    @Test
    @Ignore
    public void basicRenameTest2() throws Exception {
        Path fileA = new Path("/fileA");
        Path dirA = new Path("/dirA");
        Path finalDst = new Path("/dirA/fileA");
        FileSystemRenameIntegrationTest.create(sTFS, fileA);
        sTFS.mkdirs(dirA);
        Assert.assertTrue((boolean)sTFS.rename(fileA, finalDst));
        Assert.assertFalse((boolean)sTFS.exists(fileA));
        Assert.assertTrue((boolean)sTFS.exists(dirA));
        Assert.assertTrue((boolean)sTFS.exists(finalDst));
        Assert.assertFalse((boolean)sUfs.isFile(PathUtils.concatPath((Object)sUfsRoot, (Object)"fileA")));
        Assert.assertTrue((boolean)sUfs.isDirectory(PathUtils.concatPath((Object)sUfsRoot, (Object)"dirA")));
        Assert.assertTrue((boolean)sUfs.isFile(PathUtils.concatPath((Object)sUfsRoot, (Object[])new Object[]{"dirA", "fileA"})));
        FileSystemRenameIntegrationTest.cleanup(sTFS);
        Assert.assertFalse((boolean)sUfs.isDirectory(PathUtils.concatPath((Object)sUfsRoot, (Object)"dirA")));
    }

    @Test
    @Ignore
    public void basicRenameTest3() throws Exception {
        Path fileA = new Path("/fileA");
        Path dirA = new Path("/dirA");
        Path finalDst = new Path("/dirA/fileA");
        FileSystemRenameIntegrationTest.create(sTFS, fileA);
        sTFS.mkdirs(dirA);
        Assert.assertTrue((boolean)sTFS.rename(fileA, dirA));
        Assert.assertFalse((boolean)sTFS.exists(fileA));
        Assert.assertTrue((boolean)sTFS.exists(dirA));
        Assert.assertTrue((boolean)sTFS.exists(finalDst));
        Assert.assertFalse((boolean)sUfs.isFile(PathUtils.concatPath((Object)sUfsRoot, (Object)"fileA")));
        Assert.assertTrue((boolean)sUfs.isDirectory(PathUtils.concatPath((Object)sUfsRoot, (Object)"dirA")));
        Assert.assertTrue((boolean)sUfs.isFile(PathUtils.concatPath((Object)sUfsRoot, (Object[])new Object[]{"dirA", "fileA"})));
        FileSystemRenameIntegrationTest.cleanup(sTFS);
        Assert.assertFalse((boolean)sUfs.isDirectory(PathUtils.concatPath((Object)sUfsRoot, (Object)"dirA")));
    }

    @Test
    @Ignore
    public void basicRenameTest4() throws Exception {
        Path fileA = new Path("/fileA");
        FileSystemRenameIntegrationTest.create(sTFS, fileA);
        Assert.assertTrue((boolean)sTFS.rename(fileA, fileA));
        Assert.assertTrue((boolean)sTFS.exists(fileA));
        Assert.assertTrue((boolean)sUfs.isFile(PathUtils.concatPath((Object)sUfsRoot, (Object)"fileA")));
        FileSystemRenameIntegrationTest.cleanup(sTFS);
        Assert.assertFalse((boolean)sTFS.exists(fileA));
        Assert.assertFalse((boolean)sUfs.isFile(PathUtils.concatPath((Object)sUfsRoot, (Object)"fileA")));
    }

    @Test
    @Ignore
    public void basicRenameTest5() throws Exception {
        Path fileA = new Path("/fileA");
        Path finalDst = new Path("/fileAfileA");
        FileSystemRenameIntegrationTest.create(sTFS, fileA);
        Assert.assertTrue((boolean)sTFS.rename(fileA, finalDst));
        Assert.assertFalse((boolean)sTFS.exists(fileA));
        Assert.assertTrue((boolean)sTFS.exists(finalDst));
        Assert.assertFalse((boolean)sUfs.isFile(PathUtils.concatPath((Object)sUfsRoot, (Object)"fileA")));
        Assert.assertTrue((boolean)sUfs.isFile(PathUtils.concatPath((Object)sUfsRoot, (Object)"fileAfileA")));
        FileSystemRenameIntegrationTest.cleanup(sTFS);
        Assert.assertFalse((boolean)sTFS.exists(finalDst));
        Assert.assertFalse((boolean)sUfs.isFile(PathUtils.concatPath((Object)sUfsRoot, (Object)"fileAfileA")));
    }

    @Test
    @Ignore
    public void basicRenameTest6() throws Exception {
        Path dirA = new Path("/dirA");
        Path dirB = new Path("/dirB");
        Path fileA = new Path("/dirA/fileA");
        Path finalDst = new Path("/dirB/fileA");
        sTFS.mkdirs(dirA);
        FileSystemRenameIntegrationTest.create(sTFS, fileA);
        Assert.assertTrue((boolean)sTFS.rename(dirA, dirB));
        Assert.assertFalse((boolean)sTFS.exists(dirA));
        Assert.assertFalse((boolean)sTFS.exists(fileA));
        Assert.assertTrue((boolean)sTFS.exists(dirB));
        Assert.assertTrue((boolean)sTFS.exists(finalDst));
        Assert.assertFalse((boolean)sUfs.isDirectory(PathUtils.concatPath((Object)sUfsRoot, (Object)"dirA")));
        Assert.assertFalse((boolean)sUfs.isFile(PathUtils.concatPath((Object)sUfsRoot, (Object[])new Object[]{"dirA", "fileA"})));
        Assert.assertTrue((boolean)sUfs.isDirectory(PathUtils.concatPath((Object)sUfsRoot, (Object)"dirB")));
        Assert.assertTrue((boolean)sUfs.isFile(PathUtils.concatPath((Object)sUfsRoot, (Object[])new Object[]{"dirB", "fileA"})));
        FileSystemRenameIntegrationTest.cleanup(sTFS);
        Assert.assertFalse((boolean)sTFS.exists(dirB));
        Assert.assertFalse((boolean)sTFS.exists(finalDst));
        Assert.assertFalse((boolean)sUfs.isDirectory(PathUtils.concatPath((Object)sUfsRoot, (Object)"dirB")));
        Assert.assertFalse((boolean)sUfs.isFile(PathUtils.concatPath((Object)sUfsRoot, (Object[])new Object[]{"dirB", "fileA"})));
    }

    @Test
    @Ignore
    public void basicRenameTest7() throws Exception {
        Path dirA = new Path("/dirA");
        Path dirB = new Path("/dirB");
        Path fileA = new Path("/dirA/fileA");
        Path finalDst = new Path("/dirB/fileA");
        sTFS.mkdirs(dirA);
        FSDataOutputStream o = sTFS.create(fileA);
        o.writeBytes("Test Bytes");
        o.hflush();
        Assert.assertTrue((boolean)sTFS.rename(dirA, dirB));
        Assert.assertFalse((boolean)sTFS.exists(dirA));
        Assert.assertFalse((boolean)sTFS.exists(fileA));
        Assert.assertTrue((boolean)sTFS.exists(dirB));
        Assert.assertTrue((boolean)sTFS.exists(finalDst));
        o.close();
        Assert.assertFalse((boolean)sTFS.exists(dirA));
        Assert.assertFalse((boolean)sTFS.exists(fileA));
        Assert.assertTrue((boolean)sTFS.exists(dirB));
        Assert.assertTrue((boolean)sTFS.exists(finalDst));
        FileSystemRenameIntegrationTest.cleanup(sTFS);
    }

    @Test
    @Ignore
    public void errorRenameTest1() throws Exception {
        Path dirA = new Path("/dirA");
        Path finalDst = new Path("/dirA/dirB");
        sTFS.mkdirs(dirA);
        Assert.assertFalse((boolean)sTFS.rename(dirA, finalDst));
        Assert.assertFalse((boolean)sTFS.exists(finalDst));
        Assert.assertTrue((boolean)sTFS.exists(dirA));
        Assert.assertFalse((boolean)sUfs.isDirectory(PathUtils.concatPath((Object)sUfsRoot, (Object[])new Object[]{"dirA", "dirB"})));
        Assert.assertFalse((boolean)sUfs.isDirectory(PathUtils.concatPath((Object)sUfsRoot, (Object)"dirB")));
        FileSystemRenameIntegrationTest.cleanup(sTFS);
        Assert.assertFalse((boolean)sTFS.exists(dirA));
        Assert.assertFalse((boolean)sUfs.isDirectory(PathUtils.concatPath((Object)sUfsRoot, (Object)"dirB")));
    }

    @Test
    @Ignore
    public void errorRenameTest2() throws Exception {
        Path fileA = new Path("/fileA");
        Path fileB = new Path("/fileB");
        FileSystemRenameIntegrationTest.create(sTFS, fileA);
        FileSystemRenameIntegrationTest.create(sTFS, fileB);
        Assert.assertFalse((boolean)sTFS.rename(fileA, fileB));
        Assert.assertTrue((boolean)sTFS.exists(fileA));
        Assert.assertTrue((boolean)sTFS.exists(fileB));
        Assert.assertTrue((boolean)sUfs.isFile(PathUtils.concatPath((Object)sUfsRoot, (Object)"fileA")));
        Assert.assertTrue((boolean)sUfs.isFile(PathUtils.concatPath((Object)sUfsRoot, (Object)"fileB")));
        FileSystemRenameIntegrationTest.cleanup(sTFS);
        Assert.assertFalse((boolean)sTFS.exists(fileA));
        Assert.assertFalse((boolean)sTFS.exists(fileB));
        Assert.assertFalse((boolean)sUfs.isFile(PathUtils.concatPath((Object)sUfsRoot, (Object)"fileA")));
        Assert.assertFalse((boolean)sUfs.isFile(PathUtils.concatPath((Object)sUfsRoot, (Object)"fileB")));
    }

    @Test
    @Ignore
    public void errorRenameTest3() throws Exception {
        Path fileA = new Path("/fileA");
        Path dirA = new Path("/dirA");
        Path finalDst = new Path("/dirA/fileA");
        FileSystemRenameIntegrationTest.create(sTFS, fileA);
        FileSystemRenameIntegrationTest.create(sTFS, finalDst);
        Assert.assertFalse((boolean)sTFS.rename(fileA, dirA));
        Assert.assertTrue((boolean)sTFS.exists(fileA));
        Assert.assertTrue((boolean)sTFS.exists(dirA));
        Assert.assertTrue((boolean)sTFS.exists(finalDst));
        Assert.assertTrue((boolean)sUfs.isFile(PathUtils.concatPath((Object)sUfsRoot, (Object)"fileA")));
        Assert.assertTrue((boolean)sUfs.isDirectory(PathUtils.concatPath((Object)sUfsRoot, (Object)"dirA")));
        Assert.assertTrue((boolean)sUfs.isFile(PathUtils.concatPath((Object)sUfsRoot, (Object[])new Object[]{"dirA", "fileA"})));
        FileSystemRenameIntegrationTest.cleanup(sTFS);
        Assert.assertFalse((boolean)sTFS.exists(fileA));
        Assert.assertFalse((boolean)sTFS.exists(dirA));
        Assert.assertFalse((boolean)sTFS.exists(finalDst));
        Assert.assertFalse((boolean)sUfs.isFile(PathUtils.concatPath((Object)sUfsRoot, (Object)"fileA")));
        Assert.assertFalse((boolean)sUfs.isDirectory(PathUtils.concatPath((Object)sUfsRoot, (Object)"dirA")));
        Assert.assertFalse((boolean)sUfs.isFile(PathUtils.concatPath((Object)sUfsRoot, (Object[])new Object[]{"dirA", "fileA"})));
    }

    @Test
    @Ignore
    public void errorRenameTest4() throws Exception {
        Path fileA = new Path("/fileA");
        Path nonexistentPath = new Path("/doesNotExist/fileA");
        FileSystemRenameIntegrationTest.create(sTFS, fileA);
        Assert.assertFalse((boolean)sTFS.rename(fileA, nonexistentPath));
        Assert.assertTrue((boolean)sTFS.exists(fileA));
        Assert.assertTrue((boolean)sUfs.isFile(PathUtils.concatPath((Object)sUfsRoot, (Object)"fileA")));
        FileSystemRenameIntegrationTest.cleanup(sTFS);
        Assert.assertFalse((boolean)sTFS.exists(fileA));
        Assert.assertFalse((boolean)sUfs.isFile(PathUtils.concatPath((Object)sUfsRoot, (Object)"fileA")));
    }
}

