/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.rest;

import alluxio.AlluxioURI;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.client.rest.RestApiTest;
import alluxio.client.rest.TestCase;
import alluxio.client.rest.TestCaseOptions;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.WritePType;
import alluxio.master.file.FileSystemMaster;
import alluxio.master.file.contexts.GetStatusContext;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.security.authentication.AuthType;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.testutils.underfs.UnderFileSystemTestUtils;
import alluxio.util.CommonUtils;
import alluxio.util.FormatUtils;
import alluxio.util.WaitForOptions;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.wire.AlluxioMasterInfo;
import alluxio.wire.Capacity;
import alluxio.wire.MountPointInfo;
import alluxio.wire.WorkerInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

@Ignore(value="Block store is deprecated")
public final class AlluxioMasterRestApiTest
extends RestApiTest {
    private FileSystemMaster mFileSystemMaster;
    @ClassRule
    public static LocalAlluxioClusterResource sResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.SECURITY_AUTHORIZATION_PERMISSION_ENABLED, false).setProperty(PropertyKey.SECURITY_AUTHENTICATION_TYPE, AuthType.NOSASL).setProperty(PropertyKey.USER_FILE_BUFFER_BYTES, "1KB").build();
    @Rule
    public TestRule mResetRule = sResource.getResetResource();

    @Before
    public void before() {
        this.mFileSystemMaster = (FileSystemMaster)sResource.get().getLocalAlluxioMaster().getMasterProcess().getMaster(FileSystemMaster.class);
        this.mHostname = sResource.get().getHostname();
        this.mPort = sResource.get().getLocalAlluxioMaster().getMasterProcess().getWebAddress().getPort();
        this.mBaseUri = String.format("%s/%s", this.mBaseUri, "master");
    }

    private AlluxioMasterInfo getInfo(Map<String, String> params) throws Exception {
        String result = new TestCase(this.mHostname, this.mPort, this.mBaseUri, "info", params, "GET", TestCaseOptions.defaults()).runAndGetResponse();
        AlluxioMasterInfo info = (AlluxioMasterInfo)new ObjectMapper().readValue(result, AlluxioMasterInfo.class);
        return info;
    }

    private Map<String, String> getMetrics(Map<String, String> params) throws Exception {
        String result = new TestCase(this.mHostname, this.mPort, this.mBaseUri, "webui_metrics", params, "GET", TestCaseOptions.defaults()).runAndGetResponse();
        Map info = (Map)new ObjectMapper().readValue(result, Map.class);
        return info;
    }

    @Test
    public void getCapacity() throws Exception {
        long total = Configuration.getBytes((PropertyKey)PropertyKey.WORKER_RAMDISK_SIZE);
        Capacity capacity = this.getInfo(NO_PARAMS).getCapacity();
        Assert.assertEquals((long)total, (long)capacity.getTotal());
        Assert.assertEquals((long)0L, (long)capacity.getUsed());
    }

    @Test
    public void getConfiguration() throws Exception {
        String home = "home";
        String rawConfDir = String.format("${%s}/conf", "alluxio.home");
        String resolvedConfDir = String.format("%s/conf", home);
        Configuration.set((PropertyKey)PropertyKey.HOME, (Object)home);
        Configuration.set((PropertyKey)PropertyKey.CONF_DIR, (Object)rawConfDir);
        this.checkConfiguration(PropertyKey.CONF_DIR, resolvedConfDir, NO_PARAMS);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("raw_configuration", "false");
        this.checkConfiguration(PropertyKey.CONF_DIR, resolvedConfDir, params);
        params.put("raw_configuration", "true");
        this.checkConfiguration(PropertyKey.CONF_DIR, rawConfDir, params);
    }

    private void checkConfiguration(PropertyKey key, String expectedValue, Map<String, String> params) throws Exception {
        Assert.assertEquals((Object)expectedValue, this.getInfo(params).getConfiguration().get(key.toString()));
    }

    @Test
    public void getLostWorkers() throws Exception {
        List lostWorkersInfo = this.getInfo(NO_PARAMS).getLostWorkers();
        Assert.assertEquals((long)0L, (long)lostWorkersInfo.size());
    }

    @Test
    public void getMetricsInfo() throws Exception {
        long start = (Long)this.getInfo(NO_PARAMS).getMetrics().get(MetricsSystem.getMetricName((String)MetricKey.MASTER_FILE_INFOS_GOT.getName()));
        this.mFileSystemMaster.getFileInfo(new AlluxioURI("/"), GetStatusContext.defaults());
        Assert.assertEquals((Object)(start + 1L), this.getInfo(NO_PARAMS).getMetrics().get(MetricsSystem.getMetricName((String)MetricKey.MASTER_FILE_INFOS_GOT.getName())));
    }

    @Test
    public void getUfsMetrics() throws Exception {
        int len = 100;
        FileSystemTestUtils.createByteFile((FileSystem)sResource.get().getClient(), (String)"/f1", (WritePType)WritePType.THROUGH, (int)len);
        CommonUtils.waitFor((String)"Metrics to be updated correctly", () -> {
            try {
                return FormatUtils.getSizeFromBytes((long)len).equals(this.getMetrics(NO_PARAMS).get("totalBytesWrittenUfs"));
            }
            catch (Exception e) {
                return false;
            }
        }, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(2000L));
        FileSystemTestUtils.createByteFile((FileSystem)sResource.get().getClient(), (String)"/f2", (WritePType)WritePType.THROUGH, (int)len);
        CommonUtils.waitFor((String)"Metrics to be updated correctly", () -> {
            try {
                return FormatUtils.getSizeFromBytes((long)(2 * len)).equals(this.getMetrics(NO_PARAMS).get("totalBytesWrittenUfs"));
            }
            catch (Exception e) {
                return false;
            }
        }, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(2000L));
    }

    @Test
    public void getMountPoints() throws Exception {
        Map mountTable = this.mFileSystemMaster.getMountPointInfoSummary();
        Map mountPoints = this.getInfo(NO_PARAMS).getMountPoints();
        Assert.assertEquals((long)mountTable.size(), (long)mountPoints.size());
        for (Map.Entry mountPoint : mountTable.entrySet()) {
            Assert.assertTrue((boolean)mountPoints.containsKey(mountPoint.getKey()));
            String expectedUri = ((MountPointInfo)mountPoints.get(mountPoint.getKey())).getUfsUri();
            String returnedUri = ((MountPointInfo)mountPoint.getValue()).getUfsUri();
            Assert.assertEquals((Object)expectedUri, (Object)returnedUri);
        }
    }

    @Test
    public void getRpcAddress() throws Exception {
        Assert.assertTrue((boolean)this.getInfo(NO_PARAMS).getRpcAddress().contains(String.valueOf(NetworkAddressUtils.getPort((NetworkAddressUtils.ServiceAttributeProvider)NetworkAddressUtils.ServiceType.MASTER_RPC, (AlluxioConfiguration)Configuration.global()))));
    }

    @Test
    public void getStartTimeMs() throws Exception {
        Assert.assertTrue((this.getInfo(NO_PARAMS).getStartTimeMs() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void getTierCapacity() throws Exception {
        long total = Configuration.getBytes((PropertyKey)PropertyKey.WORKER_RAMDISK_SIZE);
        Capacity capacity = (Capacity)this.getInfo(NO_PARAMS).getTierCapacity().get("MEM");
        Assert.assertEquals((long)total, (long)capacity.getTotal());
        Assert.assertEquals((long)0L, (long)capacity.getUsed());
    }

    @Test
    public void getUptimeMs() throws Exception {
        Assert.assertTrue((this.getInfo(NO_PARAMS).getUptimeMs() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void getUfsCapacity() throws Exception {
        Capacity ufsCapacity = this.getInfo(NO_PARAMS).getUfsCapacity();
        if (UnderFileSystemTestUtils.isObjectStorage(this.mFileSystemMaster.getUfsAddress())) {
            Assert.assertEquals((long)-1L, (long)ufsCapacity.getTotal());
        } else {
            Assert.assertTrue((ufsCapacity.getTotal() > 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void getWorkers() throws Exception {
        List workerInfos = this.getInfo(NO_PARAMS).getWorkers();
        Assert.assertEquals((long)1L, (long)workerInfos.size());
        WorkerInfo workerInfo = (WorkerInfo)workerInfos.get(0);
        Assert.assertEquals((long)0L, (long)workerInfo.getUsedBytes());
        long bytes = Configuration.getBytes((PropertyKey)PropertyKey.WORKER_RAMDISK_SIZE);
        Assert.assertEquals((long)bytes, (long)workerInfo.getCapacityBytes());
    }

    @Test
    public void getVersion() throws Exception {
        Assert.assertEquals((Object)"303", (Object)this.getInfo(NO_PARAMS).getVersion());
    }
}

