/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.rest;

import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.rest.RestApiTest;
import alluxio.client.rest.TestCase;
import alluxio.client.rest.TestCaseOptions;
import alluxio.conf.PropertyKey;
import alluxio.grpc.ListAllPOptions;
import alluxio.job.JobConfig;
import alluxio.job.SleepJobConfig;
import alluxio.job.wire.Status;
import alluxio.master.LocalAlluxioJobCluster;
import alluxio.master.job.JobMaster;
import alluxio.security.authentication.AuthType;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.util.CommonUtils;
import alluxio.util.WaitForOptions;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.TimeoutException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.REMOVE, owner="jianjian", comment="remove if job master is deprecated")
public final class JobMasterClientRestApiTest
extends RestApiTest {
    private LocalAlluxioJobCluster mJobCluster;
    private JobMaster mJobMaster;
    @ClassRule
    public static LocalAlluxioClusterResource sResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.SECURITY_AUTHORIZATION_PERMISSION_ENABLED, false).setProperty(PropertyKey.SECURITY_AUTHENTICATION_TYPE, AuthType.NOSASL).setProperty(PropertyKey.USER_FILE_BUFFER_BYTES, "1KB").setProperty(PropertyKey.JOB_MASTER_WORKER_HEARTBEAT_INTERVAL, "10ms").setProperty(PropertyKey.JOB_MASTER_FINISHED_JOB_RETENTION_TIME, "0sec").build();
    @Rule
    public TestRule mResetRule = sResource.getResetResource();

    @Before
    public void before() throws Exception {
        this.mJobCluster = new LocalAlluxioJobCluster();
        this.mJobCluster.start();
        this.mJobMaster = this.mJobCluster.getMaster().getJobMaster();
        this.mHostname = this.mJobCluster.getHostname();
        this.mPort = this.mJobCluster.getMaster().getWebAddress().getPort();
        this.mBaseUri = String.format("%s/%s", this.mBaseUri, "master/job");
    }

    @After
    public void after() throws Exception {
        this.mJobCluster.stop();
    }

    @Test
    public void serviceName() throws Exception {
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, "service_name", NO_PARAMS, "GET", TestCaseOptions.defaults().setContentType("application/json")).runAndCheckResult("JobMasterClient");
    }

    @Test
    public void serviceVersion() throws Exception {
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, "service_version", NO_PARAMS, "GET", TestCaseOptions.defaults().setContentType("application/json")).runAndCheckResult(1);
    }

    @Test
    public void run() throws Exception {
        long jobId = this.startJob((JobConfig)new SleepJobConfig(200L));
        Assert.assertEquals((long)1L, (long)this.mJobMaster.list(ListAllPOptions.getDefaultInstance()).size());
        this.waitForStatus(jobId, Status.COMPLETED);
    }

    @Test
    public void cancel() throws Exception {
        long jobId = this.startJob((JobConfig)new SleepJobConfig(10000L));
        CommonUtils.sleepMs((long)30L);
        HashMap params = Maps.newHashMap();
        params.put("jobId", Long.toString(jobId));
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, "cancel", params, "POST", TestCaseOptions.defaults().setContentType("application/json")).runAndCheckResult();
        this.waitForStatus(jobId, Status.CANCELED);
    }

    @Test
    public void listEmpty() throws Exception {
        ArrayList empty = Lists.newArrayList();
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, "list", NO_PARAMS, "GET", TestCaseOptions.defaults().setContentType("application/json")).runAndCheckResult(empty);
    }

    @Test
    public void getStatus() throws Exception {
        SleepJobConfig config = new SleepJobConfig(1000L);
        long jobId = this.startJob((JobConfig)config);
        HashMap params = Maps.newHashMap();
        params.put("jobId", Long.toString(jobId));
        TestCaseOptions options = TestCaseOptions.defaults().setContentType("application/json").setPrettyPrint(true);
        String result = new TestCase(this.mHostname, this.mPort, this.mBaseUri, "get_status", params, "GET", options).runAndGetResponse();
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        HashMap jobInfo = (HashMap)new ObjectMapper().readValue(result, (TypeReference)typeRef);
        Assert.assertEquals((Object)jobId, jobInfo.get("id"));
        Assert.assertEquals((long)1L, (long)((Collection)jobInfo.get("children")).size());
    }

    private long startJob(JobConfig config) throws Exception {
        TestCaseOptions options = TestCaseOptions.defaults().setBody(config).setContentType("application/json");
        String result = new TestCase(this.mHostname, this.mPort, this.mBaseUri, "run", NO_PARAMS, "POST", options).runAndGetResponse();
        return (Long)new ObjectMapper().readValue(result, Long.TYPE);
    }

    private void waitForStatus(long jobId, Status status) throws InterruptedException, TimeoutException {
        CommonUtils.waitFor((String)"Waiting for job status", () -> {
            try {
                return this.mJobMaster.getStatus(jobId).getStatus() == status;
            }
            catch (Exception e) {
                Throwables.propagate((Throwable)e);
                return null;
            }
        }, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(10000L));
    }
}

