/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.rest;

import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.rest.RestApiTest;
import alluxio.client.rest.TestCase;
import alluxio.client.rest.TestCaseOptions;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.master.LocalAlluxioJobCluster;
import alluxio.security.authentication.AuthType;
import alluxio.testutils.LocalAlluxioClusterResource;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.REMOVE, owner="jianjian", comment="remove if job master is deprecated")
public final class JobMasterRestApiTest
extends RestApiTest {
    private LocalAlluxioJobCluster mJobCluster;
    @Rule
    public LocalAlluxioClusterResource mResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.SECURITY_AUTHORIZATION_PERMISSION_ENABLED, false).setProperty(PropertyKey.SECURITY_AUTHENTICATION_TYPE, AuthType.NOSASL).setProperty(PropertyKey.USER_FILE_BUFFER_BYTES, "1KB").build();

    @Before
    public void before() throws Exception {
        this.mJobCluster = new LocalAlluxioJobCluster();
        this.mJobCluster.start();
        this.mHostname = this.mJobCluster.getHostname();
        this.mPort = this.mJobCluster.getMaster().getWebAddress().getPort();
        this.mBaseUri = String.format("%s/%s", this.mBaseUri, "job_master");
    }

    @After
    public void after() throws Exception {
        this.mJobCluster.stop();
        Configuration.reloadProperties();
    }

    @Test
    public void getInfo() throws Exception {
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, "info", NO_PARAMS, "GET", TestCaseOptions.defaults()).runAndGetResponse();
    }
}

