/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.rest;

import alluxio.AlluxioURI;
import alluxio.client.WriteType;
import alluxio.client.file.FileSystem;
import alluxio.client.rest.RestApiTest;
import alluxio.client.rest.TestCase;
import alluxio.conf.PropertyKey;
import alluxio.grpc.Bits;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.ListStatusPOptions;
import alluxio.grpc.PMode;
import alluxio.grpc.SetAttributePOptions;
import alluxio.master.file.FileSystemMaster;
import alluxio.proxy.s3.S3RestUtils;
import alluxio.s3.ListBucketOptions;
import alluxio.s3.ListBucketResult;
import alluxio.s3.S3Error;
import alluxio.security.authentication.AuthType;
import alluxio.security.authentication.AuthenticatedClientUser;
import alluxio.security.authorization.Mode;
import alluxio.security.authorization.ModeParser;
import alluxio.testutils.LocalAlluxioClusterResource;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;

public class ListStatusTest
extends RestApiTest {
    private FileSystem mFileSystem;
    private FileSystemMaster mFileSystemMaster;
    @ClassRule
    public static LocalAlluxioClusterResource sResource = new LocalAlluxioClusterResource.Builder().setIncludeProxy(true).setProperty(PropertyKey.SECURITY_AUTHORIZATION_PERMISSION_ENABLED, true).setProperty(PropertyKey.SECURITY_AUTHENTICATION_TYPE, AuthType.SIMPLE).setProperty(PropertyKey.S3_REST_AUTHENTICATION_ENABLED, false).setProperty(PropertyKey.USER_FILE_BUFFER_BYTES, "1KB").setProperty(PropertyKey.PROXY_S3_WRITE_TYPE, WriteType.MUST_CACHE.name()).setProperty(PropertyKey.PROXY_S3_COMPLETE_MULTIPART_UPLOAD_MIN_PART_SIZE, "0").setProperty(PropertyKey.PROXY_S3_TAGGING_RESTRICTIONS_ENABLED, true).setProperty(PropertyKey.PROXY_S3_BUCKET_NAMING_RESTRICTIONS_ENABLED, false).setProperty(PropertyKey.PROXY_S3_MULTIPART_UPLOAD_CLEANER_ENABLED, false).setProperty(PropertyKey.PROXY_S3_COMPLETE_MULTIPART_UPLOAD_KEEPALIVE_ENABLED, false).build();
    @Rule
    public TestRule mResetRule = sResource.getResetResource();
    @Rule
    public TemporaryFolder mFolder = new TemporaryFolder();

    @Before
    public void before() throws Exception {
        this.mHostname = sResource.get().getHostname();
        this.mPort = sResource.get().getProxyProcess().getWebLocalPort();
        this.mFileSystemMaster = (FileSystemMaster)sResource.get().getLocalAlluxioMaster().getMasterProcess().getMaster(FileSystemMaster.class);
        this.mBaseUri = String.format("%s/%s", this.mBaseUri, "s3");
        Mode mode = ModeParser.parse((String)"777");
        SetAttributePOptions options = SetAttributePOptions.newBuilder().setMode(mode.toProto()).build();
        CreateFilePOptions filePOptions = CreateFilePOptions.newBuilder().setRecursive(true).setMode(PMode.newBuilder().setOwnerBits(Bits.ALL).setGroupBits(Bits.ALL).setOtherBits(Bits.NONE).build()).setWriteType(S3RestUtils.getS3WriteType()).setOverwrite(true).build();
        if (System.getProperty("user.name").isEmpty()) {
            sResource.setProperty(PropertyKey.SECURITY_AUTHORIZATION_PERMISSION_ENABLED, false);
        } else {
            AuthenticatedClientUser.set((String)System.getProperty("user.name"));
        }
        this.mFileSystem = sResource.get().getClient();
        this.mFileSystem.setAttribute(new AlluxioURI("/"), options);
        this.mFileSystem.createDirectory(new AlluxioURI("/bucket"));
        this.mFileSystem.createDirectory(new AlluxioURI("/bucket/folder0"));
        this.mFileSystem.createDirectory(new AlluxioURI("/bucket/folder1"));
        this.mFileSystem.createFile(new AlluxioURI("/bucket/file0"), filePOptions);
        this.mFileSystem.createFile(new AlluxioURI("/bucket/file1"), filePOptions);
        this.mFileSystem.createFile(new AlluxioURI("/bucket/folder0/file0"), filePOptions);
        this.mFileSystem.createFile(new AlluxioURI("/bucket/folder0/file1"), filePOptions);
    }

    @Test
    public void listWithoutParams() throws Exception {
        List statuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(true).build());
        ListBucketResult expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults());
        Assert.assertEquals((long)6L, (long)expected.getContents().size());
        Assert.assertEquals((Object)"file0", (Object)((ListBucketResult.Content)expected.getContents().get(0)).getKey());
        Assert.assertEquals((Object)"file1", (Object)((ListBucketResult.Content)expected.getContents().get(1)).getKey());
        Assert.assertEquals((Object)"folder0/", (Object)((ListBucketResult.Content)expected.getContents().get(2)).getKey());
        Assert.assertEquals((Object)"folder0/file0", (Object)((ListBucketResult.Content)expected.getContents().get(3)).getKey());
        Assert.assertEquals((Object)"folder0/file1", (Object)((ListBucketResult.Content)expected.getContents().get(4)).getKey());
        Assert.assertEquals((Object)"folder1/", (Object)((ListBucketResult.Content)expected.getContents().get(5)).getKey());
        Assert.assertNull((Object)expected.getCommonPrefixes());
        this.listTestCase("bucket", NO_PARAMS).checkResponse(expected);
    }

    @Test
    public void listWithoutParamsV2() throws Exception {
        List statuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(true).build());
        ListBucketResult expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setListType(Integer.valueOf(2)));
        Assert.assertEquals((long)6L, (long)expected.getKeyCount().intValue());
        Assert.assertEquals((long)6L, (long)expected.getContents().size());
        Assert.assertEquals((Object)"file0", (Object)((ListBucketResult.Content)expected.getContents().get(0)).getKey());
        Assert.assertEquals((Object)"file1", (Object)((ListBucketResult.Content)expected.getContents().get(1)).getKey());
        Assert.assertEquals((Object)"folder0/", (Object)((ListBucketResult.Content)expected.getContents().get(2)).getKey());
        Assert.assertEquals((Object)"folder0/file0", (Object)((ListBucketResult.Content)expected.getContents().get(3)).getKey());
        Assert.assertEquals((Object)"folder0/file1", (Object)((ListBucketResult.Content)expected.getContents().get(4)).getKey());
        Assert.assertEquals((Object)"folder1/", (Object)((ListBucketResult.Content)expected.getContents().get(5)).getKey());
        Assert.assertNull((Object)expected.getCommonPrefixes());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("list-type", "2");
        this.listTestCase("bucket", parameters).checkResponse(expected);
    }

    @Test
    public void listWithDelimiter() throws Exception {
        List statuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(true).build());
        ListBucketResult expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setDelimiter("/"));
        Assert.assertEquals((long)2L, (long)expected.getCommonPrefixes().size());
        Assert.assertEquals((Object)"folder0/", (Object)((ListBucketResult.CommonPrefix)expected.getCommonPrefixes().get(0)).getPrefix());
        Assert.assertEquals((Object)"folder1/", (Object)((ListBucketResult.CommonPrefix)expected.getCommonPrefixes().get(1)).getPrefix());
        Assert.assertEquals((long)2L, (long)expected.getContents().size());
        Assert.assertEquals((Object)"file0", (Object)((ListBucketResult.Content)expected.getContents().get(0)).getKey());
        Assert.assertEquals((Object)"file1", (Object)((ListBucketResult.Content)expected.getContents().get(1)).getKey());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("delimiter", "/");
        this.listTestCase("bucket", parameters).checkResponse(expected);
    }

    @Test
    public void listWithDelimiterV2() throws Exception {
        List statuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(true).build());
        ListBucketResult expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setListType(Integer.valueOf(2)).setDelimiter("/"));
        Assert.assertEquals((long)4L, (long)expected.getKeyCount().intValue());
        Assert.assertEquals((long)2L, (long)expected.getCommonPrefixes().size());
        Assert.assertEquals((Object)"folder0/", (Object)((ListBucketResult.CommonPrefix)expected.getCommonPrefixes().get(0)).getPrefix());
        Assert.assertEquals((Object)"folder1/", (Object)((ListBucketResult.CommonPrefix)expected.getCommonPrefixes().get(1)).getPrefix());
        Assert.assertEquals((long)2L, (long)expected.getContents().size());
        Assert.assertEquals((Object)"file0", (Object)((ListBucketResult.Content)expected.getContents().get(0)).getKey());
        Assert.assertEquals((Object)"file1", (Object)((ListBucketResult.Content)expected.getContents().get(1)).getKey());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("list-type", "2");
        parameters.put("delimiter", "/");
        this.listTestCase("bucket", parameters).checkResponse(expected);
    }

    @Test
    public void listWithPrefix() throws Exception {
        List statuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(true).build());
        ListBucketResult expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setPrefix("folder0"));
        Assert.assertEquals((Object)"folder0", (Object)expected.getPrefix());
        Assert.assertEquals((long)3L, (long)expected.getContents().size());
        Assert.assertEquals((Object)"folder0/", (Object)((ListBucketResult.Content)expected.getContents().get(0)).getKey());
        Assert.assertEquals((Object)"folder0/file0", (Object)((ListBucketResult.Content)expected.getContents().get(1)).getKey());
        Assert.assertEquals((Object)"folder0/file1", (Object)((ListBucketResult.Content)expected.getContents().get(2)).getKey());
        Assert.assertNull((Object)expected.getCommonPrefixes());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("prefix", "folder0");
        this.listTestCase("bucket", parameters).checkResponse(expected);
    }

    @Test
    public void listWithEmptyPrefix() throws Exception {
        List statuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(true).build());
        ListBucketResult expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setPrefix(""));
        Assert.assertEquals((Object)"", (Object)expected.getPrefix());
        Assert.assertEquals((long)6L, (long)expected.getContents().size());
        Assert.assertNull((Object)expected.getCommonPrefixes());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("prefix", "");
        this.listTestCase("bucket", parameters).checkResponse(expected);
    }

    @Test
    public void listWithNonExistentPrefix() throws Exception {
        List statuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(true).build());
        ListBucketResult expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setPrefix("aa"));
        Assert.assertEquals((Object)"aa", (Object)expected.getPrefix());
        Assert.assertEquals((long)0L, (long)expected.getContents().size());
        Assert.assertNull((Object)expected.getCommonPrefixes());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("prefix", "aa");
        this.listTestCase("bucket", parameters).checkResponse(expected);
    }

    @Test
    public void listWithPrefixV2() throws Exception {
        List statuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(true).build());
        ListBucketResult expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setListType(Integer.valueOf(2)).setPrefix("folder"));
        Assert.assertEquals((Object)"folder", (Object)expected.getPrefix());
        Assert.assertEquals((long)4L, (long)expected.getContents().size());
        Assert.assertEquals((Object)"folder0/", (Object)((ListBucketResult.Content)expected.getContents().get(0)).getKey());
        Assert.assertEquals((Object)"folder0/file0", (Object)((ListBucketResult.Content)expected.getContents().get(1)).getKey());
        Assert.assertEquals((Object)"folder0/file1", (Object)((ListBucketResult.Content)expected.getContents().get(2)).getKey());
        Assert.assertEquals((Object)"folder1/", (Object)((ListBucketResult.Content)expected.getContents().get(3)).getKey());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("list-type", "2");
        parameters.put("prefix", "folder");
        this.listTestCase("bucket", parameters).checkResponse(expected);
    }

    @Test
    public void listWithEmptyPrefixV2() throws Exception {
        List statuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(true).build());
        ListBucketResult expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setListType(Integer.valueOf(2)).setPrefix(""));
        Assert.assertEquals((Object)"", (Object)expected.getPrefix());
        Assert.assertEquals((long)6L, (long)expected.getContents().size());
        Assert.assertNull((Object)expected.getCommonPrefixes());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("list-type", "2");
        parameters.put("prefix", "");
        this.listTestCase("bucket", parameters).checkResponse(expected);
    }

    @Test
    public void listWithNonExistentPrefixV2() throws Exception {
        List statuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(true).build());
        ListBucketResult expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setListType(Integer.valueOf(2)).setPrefix("file1/"));
        Assert.assertEquals((Object)"file1/", (Object)expected.getPrefix());
        Assert.assertEquals((long)0L, (long)expected.getContents().size());
        Assert.assertNull((Object)expected.getCommonPrefixes());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("list-type", "2");
        parameters.put("prefix", "file1/");
        this.listTestCase("bucket", parameters).checkResponse(expected);
    }

    @Test
    public void listWithPrefixAndDelimiter() throws Exception {
        List statuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(true).build());
        ListBucketResult expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setPrefix("f").setDelimiter("/"));
        Assert.assertEquals((Object)"f", (Object)expected.getPrefix());
        Assert.assertEquals((Object)"/", (Object)expected.getDelimiter());
        Assert.assertEquals((long)2L, (long)expected.getCommonPrefixes().size());
        Assert.assertEquals((Object)"folder0/", (Object)((ListBucketResult.CommonPrefix)expected.getCommonPrefixes().get(0)).getPrefix());
        Assert.assertEquals((Object)"folder1/", (Object)((ListBucketResult.CommonPrefix)expected.getCommonPrefixes().get(1)).getPrefix());
        Assert.assertEquals((long)2L, (long)expected.getContents().size());
        Assert.assertEquals((Object)"file0", (Object)((ListBucketResult.Content)expected.getContents().get(0)).getKey());
        Assert.assertEquals((Object)"file1", (Object)((ListBucketResult.Content)expected.getContents().get(1)).getKey());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("prefix", "f");
        parameters.put("delimiter", "/");
        this.listTestCase("bucket", parameters).checkResponse(expected);
    }

    @Test
    public void listWithPrefixAndMaxKeys() throws Exception {
        List statuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(true).build());
        ListBucketResult expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setPrefix("f").setMaxKeys(3));
        Assert.assertTrue((boolean)expected.isTruncated());
        Assert.assertEquals((Object)"f", (Object)expected.getPrefix());
        Assert.assertEquals((long)3L, (long)expected.getMaxKeys());
        Assert.assertEquals((long)3L, (long)expected.getContents().size());
        Assert.assertEquals((Object)"file0", (Object)((ListBucketResult.Content)expected.getContents().get(0)).getKey());
        Assert.assertEquals((Object)"file1", (Object)((ListBucketResult.Content)expected.getContents().get(1)).getKey());
        Assert.assertEquals((Object)"folder0/", (Object)((ListBucketResult.Content)expected.getContents().get(2)).getKey());
        Assert.assertEquals((Object)"folder0/", (Object)expected.getNextMarker());
        Assert.assertNull((Object)expected.getCommonPrefixes());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("prefix", "f");
        parameters.put("max-keys", "3");
        this.listTestCase("bucket", parameters).checkResponse(expected);
    }

    @Test
    public void listWithPrefixAndDelimiterV2() throws Exception {
        List statuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(true).build());
        ListBucketResult expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setListType(Integer.valueOf(2)).setPrefix("folder").setDelimiter("/"));
        Assert.assertEquals((Object)"folder", (Object)expected.getPrefix());
        Assert.assertEquals((Object)"/", (Object)expected.getDelimiter());
        Assert.assertEquals((long)2L, (long)expected.getCommonPrefixes().size());
        Assert.assertEquals((Object)"folder0/", (Object)((ListBucketResult.CommonPrefix)expected.getCommonPrefixes().get(0)).getPrefix());
        Assert.assertEquals((Object)"folder1/", (Object)((ListBucketResult.CommonPrefix)expected.getCommonPrefixes().get(1)).getPrefix());
        Assert.assertEquals((long)0L, (long)expected.getContents().size());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("list-type", "2");
        parameters.put("prefix", "folder");
        parameters.put("delimiter", "/");
        this.listTestCase("bucket", parameters).checkResponse(expected);
    }

    @Test
    public void listWithPrefixAndMaxKeysV2() throws Exception {
        List statuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(true).build());
        ListBucketResult expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setListType(Integer.valueOf(2)).setPrefix("folder").setMaxKeys(2));
        Assert.assertTrue((boolean)expected.isTruncated());
        Assert.assertEquals((Object)"folder", (Object)expected.getPrefix());
        Assert.assertEquals((long)2L, (long)expected.getMaxKeys());
        Assert.assertEquals((long)2L, (long)expected.getKeyCount().intValue());
        Assert.assertEquals((Object)"folder0/", (Object)((ListBucketResult.Content)expected.getContents().get(0)).getKey());
        Assert.assertEquals((Object)"folder0/file0", (Object)((ListBucketResult.Content)expected.getContents().get(1)).getKey());
        Assert.assertEquals((Object)ListBucketResult.encodeToken((String)"folder0/file0"), (Object)expected.getNextContinuationToken());
        Assert.assertNull((Object)expected.getCommonPrefixes());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("list-type", "2");
        parameters.put("prefix", "folder");
        parameters.put("max-keys", "2");
        this.listTestCase("bucket", parameters).checkResponse(expected);
    }

    @Test
    public void listWithMarker() throws Exception {
        List statuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(true).build());
        ListBucketResult expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setMarker("file1"));
        Assert.assertEquals((Object)"file1", (Object)expected.getMarker());
        Assert.assertNull((Object)expected.getNextMarker());
        Assert.assertEquals((long)4L, (long)expected.getContents().size());
        Assert.assertEquals((Object)"folder0/", (Object)((ListBucketResult.Content)expected.getContents().get(0)).getKey());
        Assert.assertEquals((Object)"folder0/file0", (Object)((ListBucketResult.Content)expected.getContents().get(1)).getKey());
        Assert.assertEquals((Object)"folder0/file1", (Object)((ListBucketResult.Content)expected.getContents().get(2)).getKey());
        Assert.assertEquals((Object)"folder1/", (Object)((ListBucketResult.Content)expected.getContents().get(3)).getKey());
        Assert.assertNull((Object)expected.getCommonPrefixes());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("marker", "file1");
        this.listTestCase("bucket", parameters).checkResponse(expected);
    }

    @Test
    public void listWithPrefixAndMarker() throws Exception {
        List statuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(true).build());
        ListBucketResult expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setPrefix("folder0/f").setMarker("abc"));
        Assert.assertEquals((Object)"abc", (Object)expected.getMarker());
        Assert.assertEquals((Object)"folder0/f", (Object)expected.getPrefix());
        Assert.assertEquals((long)2L, (long)expected.getContents().size());
        Assert.assertEquals((Object)"folder0/file0", (Object)((ListBucketResult.Content)expected.getContents().get(0)).getKey());
        Assert.assertEquals((Object)"folder0/file1", (Object)((ListBucketResult.Content)expected.getContents().get(1)).getKey());
        Assert.assertNull((Object)expected.getCommonPrefixes());
        Assert.assertNull((Object)expected.getNextMarker());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("marker", "abc");
        parameters.put("prefix", "folder0/f");
        this.listTestCase("bucket", parameters).checkResponse(expected);
    }

    @Test
    public void listWithPrefixAndStartAfter() throws Exception {
        List statuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(true).build());
        ListBucketResult expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setPrefix("folder0").setStartAfter("fa").setListType(Integer.valueOf(2)));
        Assert.assertEquals((Object)"fa", (Object)expected.getStartAfter());
        Assert.assertEquals((Object)"folder0", (Object)expected.getPrefix());
        Assert.assertEquals((long)3L, (long)expected.getContents().size());
        Assert.assertEquals((Object)"folder0/", (Object)((ListBucketResult.Content)expected.getContents().get(0)).getKey());
        Assert.assertEquals((Object)"folder0/file0", (Object)((ListBucketResult.Content)expected.getContents().get(1)).getKey());
        Assert.assertEquals((Object)"folder0/file1", (Object)((ListBucketResult.Content)expected.getContents().get(2)).getKey());
        Assert.assertNull((Object)expected.getCommonPrefixes());
        Assert.assertNull((Object)expected.getNextMarker());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("list-type", "2");
        parameters.put("start-after", "fa");
        parameters.put("prefix", "folder0");
        this.listTestCase("bucket", parameters).checkResponse(expected);
    }

    @Test
    public void listWithContinuationToken() throws Exception {
        List statuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(true).build());
        ListBucketResult expected1 = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setMaxKeys(1).setListType(Integer.valueOf(2)));
        String priorContinuationToken = expected1.getNextContinuationToken();
        ListBucketResult expected2 = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setListType(Integer.valueOf(2)).setContinuationToken(priorContinuationToken));
        Assert.assertEquals((Object)ListBucketResult.encodeToken((String)"file0"), (Object)priorContinuationToken);
        Assert.assertEquals((Object)priorContinuationToken, (Object)expected2.getContinuationToken());
        Assert.assertEquals((long)5L, (long)expected2.getContents().size());
        Assert.assertEquals((long)5L, (long)expected2.getKeyCount().intValue());
        Assert.assertNull((Object)expected2.getCommonPrefixes());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("list-type", "2");
        parameters.put("continuation-token", priorContinuationToken);
        this.listTestCase("bucket", parameters).checkResponse(expected2);
    }

    @Test
    public void listWithStartAfter() throws Exception {
        List statuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(true).build());
        ListBucketResult expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setListType(Integer.valueOf(2)).setStartAfter("file0"));
        Assert.assertEquals((Object)"file0", (Object)expected.getStartAfter());
        Assert.assertEquals((long)5L, (long)expected.getContents().size());
        Assert.assertEquals((long)5L, (long)expected.getKeyCount().intValue());
        Assert.assertEquals((Object)"file1", (Object)((ListBucketResult.Content)expected.getContents().get(0)).getKey());
        Assert.assertEquals((Object)"folder0/", (Object)((ListBucketResult.Content)expected.getContents().get(1)).getKey());
        Assert.assertEquals((Object)"folder0/file0", (Object)((ListBucketResult.Content)expected.getContents().get(2)).getKey());
        Assert.assertEquals((Object)"folder0/file1", (Object)((ListBucketResult.Content)expected.getContents().get(3)).getKey());
        Assert.assertEquals((Object)"folder1/", (Object)((ListBucketResult.Content)expected.getContents().get(4)).getKey());
        Assert.assertNull((Object)expected.getCommonPrefixes());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("list-type", "2");
        parameters.put("start-after", "file0");
        this.listTestCase("bucket", parameters).checkResponse(expected);
    }

    @Test
    public void listWithMarkerAndDelimiter() throws Exception {
        List statuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(true).build());
        ListBucketResult expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setMarker("file1").setDelimiter("/"));
        Assert.assertEquals((Object)"file1", (Object)expected.getMarker());
        Assert.assertNull((Object)expected.getNextMarker());
        Assert.assertEquals((long)0L, (long)expected.getContents().size());
        Assert.assertEquals((long)2L, (long)expected.getCommonPrefixes().size());
        Assert.assertEquals((Object)"folder0/", (Object)((ListBucketResult.CommonPrefix)expected.getCommonPrefixes().get(0)).getPrefix());
        Assert.assertEquals((Object)"folder1/", (Object)((ListBucketResult.CommonPrefix)expected.getCommonPrefixes().get(1)).getPrefix());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("marker", "file1");
        parameters.put("delimiter", "/");
        this.listTestCase("bucket", parameters).checkResponse(expected);
    }

    @Test
    public void listWithContinuationTokenAndDelimiter() throws Exception {
        List statuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(true).build());
        ListBucketResult expected1 = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setMaxKeys(1).setListType(Integer.valueOf(2)));
        String priorContinuationToken = expected1.getNextContinuationToken();
        ListBucketResult expected2 = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setListType(Integer.valueOf(2)).setContinuationToken(priorContinuationToken).setDelimiter("/"));
        Assert.assertEquals((Object)ListBucketResult.encodeToken((String)"file0"), (Object)priorContinuationToken);
        Assert.assertEquals((Object)priorContinuationToken, (Object)expected2.getContinuationToken());
        Assert.assertEquals((long)3L, (long)expected2.getKeyCount().intValue());
        Assert.assertEquals((long)1L, (long)expected2.getContents().size());
        Assert.assertEquals((long)2L, (long)expected2.getCommonPrefixes().size());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("list-type", "2");
        parameters.put("delimiter", "/");
        parameters.put("continuation-token", priorContinuationToken);
        this.listTestCase("bucket", parameters).checkResponse(expected2);
    }

    @Test
    public void listWithStartAfterAndDelimiter() throws Exception {
        List statuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(true).build());
        ListBucketResult expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setListType(Integer.valueOf(2)).setStartAfter("file0").setDelimiter("/"));
        Assert.assertEquals((Object)"file0", (Object)expected.getStartAfter());
        Assert.assertEquals((long)3L, (long)expected.getKeyCount().intValue());
        Assert.assertEquals((long)1L, (long)expected.getContents().size());
        Assert.assertEquals((Object)"file1", (Object)((ListBucketResult.Content)expected.getContents().get(0)).getKey());
        Assert.assertEquals((long)2L, (long)expected.getCommonPrefixes().size());
        Assert.assertEquals((Object)"folder0/", (Object)((ListBucketResult.CommonPrefix)expected.getCommonPrefixes().get(0)).getPrefix());
        Assert.assertEquals((Object)"folder1/", (Object)((ListBucketResult.CommonPrefix)expected.getCommonPrefixes().get(1)).getPrefix());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("list-type", "2");
        parameters.put("start-after", "file0");
        parameters.put("delimiter", "/");
        this.listTestCase("bucket", parameters).checkResponse(expected);
    }

    @Test
    public void listNotTruncatedObjectsWithMaxKeys() throws Exception {
        List statuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(true).build());
        ListBucketResult expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setMaxKeys(10));
        Assert.assertEquals((long)10L, (long)expected.getMaxKeys());
        Assert.assertFalse((boolean)expected.isTruncated());
        Assert.assertEquals((long)6L, (long)expected.getContents().size());
        Assert.assertNull((Object)expected.getCommonPrefixes());
        Assert.assertNull((Object)expected.getNextMarker());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("max-keys", "10");
        this.listTestCase("bucket", parameters).checkResponse(expected);
    }

    @Test
    public void listNotTruncatedObjectsWithMaxKeysV2() throws Exception {
        List statuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(true).build());
        ListBucketResult expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setListType(Integer.valueOf(2)).setMaxKeys(10));
        Assert.assertEquals((long)10L, (long)expected.getMaxKeys());
        Assert.assertFalse((boolean)expected.isTruncated());
        Assert.assertEquals((long)6L, (long)expected.getContents().size());
        Assert.assertEquals((long)6L, (long)expected.getKeyCount().intValue());
        Assert.assertNull((Object)expected.getCommonPrefixes());
        Assert.assertNull((Object)expected.getNextContinuationToken());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("list-type", "2");
        parameters.put("max-keys", "10");
        this.listTestCase("bucket", parameters).checkResponse(expected);
    }

    @Test
    public void listTruncatedObjectsWithMaxKeys() throws Exception {
        List statuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(true).build());
        ListBucketResult expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setMaxKeys(3));
        Assert.assertEquals((long)3L, (long)expected.getMaxKeys());
        Assert.assertTrue((boolean)expected.isTruncated());
        Assert.assertEquals((long)3L, (long)expected.getContents().size());
        Assert.assertEquals((Object)"file0", (Object)((ListBucketResult.Content)expected.getContents().get(0)).getKey());
        Assert.assertEquals((Object)"file1", (Object)((ListBucketResult.Content)expected.getContents().get(1)).getKey());
        Assert.assertEquals((Object)"folder0/", (Object)((ListBucketResult.Content)expected.getContents().get(2)).getKey());
        Assert.assertEquals((Object)"folder0/", (Object)expected.getNextMarker());
        Assert.assertNull((Object)expected.getCommonPrefixes());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("max-keys", "3");
        this.listTestCase("bucket", parameters).checkResponse(expected);
    }

    @Test
    public void listTruncatedObjectsWithMaxKeysV2() throws Exception {
        List statuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(true).build());
        ListBucketResult expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setListType(Integer.valueOf(2)).setMaxKeys(3));
        Assert.assertEquals((long)3L, (long)expected.getMaxKeys());
        Assert.assertTrue((boolean)expected.isTruncated());
        Assert.assertEquals((long)3L, (long)expected.getContents().size());
        Assert.assertEquals((long)3L, (long)expected.getKeyCount().intValue());
        Assert.assertEquals((Object)"file0", (Object)((ListBucketResult.Content)expected.getContents().get(0)).getKey());
        Assert.assertEquals((Object)"file1", (Object)((ListBucketResult.Content)expected.getContents().get(1)).getKey());
        Assert.assertEquals((Object)"folder0/", (Object)((ListBucketResult.Content)expected.getContents().get(2)).getKey());
        Assert.assertEquals((Object)ListBucketResult.encodeToken((String)"folder0/"), (Object)expected.getNextContinuationToken());
        Assert.assertNull((Object)expected.getCommonPrefixes());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("list-type", "2");
        parameters.put("max-keys", "3");
        this.listTestCase("bucket", parameters).checkResponse(expected);
    }

    @Test
    public void listWithMaxKeysAndMarker() throws Exception {
        List statuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(true).build());
        ListBucketResult expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setMarker("file0").setMaxKeys(4));
        Assert.assertTrue((boolean)expected.isTruncated());
        Assert.assertEquals((Object)"file0", (Object)expected.getMarker());
        Assert.assertEquals((long)4L, (long)expected.getMaxKeys());
        Assert.assertEquals((long)4L, (long)expected.getContents().size());
        Assert.assertEquals((Object)"file1", (Object)((ListBucketResult.Content)expected.getContents().get(0)).getKey());
        Assert.assertEquals((Object)"folder0/", (Object)((ListBucketResult.Content)expected.getContents().get(1)).getKey());
        Assert.assertEquals((Object)"folder0/file0", (Object)((ListBucketResult.Content)expected.getContents().get(2)).getKey());
        Assert.assertEquals((Object)"folder0/file1", (Object)((ListBucketResult.Content)expected.getContents().get(3)).getKey());
        Assert.assertEquals((Object)"folder0/file1", (Object)expected.getNextMarker());
        Assert.assertNull((Object)expected.getCommonPrefixes());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("max-keys", "4");
        parameters.put("marker", "file0");
        this.listTestCase("bucket", parameters).checkResponse(expected);
    }

    @Test
    public void listWithMaxKeysAndStartAfter() throws Exception {
        List statuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(true).build());
        ListBucketResult expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setListType(Integer.valueOf(2)).setStartAfter("folder0/file0").setMaxKeys(4));
        Assert.assertFalse((boolean)expected.isTruncated());
        Assert.assertEquals((Object)"folder0/file0", (Object)expected.getStartAfter());
        Assert.assertEquals((long)4L, (long)expected.getMaxKeys());
        Assert.assertEquals((long)2L, (long)expected.getKeyCount().intValue());
        Assert.assertEquals((long)2L, (long)expected.getContents().size());
        Assert.assertEquals((Object)"folder0/file1", (Object)((ListBucketResult.Content)expected.getContents().get(0)).getKey());
        Assert.assertEquals((Object)"folder1/", (Object)((ListBucketResult.Content)expected.getContents().get(1)).getKey());
        Assert.assertNull((Object)expected.getNextContinuationToken());
        Assert.assertNull((Object)expected.getCommonPrefixes());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("list-type", "2");
        parameters.put("max-keys", "4");
        parameters.put("start-after", "folder0/file0");
        this.listTestCase("bucket", parameters).checkResponse(expected);
    }

    @Test
    public void listWithMaxKeysAndDelimiter() throws Exception {
        List statuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(true).build());
        ListBucketResult expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setDelimiter("/").setMaxKeys(3));
        Assert.assertTrue((boolean)expected.isTruncated());
        Assert.assertEquals((long)3L, (long)expected.getMaxKeys());
        Assert.assertEquals((long)2L, (long)expected.getContents().size());
        Assert.assertEquals((Object)"file0", (Object)((ListBucketResult.Content)expected.getContents().get(0)).getKey());
        Assert.assertEquals((Object)"file1", (Object)((ListBucketResult.Content)expected.getContents().get(1)).getKey());
        Assert.assertEquals((long)1L, (long)expected.getCommonPrefixes().size());
        Assert.assertEquals((Object)"folder0/", (Object)((ListBucketResult.CommonPrefix)expected.getCommonPrefixes().get(0)).getPrefix());
        Assert.assertEquals((Object)"folder0/", (Object)expected.getNextMarker());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("max-keys", "3");
        parameters.put("delimiter", "/");
        this.listTestCase("bucket", parameters).checkResponse(expected);
    }

    @Test
    public void listWithMaxKeysAndDelimiterV2() throws Exception {
        List statuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(true).build());
        ListBucketResult expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setListType(Integer.valueOf(2)).setDelimiter("/").setMaxKeys(3));
        Assert.assertTrue((boolean)expected.isTruncated());
        Assert.assertEquals((long)3L, (long)expected.getMaxKeys());
        Assert.assertEquals((long)3L, (long)expected.getKeyCount().intValue());
        Assert.assertEquals((long)2L, (long)expected.getContents().size());
        Assert.assertEquals((Object)"file0", (Object)((ListBucketResult.Content)expected.getContents().get(0)).getKey());
        Assert.assertEquals((Object)"file1", (Object)((ListBucketResult.Content)expected.getContents().get(1)).getKey());
        Assert.assertEquals((long)1L, (long)expected.getCommonPrefixes().size());
        Assert.assertEquals((Object)"folder0/", (Object)((ListBucketResult.CommonPrefix)expected.getCommonPrefixes().get(0)).getPrefix());
        Assert.assertEquals((Object)ListBucketResult.encodeToken((String)"folder0/"), (Object)expected.getNextContinuationToken());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("list-type", "2");
        parameters.put("max-keys", "3");
        parameters.put("delimiter", "/");
        this.listTestCase("bucket", parameters).checkResponse(expected);
    }

    @Test
    public void listWithPrefixAndContinuationToken() throws Exception {
        List statuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(true).build());
        ListBucketResult expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setListType(Integer.valueOf(2)).setMaxKeys(2));
        String priorContinuationToken = expected.getNextContinuationToken();
        ListBucketResult expected2 = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setListType(Integer.valueOf(2)).setContinuationToken(priorContinuationToken).setPrefix("folder"));
        Assert.assertTrue((boolean)expected.isTruncated());
        Assert.assertEquals((long)2L, (long)expected.getKeyCount().intValue());
        Assert.assertEquals((Object)"file0", (Object)((ListBucketResult.Content)expected.getContents().get(0)).getKey());
        Assert.assertEquals((Object)"file1", (Object)((ListBucketResult.Content)expected.getContents().get(1)).getKey());
        Assert.assertEquals((Object)ListBucketResult.encodeToken((String)"file1"), (Object)priorContinuationToken);
        Assert.assertEquals((Object)priorContinuationToken, (Object)expected2.getContinuationToken());
        Assert.assertEquals((long)4L, (long)expected2.getKeyCount().intValue());
        Assert.assertEquals((long)4L, (long)expected2.getContents().size());
        Assert.assertEquals((Object)"folder0/", (Object)((ListBucketResult.Content)expected2.getContents().get(0)).getKey());
        Assert.assertEquals((Object)"folder0/file0", (Object)((ListBucketResult.Content)expected2.getContents().get(1)).getKey());
        Assert.assertEquals((Object)"folder0/file1", (Object)((ListBucketResult.Content)expected2.getContents().get(2)).getKey());
        Assert.assertEquals((Object)"folder1/", (Object)((ListBucketResult.Content)expected2.getContents().get(3)).getKey());
        Assert.assertNull((Object)expected2.getCommonPrefixes());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("list-type", "2");
        parameters.put("prefix", "folder");
        parameters.put("continuation-token", priorContinuationToken);
        this.listTestCase("bucket", parameters).checkResponse(expected2);
    }

    @Test
    public void listBucketUnauthorized() throws Exception {
    }

    @Test
    public void headAndListNonExistentBucket() throws Exception {
        String bucketName = "non_existent_bucket";
        this.headTestCase(bucketName).checkResponseCode(Response.Status.NOT_FOUND.getStatusCode());
        HttpURLConnection connection2 = new TestCase(this.mHostname, this.mPort, this.mBaseUri, bucketName, NO_PARAMS, "GET", this.getDefaultOptionsWithAuth()).execute();
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)connection2.getResponseCode());
        S3Error response = (S3Error)new XmlMapper().readerFor(S3Error.class).readValue(connection2.getErrorStream());
        Assert.assertEquals((Object)bucketName, (Object)response.getResource());
        Assert.assertEquals((Object)"NoSuchBucket", (Object)response.getCode());
    }
}

