/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.rest;

import alluxio.client.rest.TestCase;
import alluxio.client.rest.TestCaseOptions;
import alluxio.s3.S3Constants;
import alluxio.testutils.BaseIntegrationTest;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import java.security.MessageDigest;
import java.util.Map;
import javax.validation.constraints.NotNull;

public abstract class RestApiTest
extends BaseIntegrationTest {
    protected static final Map<String, String> NO_PARAMS = ImmutableMap.of();
    protected static final byte[] EMPTY_CONTENT = new byte[0];
    protected static final String TEST_USER = "testuser";
    protected static final String TEST_BUCKET = "test-bucket";
    protected String mHostname;
    protected int mPort;
    protected String mBaseUri = "/api/v1";

    protected TestCase newTestCase(String bucket, Map<String, String> params, String httpMethod, TestCaseOptions options) throws Exception {
        return new TestCase(this.mHostname, this.mPort, this.mBaseUri, bucket, params, httpMethod, options);
    }

    protected TestCase createBucketTestCase(String bucket) throws Exception {
        return this.newTestCase(bucket, NO_PARAMS, "PUT", this.getDefaultOptionsWithAuth());
    }

    protected TestCase createObjectTestCase(String bucket, byte[] object) throws Exception {
        return this.newTestCase(bucket, NO_PARAMS, "PUT", this.getDefaultOptionsWithAuth().setBody(object).setMD5(this.computeObjectChecksum(object)));
    }

    protected TestCase createObjectTestCase(String bucket, TestCaseOptions options) throws Exception {
        return this.newTestCase(bucket, NO_PARAMS, "PUT", options);
    }

    protected TestCase copyObjectTestCase(String sourcePath, String targetPath) throws Exception {
        return this.newTestCase(targetPath, NO_PARAMS, "PUT", this.getDefaultOptionsWithAuth().addHeader("x-amz-metadata-directive", S3Constants.Directive.REPLACE.name()).addHeader("x-amz-copy-source", sourcePath));
    }

    protected TestCase deleteTestCase(String uri) throws Exception {
        return this.newTestCase(uri, NO_PARAMS, "DELETE", this.getDefaultOptionsWithAuth());
    }

    protected TestCase headTestCase(String uri) throws Exception {
        return this.newTestCase(uri, NO_PARAMS, "HEAD", this.getDefaultOptionsWithAuth());
    }

    protected TestCase getTestCase(String uri) throws Exception {
        return this.newTestCase(uri, NO_PARAMS, "GET", this.getDefaultOptionsWithAuth());
    }

    protected TestCase listTestCase(String uri, Map<String, String> params) throws Exception {
        return this.newTestCase(uri, params, "GET", this.getDefaultOptionsWithAuth().setContentType("application/xml"));
    }

    protected TestCaseOptions getDefaultOptionsWithAuth(@NotNull String user) {
        return TestCaseOptions.defaults().setAuthorization("AWS4-HMAC-SHA256 Credential=" + user + "/...");
    }

    protected TestCaseOptions getDefaultOptionsWithAuth() {
        return this.getDefaultOptionsWithAuth(TEST_USER);
    }

    private String computeObjectChecksum(byte[] objectContent) throws Exception {
        MessageDigest md5Hash = MessageDigest.getInstance("MD5");
        byte[] md5Digest = md5Hash.digest(objectContent);
        return BaseEncoding.base64().encode(md5Digest);
    }
}

