/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.rest;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.WriteType;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.client.rest.RestApiTest;
import alluxio.client.rest.TestCase;
import alluxio.client.rest.TestCaseOptions;
import alluxio.conf.PropertyKey;
import alluxio.exception.FileDoesNotExistException;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.FreePOptions;
import alluxio.grpc.ListStatusPOptions;
import alluxio.grpc.SetAttributePOptions;
import alluxio.grpc.WritePType;
import alluxio.master.file.FileSystemMaster;
import alluxio.master.file.contexts.CreateDirectoryContext;
import alluxio.master.file.contexts.CreateFileContext;
import alluxio.master.file.contexts.GetStatusContext;
import alluxio.master.file.contexts.ListStatusContext;
import alluxio.proxy.s3.CompleteMultipartUploadRequest;
import alluxio.proxy.s3.CompleteMultipartUploadResult;
import alluxio.proxy.s3.InitiateMultipartUploadResult;
import alluxio.proxy.s3.ListMultipartUploadsResult;
import alluxio.proxy.s3.ListPartsResult;
import alluxio.proxy.s3.S3RestUtils;
import alluxio.s3.ListAllMyBucketsResult;
import alluxio.s3.ListBucketOptions;
import alluxio.s3.ListBucketResult;
import alluxio.s3.S3Constants;
import alluxio.s3.S3Error;
import alluxio.s3.S3ErrorCode;
import alluxio.s3.TaggingData;
import alluxio.security.authentication.AuthType;
import alluxio.security.authentication.AuthenticatedClientUser;
import alluxio.security.authorization.Mode;
import alluxio.security.authorization.ModeParser;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.util.CommonUtils;
import alluxio.wire.FileInfo;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.io.BaseEncoding;
import java.io.File;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="yuyang", comment="fix the tests")
public final class S3ClientRestApiTest
extends RestApiTest {
    private static final int DATA_SIZE = 16384;
    private static final int LARGE_DATA_SIZE = 262144;
    private static final GetStatusContext GET_STATUS_CONTEXT = GetStatusContext.defaults();
    private static final XmlMapper XML_MAPPER = new XmlMapper();
    private FileSystem mFileSystem;
    private FileSystemMaster mFileSystemMaster;
    @ClassRule
    public static LocalAlluxioClusterResource sResource = new LocalAlluxioClusterResource.Builder().setIncludeProxy(true).setProperty(PropertyKey.SECURITY_AUTHORIZATION_PERMISSION_ENABLED, true).setProperty(PropertyKey.SECURITY_AUTHENTICATION_TYPE, AuthType.SIMPLE).setProperty(PropertyKey.S3_REST_AUTHENTICATION_ENABLED, false).setProperty(PropertyKey.USER_FILE_BUFFER_BYTES, "1KB").setProperty(PropertyKey.PROXY_S3_WRITE_TYPE, WriteType.MUST_CACHE.name()).setProperty(PropertyKey.PROXY_S3_COMPLETE_MULTIPART_UPLOAD_MIN_PART_SIZE, "0").setProperty(PropertyKey.PROXY_S3_TAGGING_RESTRICTIONS_ENABLED, true).setProperty(PropertyKey.PROXY_S3_BUCKET_NAMING_RESTRICTIONS_ENABLED, false).setProperty(PropertyKey.PROXY_S3_MULTIPART_UPLOAD_CLEANER_ENABLED, false).setProperty(PropertyKey.PROXY_S3_COMPLETE_MULTIPART_UPLOAD_KEEPALIVE_ENABLED, false).build();
    @Rule
    public TestRule mResetRule = sResource.getResetResource();
    @Rule
    public TemporaryFolder mFolder = new TemporaryFolder();

    @Before
    public void before() throws Exception {
        this.mHostname = sResource.get().getHostname();
        this.mPort = sResource.get().getProxyProcess().getWebLocalPort();
        this.mFileSystemMaster = (FileSystemMaster)sResource.get().getLocalAlluxioMaster().getMasterProcess().getMaster(FileSystemMaster.class);
        this.mFileSystem = sResource.get().getClient();
        this.mBaseUri = String.format("%s/%s", this.mBaseUri, "s3");
        Mode mode = ModeParser.parse((String)"777");
        SetAttributePOptions options = SetAttributePOptions.newBuilder().setMode(mode.toProto()).build();
        this.mFileSystem.setAttribute(new AlluxioURI("/"), options);
        if (System.getProperty("user.name").isEmpty()) {
            sResource.setProperty(PropertyKey.SECURITY_AUTHORIZATION_PERMISSION_ENABLED, false);
        } else {
            AuthenticatedClientUser.set((String)System.getProperty("user.name"));
        }
    }

    @Deprecated
    public void listAllMyBuckets() throws Exception {
        AlluxioURI bucket0Path = new AlluxioURI("/bucket0");
        FileSystem fs0 = S3RestUtils.createFileSystemForUser((String)"user0", (FileSystem)this.mFileSystem);
        fs0.createDirectory(bucket0Path);
        SetAttributePOptions setAttributeOptions = SetAttributePOptions.newBuilder().setOwner("user0").build();
        this.mFileSystem.setAttribute(new AlluxioURI("/bucket0"), setAttributeOptions);
        URIStatus bucket0Status = fs0.getStatus(bucket0Path);
        AlluxioURI bucket1Path = new AlluxioURI("/bucket1");
        FileSystem fs1 = S3RestUtils.createFileSystemForUser((String)"user1", (FileSystem)this.mFileSystem);
        fs1.createDirectory(bucket1Path);
        setAttributeOptions = SetAttributePOptions.newBuilder().setOwner("user1").build();
        this.mFileSystem.setAttribute(new AlluxioURI("/bucket1"), setAttributeOptions);
        URIStatus bucket1Status = fs1.getStatus(bucket1Path);
        TestCaseOptions requestOptions = this.getDefaultOptionsWithAuth("user0").setContentType("application/xml");
        ListAllMyBucketsResult expected = new ListAllMyBucketsResult((List)Lists.newArrayList((Object[])new URIStatus[]{bucket0Status}));
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, "", NO_PARAMS, "GET", requestOptions).runAndCheckResult(expected);
        expected = new ListAllMyBucketsResult((List)Lists.newArrayList((Object[])new URIStatus[]{bucket1Status}));
        requestOptions = this.getDefaultOptionsWithAuth("user1").setContentType("application/xml");
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, "", NO_PARAMS, "GET", requestOptions).runAndCheckResult(expected);
        requestOptions.setAuthorization("");
        HttpURLConnection connection = new TestCase(this.mHostname, this.mPort, this.mBaseUri, "", NO_PARAMS, "GET", requestOptions).execute();
        Assert.assertEquals((long)400L, (long)connection.getResponseCode());
        S3Error response = (S3Error)new XmlMapper().readerFor(S3Error.class).readValue(connection.getErrorStream());
        Assert.assertEquals((Object)response.getCode(), (Object)S3ErrorCode.AUTHORIZATION_HEADER_MALFORMED.getCode());
    }

    @Test
    public void listBucket() throws Exception {
        this.mFileSystem.createDirectory(new AlluxioURI("/bucket"));
        this.mFileSystem.createDirectory(new AlluxioURI("/bucket/folder0"));
        this.mFileSystem.createDirectory(new AlluxioURI("/bucket/folder1"));
        this.mFileSystem.createFile(new AlluxioURI("/bucket/file0"));
        this.mFileSystem.createFile(new AlluxioURI("/bucket/file1"));
        this.mFileSystem.createFile(new AlluxioURI("/bucket/folder0/file0"));
        this.mFileSystem.createFile(new AlluxioURI("/bucket/folder0/file1"));
        List statuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(true).build());
        ListBucketResult expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults());
        Assert.assertEquals((long)6L, (long)expected.getContents().size());
        Assert.assertEquals((Object)"file0", (Object)((ListBucketResult.Content)expected.getContents().get(0)).getKey());
        Assert.assertEquals((Object)"file1", (Object)((ListBucketResult.Content)expected.getContents().get(1)).getKey());
        Assert.assertEquals((Object)"folder0/", (Object)((ListBucketResult.Content)expected.getContents().get(2)).getKey());
        Assert.assertEquals((Object)"folder0/file0", (Object)((ListBucketResult.Content)expected.getContents().get(3)).getKey());
        Assert.assertEquals((Object)"folder0/file1", (Object)((ListBucketResult.Content)expected.getContents().get(4)).getKey());
        Assert.assertEquals((Object)"folder1/", (Object)((ListBucketResult.Content)expected.getContents().get(5)).getKey());
        Assert.assertNull((Object)expected.getCommonPrefixes());
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, "bucket", NO_PARAMS, "GET", this.getDefaultOptionsWithAuth().setContentType("application/xml")).runAndCheckResult(expected);
        List delimStatuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(false).build());
        expected = new ListBucketResult("bucket", delimStatuses, ListBucketOptions.defaults().setDelimiter("/"));
        Assert.assertEquals((long)2L, (long)expected.getContents().size());
        Assert.assertEquals((Object)"file0", (Object)((ListBucketResult.Content)expected.getContents().get(0)).getKey());
        Assert.assertEquals((Object)"file1", (Object)((ListBucketResult.Content)expected.getContents().get(1)).getKey());
        Assert.assertEquals((long)2L, (long)expected.getCommonPrefixes().size());
        Assert.assertEquals((Object)"folder0/", (Object)((ListBucketResult.CommonPrefix)expected.getCommonPrefixes().get(0)).getPrefix());
        Assert.assertEquals((Object)"folder1/", (Object)((ListBucketResult.CommonPrefix)expected.getCommonPrefixes().get(1)).getPrefix());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("delimiter", "/");
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, "bucket", parameters, "GET", this.getDefaultOptionsWithAuth().setContentType("application/xml")).runAndCheckResult(expected);
        expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setPrefix("folder0"));
        Assert.assertEquals((long)3L, (long)expected.getContents().size());
        Assert.assertEquals((Object)"folder0/", (Object)((ListBucketResult.Content)expected.getContents().get(0)).getKey());
        Assert.assertEquals((Object)"folder0/file0", (Object)((ListBucketResult.Content)expected.getContents().get(1)).getKey());
        Assert.assertEquals((Object)"folder0/file1", (Object)((ListBucketResult.Content)expected.getContents().get(2)).getKey());
        Assert.assertNull((Object)expected.getCommonPrefixes());
        parameters.clear();
        parameters.put("prefix", "folder0");
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, "bucket", parameters, "GET", this.getDefaultOptionsWithAuth().setContentType("application/xml")).runAndCheckResult(expected);
        expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setListType(Integer.valueOf(2)).setStartAfter("file0"));
        Assert.assertEquals((long)5L, (long)expected.getContents().size());
        Assert.assertEquals((Object)"file1", (Object)((ListBucketResult.Content)expected.getContents().get(0)).getKey());
        Assert.assertEquals((Object)"folder0/", (Object)((ListBucketResult.Content)expected.getContents().get(1)).getKey());
        Assert.assertEquals((Object)"folder0/file0", (Object)((ListBucketResult.Content)expected.getContents().get(2)).getKey());
        Assert.assertEquals((Object)"folder0/file1", (Object)((ListBucketResult.Content)expected.getContents().get(3)).getKey());
        Assert.assertEquals((Object)"folder1/", (Object)((ListBucketResult.Content)expected.getContents().get(4)).getKey());
        Assert.assertNull((Object)expected.getCommonPrefixes());
        parameters.clear();
        parameters.put("list-type", "2");
        parameters.put("start-after", "file0");
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, "bucket", parameters, "GET", this.getDefaultOptionsWithAuth().setContentType("application/xml")).runAndCheckResult(expected);
    }

    @Test
    public void listBucketUnauthorized() throws Exception {
        String bucket = "bucket";
        this.createBucketRestCall("bucket");
        HttpURLConnection connection = new TestCase(this.mHostname, this.mPort, this.mBaseUri, "bucket", NO_PARAMS, "GET", this.getDefaultOptionsWithAuth("dummy")).execute();
        Assert.assertEquals((long)403L, (long)connection.getResponseCode());
        S3Error response = (S3Error)new XmlMapper().readerFor(S3Error.class).readValue(connection.getErrorStream());
        Assert.assertEquals((Object)response.getCode(), (Object)S3ErrorCode.ACCESS_DENIED_ERROR.getCode());
    }

    @Test
    public void listNonExistentBucket() throws Exception {
        String bucketName = "non_existent_bucket";
        HttpURLConnection connection = new TestCase(this.mHostname, this.mPort, this.mBaseUri, bucketName, NO_PARAMS, "GET", this.getDefaultOptionsWithAuth().setContentType("application/xml")).execute();
        Assert.assertEquals((long)404L, (long)connection.getResponseCode());
        S3Error response = (S3Error)new XmlMapper().readerFor(S3Error.class).readValue(connection.getErrorStream());
        Assert.assertEquals((Object)bucketName, (Object)response.getResource());
        Assert.assertEquals((Object)"NoSuchBucket", (Object)response.getCode());
    }

    @Test
    public void listBucketCommonPrefixes() throws Exception {
        AlluxioURI uri = new AlluxioURI("/bucket");
        this.mFileSystem.createDirectory(uri);
        this.mFileSystem.createDirectory(new AlluxioURI("/bucket/c_first_folder"));
        this.mFileSystem.createDirectory(new AlluxioURI("/bucket/d_next_folder"));
        this.mFileSystem.createFile(new AlluxioURI("/bucket/a_first_file"));
        this.mFileSystem.createFile(new AlluxioURI("/bucket/b_next_file"));
        this.mFileSystem.createFile(new AlluxioURI("/bucket/c_first_folder/file"));
        this.mFileSystem.createFile(new AlluxioURI("/bucket/d_next_folder/file"));
        this.mFileSystem.createFile(new AlluxioURI("/bucket/z_last_file"));
        List delimStatuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(false).build());
        ListBucketResult expected = new ListBucketResult("bucket", delimStatuses, ListBucketOptions.defaults().setMaxKeys(3).setDelimiter("/"));
        String nextMarker = expected.getNextMarker();
        Assert.assertEquals((long)3L, (long)expected.getMaxKeys());
        Assert.assertTrue((boolean)expected.isTruncated());
        Assert.assertEquals((Object)"c_first_folder/", (Object)nextMarker);
        Assert.assertEquals((long)2L, (long)expected.getContents().size());
        Assert.assertEquals((long)1L, (long)expected.getCommonPrefixes().size());
        Assert.assertEquals((Object)"a_first_file", (Object)((ListBucketResult.Content)expected.getContents().get(0)).getKey());
        Assert.assertEquals((Object)"b_next_file", (Object)((ListBucketResult.Content)expected.getContents().get(1)).getKey());
        Assert.assertEquals((Object)"c_first_folder/", (Object)((ListBucketResult.CommonPrefix)expected.getCommonPrefixes().get(0)).getPrefix());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("max-keys", "3");
        parameters.put("delimiter", "/");
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, "bucket", parameters, "GET", this.getDefaultOptionsWithAuth().setContentType("application/xml")).runAndCheckResult(expected);
        expected = new ListBucketResult("bucket", delimStatuses, ListBucketOptions.defaults().setMarker(nextMarker).setDelimiter("/"));
        Assert.assertFalse((boolean)expected.isTruncated());
        Assert.assertNull((Object)expected.getNextMarker());
        Assert.assertEquals((long)1L, (long)expected.getContents().size());
        Assert.assertEquals((long)1L, (long)expected.getCommonPrefixes().size());
        Assert.assertEquals((Object)"d_next_folder/", (Object)((ListBucketResult.CommonPrefix)expected.getCommonPrefixes().get(0)).getPrefix());
        Assert.assertEquals((Object)"z_last_file", (Object)((ListBucketResult.Content)expected.getContents().get(0)).getKey());
        parameters.remove("max-keys");
        parameters.put("marker", nextMarker);
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, "bucket", parameters, "GET", this.getDefaultOptionsWithAuth().setContentType("application/xml")).runAndCheckResult(expected);
    }

    @Test
    public void listBucketPagination() throws Exception {
        AlluxioURI uri = new AlluxioURI("/bucket");
        this.mFileSystem.createDirectory(uri);
        this.mFileSystem.createDirectory(new AlluxioURI("/bucket/folder0"));
        this.mFileSystem.createDirectory(new AlluxioURI("/bucket/folder1"));
        this.mFileSystem.createFile(new AlluxioURI("/bucket/file0"));
        this.mFileSystem.createFile(new AlluxioURI("/bucket/file1"));
        this.mFileSystem.createFile(new AlluxioURI("/bucket/folder0/file0"));
        this.mFileSystem.createFile(new AlluxioURI("/bucket/folder0/file1"));
        List statuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(true).build());
        ListBucketResult expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setMaxKeys(1));
        Assert.assertNull((Object)expected.getContinuationToken());
        Assert.assertNull((Object)expected.getStartAfter());
        String nextMarker = expected.getNextMarker();
        Assert.assertEquals((Object)"", (Object)expected.getMarker());
        Assert.assertEquals((Object)"file0", (Object)nextMarker);
        Assert.assertNull((Object)expected.getKeyCount());
        Assert.assertEquals((long)1L, (long)expected.getContents().size());
        Assert.assertEquals((Object)"file0", (Object)((ListBucketResult.Content)expected.getContents().get(0)).getKey());
        Assert.assertNull((Object)expected.getCommonPrefixes());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("max-keys", "1");
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, "bucket", parameters, "GET", this.getDefaultOptionsWithAuth().setContentType("application/xml")).runAndCheckResult(expected);
        String priorMarker = nextMarker;
        expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setMaxKeys(1).setMarker(nextMarker));
        nextMarker = expected.getNextMarker();
        Assert.assertEquals((Object)priorMarker, (Object)expected.getMarker());
        Assert.assertNull((Object)expected.getKeyCount());
        Assert.assertEquals((long)1L, (long)expected.getContents().size());
        Assert.assertEquals((Object)"file1", (Object)((ListBucketResult.Content)expected.getContents().get(0)).getKey());
        Assert.assertNull((Object)expected.getCommonPrefixes());
        parameters.put("marker", priorMarker);
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, "bucket", parameters, "GET", this.getDefaultOptionsWithAuth().setContentType("application/xml")).runAndCheckResult(expected);
        priorMarker = nextMarker;
        expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setMaxKeys(1).setMarker(nextMarker));
        nextMarker = expected.getNextMarker();
        Assert.assertEquals((Object)priorMarker, (Object)expected.getMarker());
        Assert.assertNull((Object)expected.getKeyCount());
        Assert.assertEquals((long)1L, (long)expected.getContents().size());
        Assert.assertEquals((Object)"folder0/", (Object)((ListBucketResult.Content)expected.getContents().get(0)).getKey());
        Assert.assertNull((Object)expected.getCommonPrefixes());
        parameters.put("marker", priorMarker);
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, "bucket", parameters, "GET", this.getDefaultOptionsWithAuth().setContentType("application/xml")).runAndCheckResult(expected);
        expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setMaxKeys(1).setListType(Integer.valueOf(2)));
        Assert.assertNull((Object)expected.getMarker());
        String nextContinuationToken = expected.getNextContinuationToken();
        Assert.assertNull((Object)expected.getContinuationToken());
        Assert.assertEquals((Object)ListBucketResult.encodeToken((String)"file0"), (Object)nextContinuationToken);
        Assert.assertEquals((long)1L, (long)expected.getKeyCount().intValue());
        Assert.assertEquals((long)1L, (long)expected.getContents().size());
        Assert.assertEquals((Object)"file0", (Object)((ListBucketResult.Content)expected.getContents().get(0)).getKey());
        Assert.assertNull((Object)expected.getCommonPrefixes());
        parameters.clear();
        parameters.put("max-keys", "1");
        parameters.put("list-type", "2");
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, "bucket", parameters, "GET", this.getDefaultOptionsWithAuth().setContentType("application/xml")).runAndCheckResult(expected);
        String priorContinuationToken = nextContinuationToken;
        expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setMaxKeys(1).setListType(Integer.valueOf(2)).setContinuationToken(nextContinuationToken));
        nextContinuationToken = expected.getNextContinuationToken();
        Assert.assertEquals((Object)priorContinuationToken, (Object)expected.getContinuationToken());
        Assert.assertEquals((Object)ListBucketResult.encodeToken((String)"file1"), (Object)nextContinuationToken);
        Assert.assertEquals((long)1L, (long)expected.getKeyCount().intValue());
        Assert.assertEquals((long)1L, (long)expected.getContents().size());
        Assert.assertEquals((Object)"file1", (Object)((ListBucketResult.Content)expected.getContents().get(0)).getKey());
        Assert.assertNull((Object)expected.getCommonPrefixes());
        parameters.put("continuation-token", priorContinuationToken);
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, "bucket", parameters, "GET", this.getDefaultOptionsWithAuth().setContentType("application/xml")).runAndCheckResult(expected);
        priorContinuationToken = nextContinuationToken;
        expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setMaxKeys(1).setListType(Integer.valueOf(2)).setContinuationToken(nextContinuationToken));
        nextContinuationToken = expected.getNextContinuationToken();
        Assert.assertEquals((Object)priorContinuationToken, (Object)expected.getContinuationToken());
        Assert.assertEquals((Object)ListBucketResult.encodeToken((String)"folder0/"), (Object)nextContinuationToken);
        Assert.assertEquals((long)1L, (long)expected.getKeyCount().intValue());
        Assert.assertEquals((long)1L, (long)expected.getContents().size());
        Assert.assertEquals((Object)"folder0/", (Object)((ListBucketResult.Content)expected.getContents().get(0)).getKey());
        Assert.assertNull((Object)expected.getCommonPrefixes());
        parameters.put("continuation-token", priorContinuationToken);
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, "bucket", parameters, "GET", this.getDefaultOptionsWithAuth().setContentType("application/xml")).runAndCheckResult(expected);
    }

    @Test
    public void listBucketExactlyMaxKeys() throws Exception {
        AlluxioURI uri = new AlluxioURI("/bucket");
        this.mFileSystem.createDirectory(uri);
        this.mFileSystem.createFile(new AlluxioURI("/bucket/file0"));
        this.mFileSystem.createFile(new AlluxioURI("/bucket/file1"));
        List statuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(true).build());
        ListBucketResult expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setMaxKeys(2));
        Assert.assertFalse((boolean)expected.isTruncated());
        Assert.assertNull((Object)expected.getStartAfter());
        Assert.assertNull((Object)expected.getContinuationToken());
        Assert.assertNull((Object)expected.getNextContinuationToken());
        Assert.assertEquals((Object)"", (Object)expected.getMarker());
        Assert.assertNull((Object)expected.getNextMarker());
        Assert.assertNull((Object)expected.getKeyCount());
        Assert.assertEquals((long)2L, (long)expected.getContents().size());
        Assert.assertEquals((Object)"file0", (Object)((ListBucketResult.Content)expected.getContents().get(0)).getKey());
        Assert.assertEquals((Object)"file1", (Object)((ListBucketResult.Content)expected.getContents().get(1)).getKey());
        Assert.assertNull((Object)expected.getCommonPrefixes());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("max-keys", "2");
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, "bucket", parameters, "GET", this.getDefaultOptionsWithAuth().setContentType("application/xml")).runAndCheckResult(expected);
        expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setMaxKeys(2).setListType(Integer.valueOf(2)));
        Assert.assertFalse((boolean)expected.isTruncated());
        Assert.assertNull((Object)expected.getStartAfter());
        Assert.assertNull((Object)expected.getContinuationToken());
        Assert.assertNull((Object)expected.getNextContinuationToken());
        Assert.assertNull((Object)expected.getMarker());
        Assert.assertNull((Object)expected.getNextMarker());
        Assert.assertEquals((long)2L, (long)expected.getKeyCount().intValue());
        Assert.assertEquals((long)2L, (long)expected.getContents().size());
        Assert.assertEquals((Object)"file0", (Object)((ListBucketResult.Content)expected.getContents().get(0)).getKey());
        Assert.assertEquals((Object)"file1", (Object)((ListBucketResult.Content)expected.getContents().get(1)).getKey());
        Assert.assertNull((Object)expected.getCommonPrefixes());
        parameters.put("list-type", "2");
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, "bucket", parameters, "GET", this.getDefaultOptionsWithAuth().setContentType("application/xml")).runAndCheckResult(expected);
        parameters.remove("list-type");
        this.mFileSystem.createDirectory(new AlluxioURI("/bucket/folder0"));
        this.mFileSystem.createFile(new AlluxioURI("/bucket/folder0/file0"));
        this.mFileSystem.createFile(new AlluxioURI("/bucket/folder0/file1"));
        List delimStatuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(false).build());
        expected = new ListBucketResult("bucket", delimStatuses, ListBucketOptions.defaults().setMaxKeys(3).setDelimiter("/"));
        Assert.assertFalse((boolean)expected.isTruncated());
        Assert.assertNull((Object)expected.getStartAfter());
        Assert.assertNull((Object)expected.getContinuationToken());
        Assert.assertNull((Object)expected.getNextContinuationToken());
        Assert.assertEquals((Object)"", (Object)expected.getMarker());
        Assert.assertNull((Object)expected.getNextMarker());
        Assert.assertNull((Object)expected.getKeyCount());
        Assert.assertEquals((Object)"/", (Object)expected.getDelimiter());
        Assert.assertEquals((long)2L, (long)expected.getContents().size());
        Assert.assertEquals((long)1L, (long)expected.getCommonPrefixes().size());
        Assert.assertEquals((Object)"file0", (Object)((ListBucketResult.Content)expected.getContents().get(0)).getKey());
        Assert.assertEquals((Object)"file1", (Object)((ListBucketResult.Content)expected.getContents().get(1)).getKey());
        Assert.assertEquals((Object)"folder0/", (Object)((ListBucketResult.CommonPrefix)expected.getCommonPrefixes().get(0)).getPrefix());
        parameters.put("max-keys", "3");
        parameters.put("delimiter", "/");
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, "bucket", parameters, "GET", this.getDefaultOptionsWithAuth().setContentType("application/xml")).runAndCheckResult(expected);
        expected = new ListBucketResult("bucket", delimStatuses, ListBucketOptions.defaults().setMaxKeys(3).setDelimiter("/").setListType(Integer.valueOf(2)));
        Assert.assertFalse((boolean)expected.isTruncated());
        Assert.assertNull((Object)expected.getStartAfter());
        Assert.assertNull((Object)expected.getContinuationToken());
        Assert.assertNull((Object)expected.getNextContinuationToken());
        Assert.assertNull((Object)expected.getMarker());
        Assert.assertNull((Object)expected.getNextMarker());
        Assert.assertEquals((long)3L, (long)expected.getKeyCount().intValue());
        Assert.assertEquals((long)2L, (long)expected.getContents().size());
        Assert.assertEquals((long)1L, (long)expected.getCommonPrefixes().size());
        Assert.assertEquals((Object)"file0", (Object)((ListBucketResult.Content)expected.getContents().get(0)).getKey());
        Assert.assertEquals((Object)"file1", (Object)((ListBucketResult.Content)expected.getContents().get(1)).getKey());
        Assert.assertEquals((Object)"folder0/", (Object)((ListBucketResult.CommonPrefix)expected.getCommonPrefixes().get(0)).getPrefix());
        parameters.put("list-type", "2");
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, "bucket", parameters, "GET", this.getDefaultOptionsWithAuth().setContentType("application/xml")).runAndCheckResult(expected);
    }

    @Test
    public void listBucketZeroMaxKeys() throws Exception {
        AlluxioURI uri = new AlluxioURI("/bucket");
        this.mFileSystem.createDirectory(uri);
        this.mFileSystem.createFile(new AlluxioURI("/bucket/file0"));
        this.mFileSystem.createFile(new AlluxioURI("/bucket/file1"));
        List statuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(true).build());
        ListBucketResult expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setMaxKeys(0));
        Assert.assertFalse((boolean)expected.isTruncated());
        Assert.assertNull((Object)expected.getStartAfter());
        Assert.assertNull((Object)expected.getContinuationToken());
        Assert.assertNull((Object)expected.getNextContinuationToken());
        Assert.assertEquals((Object)"", (Object)expected.getMarker());
        Assert.assertNull((Object)expected.getNextMarker());
        Assert.assertNull((Object)expected.getKeyCount());
        Assert.assertEquals((long)0L, (long)expected.getContents().size());
        Assert.assertNull((Object)expected.getCommonPrefixes());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("max-keys", "0");
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, "bucket", parameters, "GET", this.getDefaultOptionsWithAuth().setContentType("application/xml")).runAndCheckResult(expected);
        expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setMaxKeys(0).setListType(Integer.valueOf(2)));
        Assert.assertFalse((boolean)expected.isTruncated());
        Assert.assertNull((Object)expected.getStartAfter());
        Assert.assertNull((Object)expected.getContinuationToken());
        Assert.assertNull((Object)expected.getNextContinuationToken());
        Assert.assertNull((Object)expected.getMarker());
        Assert.assertNull((Object)expected.getNextMarker());
        Assert.assertEquals((long)0L, (long)expected.getKeyCount().intValue());
        Assert.assertEquals((long)0L, (long)expected.getContents().size());
        Assert.assertNull((Object)expected.getCommonPrefixes());
        parameters.put("list-type", "2");
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, "bucket", parameters, "GET", this.getDefaultOptionsWithAuth().setContentType("application/xml")).runAndCheckResult(expected);
    }

    @Test
    public void listBucketPrefixZeroMatches() throws Exception {
        this.mFileSystem.createDirectory(new AlluxioURI("/bucket"));
        List statuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(true).build());
        ListBucketResult expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults());
        Assert.assertEquals((long)0L, (long)expected.getContents().size());
        HashMap<String, String> parameters = new HashMap<String, String>();
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, "bucket", parameters, "GET", this.getDefaultOptionsWithAuth().setContentType("application/xml")).runAndCheckResult(expected);
        expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setPrefix(""));
        Assert.assertEquals((long)0L, (long)expected.getContents().size());
        parameters.put("prefix", "");
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, "bucket", parameters, "GET", this.getDefaultOptionsWithAuth().setContentType("application/xml")).runAndCheckResult(expected);
        this.mFileSystem.createFile(new AlluxioURI("/bucket/file0"));
        this.mFileSystem.createDirectory(new AlluxioURI("/bucket/file_store"));
        this.mFileSystem.createFile(new AlluxioURI("/bucket/file_store/file1"));
        statuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(true).build());
        expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults());
        Assert.assertEquals((long)3L, (long)expected.getContents().size());
        Assert.assertEquals((Object)"file0", (Object)((ListBucketResult.Content)expected.getContents().get(0)).getKey());
        Assert.assertEquals((Object)"file_store/", (Object)((ListBucketResult.Content)expected.getContents().get(1)).getKey());
        Assert.assertEquals((Object)"file_store/file1", (Object)((ListBucketResult.Content)expected.getContents().get(2)).getKey());
        parameters.remove("prefix");
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, "bucket", parameters, "GET", this.getDefaultOptionsWithAuth().setContentType("application/xml")).runAndCheckResult(expected);
        expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setPrefix(""));
        Assert.assertEquals((long)3L, (long)expected.getContents().size());
        Assert.assertEquals((Object)"file0", (Object)((ListBucketResult.Content)expected.getContents().get(0)).getKey());
        Assert.assertEquals((Object)"file_store/", (Object)((ListBucketResult.Content)expected.getContents().get(1)).getKey());
        Assert.assertEquals((Object)"file_store/file1", (Object)((ListBucketResult.Content)expected.getContents().get(2)).getKey());
        parameters.put("prefix", "");
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, "bucket", parameters, "GET", this.getDefaultOptionsWithAuth().setContentType("application/xml")).runAndCheckResult(expected);
        try {
            expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setPrefix("dne_folder/file"));
        }
        catch (Exception e) {
            statuses = new ArrayList();
            return;
        }
        Assert.assertEquals((long)0L, (long)expected.getContents().size());
        parameters.put("prefix", "dne_folder/file");
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, "bucket", parameters, "GET", this.getDefaultOptionsWithAuth().setContentType("application/xml")).runAndCheckResult(expected);
        statuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket"), ListStatusPOptions.newBuilder().setRecursive(false).build());
        expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setPrefix("file").setDelimiter("/"));
        Assert.assertEquals((long)1L, (long)expected.getContents().size());
        Assert.assertEquals((Object)"file0", (Object)((ListBucketResult.Content)expected.getContents().get(0)).getKey());
        Assert.assertEquals((long)1L, (long)expected.getCommonPrefixes().size());
        Assert.assertEquals((Object)"file_store/", (Object)((ListBucketResult.CommonPrefix)expected.getCommonPrefixes().get(0)).getPrefix());
        parameters.put("delimiter", "/");
        parameters.put("prefix", "file");
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, "bucket", parameters, "GET", this.getDefaultOptionsWithAuth().setContentType("application/xml")).runAndCheckResult(expected);
        try {
            statuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket/file_store/file1/"), ListStatusPOptions.newBuilder().setRecursive(false).build());
        }
        catch (Exception e) {
            statuses = new ArrayList();
            return;
        }
        expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setPrefix("file_store/file1/").setDelimiter("/"));
        Assert.assertEquals((long)0L, (long)expected.getContents().size());
        Assert.assertEquals((long)0L, (long)expected.getCommonPrefixes().size());
        parameters.put("prefix", "file_store/file1/");
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, "bucket", parameters, "GET", this.getDefaultOptionsWithAuth().setContentType("application/xml")).runAndCheckResult(expected);
        try {
            statuses = this.mFileSystem.listStatus(new AlluxioURI("/bucket/file_store/file2"), ListStatusPOptions.newBuilder().setRecursive(false).build());
        }
        catch (FileDoesNotExistException e) {
            statuses = new ArrayList();
            return;
        }
        expected = new ListBucketResult("bucket", statuses, ListBucketOptions.defaults().setPrefix("file_store/file2").setDelimiter("/"));
        Assert.assertEquals((long)0L, (long)expected.getContents().size());
        Assert.assertEquals((long)0L, (long)expected.getCommonPrefixes().size());
        parameters.put("prefix", "file_store/file2");
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, "bucket", parameters, "GET", this.getDefaultOptionsWithAuth().setContentType("application/xml")).runAndCheckResult(expected);
    }

    @Test
    public void headBucket() throws Exception {
        String bucket = "bucket-to-head";
        String nonExistingBucket = "non-existing-bucket";
        this.createBucketRestCall("bucket-to-head");
        AlluxioURI uri = new AlluxioURI("/bucket-to-head");
        Assert.assertTrue((boolean)this.mFileSystemMaster.listStatus(uri, ListStatusContext.defaults()).isEmpty());
        HttpURLConnection connection = this.headBucketRestCall("bucket-to-head");
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)connection.getResponseCode());
        connection = this.headBucketRestCall("non-existing-bucket");
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)connection.getResponseCode());
    }

    private void putBucket(String bucket) throws Exception {
        this.putBucket(bucket, "testuser");
    }

    private void putBucket(String bucket, String user) throws Exception {
        this.createBucketRestCall(bucket, user);
        AlluxioURI uri = new AlluxioURI("/" + bucket);
        Assert.assertTrue((boolean)this.mFileSystemMaster.listStatus(uri, ListStatusContext.defaults()).isEmpty());
    }

    @Test
    public void putBucket() throws Exception {
        this.putBucket("bucket", "dummy");
    }

    @Test
    public void putExistsBucket() throws Exception {
        String bucket = "bucket";
        this.putBucket(bucket);
        TestCaseOptions options = this.getDefaultOptionsWithAuth("dummy");
        HttpURLConnection connection = new TestCase(this.mHostname, this.mPort, this.mBaseUri, bucket, NO_PARAMS, "PUT", options).execute();
        Assert.assertEquals((long)Response.Status.CONFLICT.getStatusCode(), (long)connection.getResponseCode());
        S3Error response = (S3Error)new XmlMapper().readerFor(S3Error.class).readValue(connection.getErrorStream());
        Assert.assertEquals((Object)bucket, (Object)response.getResource());
        Assert.assertEquals((Object)"BucketAlreadyExists", (Object)response.getCode());
    }

    @Test
    public void deleteBucket() throws Exception {
        String bucket = "bucket_to_delete";
        this.putBucket(bucket);
        HttpURLConnection connection = this.deleteBucketRestCall(bucket);
        Assert.assertEquals((long)Response.Status.NO_CONTENT.getStatusCode(), (long)connection.getResponseCode());
        try {
            this.mFileSystemMaster.getFileInfo(new AlluxioURI("/" + bucket), GET_STATUS_CONTEXT);
        }
        catch (FileDoesNotExistException e) {
            return;
        }
        Assert.fail((String)"bucket should have been removed");
    }

    @Test
    public void deleteNonExistingBucket() throws Exception {
        String bucketName = "non-existing-bucket";
        try {
            this.deleteBucketRestCall("non-existing-bucket");
        }
        catch (AssertionError e) {
            return;
        }
        Assert.fail((String)"delete a non-existing bucket should fail");
    }

    @Test
    public void getNonExistingBucket() throws Exception {
        String bucketName = "root-level-file";
        this.mFileSystem.createFile(new AlluxioURI("/root-level-file"));
        try {
            new TestCase(this.mHostname, this.mPort, this.mBaseUri, "root-level-file", NO_PARAMS, "GET", this.getDefaultOptionsWithAuth().setContentType("application/xml")).runAndGetResponse();
        }
        catch (AssertionError e) {
            return;
        }
        Assert.fail((String)"GET on a non-existing bucket should fail");
    }

    @Test
    public void deleteNonEmptyBucket() throws Exception {
        String bucketName = "non-empty-bucket";
        this.createBucketRestCall("non-empty-bucket");
        AlluxioURI uri = new AlluxioURI("/non-empty-bucket");
        AlluxioURI fileUri = new AlluxioURI(uri.getPath() + "/file");
        this.mFileSystemMaster.createFile(fileUri, CreateFileContext.defaults());
        Assert.assertFalse((boolean)this.mFileSystemMaster.listStatus(uri, ListStatusContext.defaults()).isEmpty());
        try {
            this.deleteBucketRestCall("non-empty-bucket");
        }
        catch (AssertionError e) {
            return;
        }
        Assert.fail((String)"delete a non-empty bucket should fail");
    }

    private void createObject(String objectKey, byte[] object, String uploadId, Integer partNumber) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (uploadId != null) {
            params.put("uploadId", uploadId);
        }
        if (partNumber != null) {
            params.put("partNumber", partNumber.toString());
        }
        this.createObjectRestCall(objectKey, params, this.getDefaultOptionsWithAuth().setBody(object).setContentType("application/octet-stream").setMD5(this.computeObjectChecksum(object)));
    }

    private void putObjectTest(String bucket, String objectKey, byte[] object, String uploadId, Integer partNumber) throws Exception {
        String fullObjectKey = bucket + "/" + objectKey;
        this.createObject(fullObjectKey, object, uploadId, partNumber);
        AlluxioURI bucketURI = new AlluxioURI("/" + bucket);
        AlluxioURI objectURI = new AlluxioURI("/" + fullObjectKey);
        if (uploadId != null) {
            String tmpDir = S3RestUtils.getMultipartTemporaryDirForObject((String)bucketURI.getPath(), (String)objectKey, (String)uploadId);
            bucketURI = new AlluxioURI(tmpDir);
            objectURI = new AlluxioURI(tmpDir + "/" + partNumber.toString());
        }
        List fileInfos = this.mFileSystemMaster.listStatus(bucketURI, ListStatusContext.defaults());
        Assert.assertEquals((long)1L, (long)fileInfos.size());
        Assert.assertEquals((Object)objectURI.getPath(), (Object)((FileInfo)fileInfos.get(0)).getPath());
        FileInStream is = this.mFileSystem.openFile(objectURI);
        byte[] writtenObjectContent = IOUtils.toString((InputStream)is).getBytes();
        is.close();
        Assert.assertArrayEquals((byte[])object, (byte[])writtenObjectContent);
        Assert.assertNotNull((Object)((FileInfo)fileInfos.get(0)).getXAttr());
        Assert.assertEquals((Object)Hex.encodeHexString((byte[])MessageDigest.getInstance("MD5").digest(writtenObjectContent)), (Object)new String((byte[])((FileInfo)fileInfos.get(0)).getXAttr().get("s3_etag"), S3Constants.XATTR_STR_CHARSET));
    }

    @Test
    public void testGetDeletedObject() throws Exception {
        String bucket = "bucket";
        String objectKey = "object";
        String object = CommonUtils.randomAlphaNumString((int)16384);
        String fullObjectKey = bucket + "/" + objectKey;
        AlluxioURI bucketURI = new AlluxioURI("/" + bucket);
        AlluxioURI objectURI = new AlluxioURI("/" + fullObjectKey);
        this.createBucketRestCall(bucket);
        FileOutStream outStream = this.mFileSystem.createFile(objectURI, CreateFilePOptions.newBuilder().setWriteType(WritePType.CACHE_THROUGH).build());
        outStream.write(object.getBytes());
        outStream.close();
        this.mFileSystem.free(objectURI, FreePOptions.newBuilder().setForced(true).build());
        FileUtils.deleteQuietly((File)new File(sResource.get().getAlluxioHome() + "/underFSStorage/" + fullObjectKey));
        List fileInfos = this.mFileSystemMaster.listStatus(bucketURI, ListStatusContext.defaults());
        Assert.assertEquals((long)1L, (long)fileInfos.size());
        Assert.assertEquals((Object)objectURI.getPath(), (Object)((FileInfo)fileInfos.get(0)).getPath());
        HttpURLConnection connection = this.getObjectRestCallWithError(fullObjectKey);
        Assert.assertEquals((long)404L, (long)connection.getResponseCode());
        S3Error response = (S3Error)new XmlMapper().readerFor(S3Error.class).readValue(connection.getErrorStream());
        Assert.assertEquals((Object)"", (Object)response.getResource());
        Assert.assertEquals((Object)"NoSuchKey", (Object)response.getCode());
    }

    @Test
    public void putObjectToDeletedBucket() throws Exception {
        String object = CommonUtils.randomAlphaNumString((int)16384);
        this.createBucketRestCall("bucket");
        this.mFileSystem.delete(new AlluxioURI("/bucket"));
        HttpURLConnection connection = new TestCase(this.mHostname, this.mPort, this.mBaseUri, "bucket/object", NO_PARAMS, "PUT", this.getDefaultOptionsWithAuth().setBody(object.getBytes()).setContentType("application/octet-stream").setMD5(this.computeObjectChecksum(object.getBytes()))).execute();
        Assert.assertEquals((long)404L, (long)connection.getResponseCode());
        S3Error response = (S3Error)new XmlMapper().readerFor(S3Error.class).readValue(connection.getErrorStream());
        Assert.assertEquals((Object)"NoSuchBucket", (Object)response.getCode());
    }

    @Test
    public void putDirectoryToDeletedBucket() throws Exception {
        this.createBucketRestCall("bucket");
        this.mFileSystem.delete(new AlluxioURI("/bucket"));
        HttpURLConnection connection = new TestCase(this.mHostname, this.mPort, this.mBaseUri, "bucket/directory/", NO_PARAMS, "PUT", this.getDefaultOptionsWithAuth().setBody(new byte[0]).setContentType("application/octet-stream").setMD5(this.computeObjectChecksum(new byte[0]))).execute();
        Assert.assertEquals((long)404L, (long)connection.getResponseCode());
        S3Error response = (S3Error)new XmlMapper().readerFor(S3Error.class).readValue(connection.getErrorStream());
        Assert.assertEquals((Object)"NoSuchBucket", (Object)response.getCode());
    }

    @Test
    public void putDirectoryObject() throws Exception {
        String bucketName = "directory-bucket";
        this.createBucketRestCall("directory-bucket");
        String directoryName = "directory/";
        this.createObject("directory-bucket/directory/", new byte[0], null, null);
        List statuses = this.mFileSystem.listStatus(new AlluxioURI("/directory-bucket"));
        Assert.assertEquals((long)1L, (long)statuses.size());
        Assert.assertEquals((Object)true, (Object)((URIStatus)statuses.get(0)).isFolder());
    }

    @Test
    public void putSmallObject() throws Exception {
        String bucketName = "small-object-bucket";
        this.createBucketRestCall("small-object-bucket");
        String objectName = "object";
        this.putObjectTest("small-object-bucket", "object", "Hello World!".getBytes(), null, null);
    }

    @Test
    public void putLargeObject() throws Exception {
        String bucketName = "large-object-bucket";
        this.createBucketRestCall("large-object-bucket");
        String objectName = "object";
        byte[] object = CommonUtils.randomAlphaNumString((int)262144).getBytes();
        this.putObjectTest("large-object-bucket", "object", object, null, null);
    }

    @Test
    public void putObjectUnderNonExistentBucket() throws Exception {
        String bucket = "non-existent-bucket";
        String objectKey = "non-existent-bucket/object.txt";
        String message = "hello world";
        try {
            this.createObjectRestCall("non-existent-bucket/object.txt", NO_PARAMS, this.getDefaultOptionsWithAuth().setBody(message.getBytes()).setContentType("application/octet-stream").setMD5(this.computeObjectChecksum(message.getBytes())));
        }
        catch (AssertionError e) {
            return;
        }
        Assert.fail((String)"create object under non-existent bucket should fail");
    }

    @Test
    public void putObjectWithWrongMD5() throws Exception {
        String bucket = "bucket";
        this.createBucketRestCall("bucket");
        String objectKey = "bucket/object.txt";
        String objectContent = "hello world";
        try {
            String wrongMD5 = BaseEncoding.base64().encode(objectContent.getBytes());
            this.createObjectRestCall("bucket/object.txt", NO_PARAMS, this.getDefaultOptionsWithAuth().setBody(objectContent.getBytes()).setContentType("application/octet-stream").setMD5(wrongMD5));
        }
        catch (AssertionError e) {
            return;
        }
        Assert.fail((String)"create object with wrong Content-MD5 should fail");
    }

    @Test
    public void putObjectWithNoMD5() throws Exception {
        String bucket = "bucket";
        this.createBucketRestCall("bucket");
        String objectKey = "bucket/object.txt";
        String objectContent = "no md5 set";
        TestCaseOptions options = this.getDefaultOptionsWithAuth();
        options.setBody(objectContent.getBytes());
        options.setContentType("application/octet-stream");
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, "bucket/object.txt", NO_PARAMS, "PUT", options).runAndCheckResult();
    }

    private void getObjectTest(byte[] expectedObject) throws Exception {
        String bucket = "bucket";
        this.createBucketRestCall("bucket");
        String objectKey = "bucket/object.txt";
        this.createObjectRestCall("bucket/object.txt", NO_PARAMS, this.getDefaultOptionsWithAuth().setBody(expectedObject).setContentType("application/octet-stream").setMD5(this.computeObjectChecksum(expectedObject)));
        Assert.assertArrayEquals((byte[])expectedObject, (byte[])this.getObjectRestCall("bucket/object.txt").getBytes());
    }

    @Test
    public void getSmallObject() throws Exception {
        this.getObjectTest("Hello World!".getBytes());
    }

    @Test
    public void getLargeObject() throws Exception {
        this.getObjectTest(CommonUtils.randomAlphaNumString((int)262144).getBytes());
    }

    @Test
    public void getNonExistentObject() throws Exception {
        String objectKey = "bucket/non-existent-object";
        try {
            this.getObjectRestCall("bucket/non-existent-object");
        }
        catch (AssertionError e) {
            return;
        }
        Assert.fail((String)"get non-existent object should fail");
    }

    @Test
    public void getUnauthorizedObject() throws Exception {
        this.putBucket("bucket");
        this.createObject("bucket/object", "Hello World!".getBytes(), null, null);
        TestCaseOptions options = this.getDefaultOptionsWithAuth("unauthorized");
        HttpURLConnection connection = new TestCase(this.mHostname, this.mPort, this.mBaseUri, "bucket/object", NO_PARAMS, "GET", options).execute();
        Assert.assertEquals((long)403L, (long)connection.getResponseCode());
        S3Error response = (S3Error)new XmlMapper().readerFor(S3Error.class).readValue(connection.getErrorStream());
        Assert.assertEquals((Object)"AccessDenied", (Object)response.getCode());
    }

    @Test
    public void getObjectMetadata() throws Exception {
        String bucket = "bucket";
        this.createBucketRestCall("bucket");
        String objectKey = "bucket/object.txt";
        byte[] objectContent = CommonUtils.randomAlphaNumString((int)10).getBytes();
        this.createObjectRestCall("bucket/object.txt", NO_PARAMS, this.getDefaultOptionsWithAuth().setBody(objectContent).setContentType("application/octet-stream").setMD5(this.computeObjectChecksum(objectContent)));
        HttpURLConnection connection = this.getObjectMetadataRestCall("bucket/object.txt");
        URIStatus status = this.mFileSystem.getStatus(new AlluxioURI("/bucket/object.txt"));
        long lastModified = status.getLastModificationTimeMs() / 1000L * 1000L;
        Assert.assertEquals((long)lastModified, (long)connection.getLastModified());
        Assert.assertEquals((Object)String.valueOf(status.getLength()), (Object)connection.getHeaderField("Content-Length"));
    }

    @Test
    public void getNonExistentObjectMetadata() throws Exception {
        String objectKey = "bucket/non-existent-object";
        try {
            this.getObjectMetadataRestCall("bucket/non-existent-object");
        }
        catch (AssertionError e) {
            return;
        }
        Assert.fail((String)"get metadata of non-existent object should fail");
    }

    @Test
    public void deleteObject() throws Exception {
        String bucketName = "bucket-with-object-to-delete";
        this.createBucketRestCall("bucket-with-object-to-delete");
        String objectName = "file";
        AlluxioURI bucketUri = new AlluxioURI("/bucket-with-object-to-delete");
        AlluxioURI fileUri = new AlluxioURI(bucketUri.getPath() + "/" + "file");
        this.mFileSystemMaster.createFile(fileUri, CreateFileContext.defaults());
        Assert.assertFalse((boolean)this.mFileSystemMaster.listStatus(bucketUri, ListStatusContext.defaults()).isEmpty());
        this.deleteObjectRestCall("bucket-with-object-to-delete/file");
        Assert.assertTrue((boolean)this.mFileSystemMaster.listStatus(bucketUri, ListStatusContext.defaults()).isEmpty());
    }

    @Test
    public void deleteObjectAsAlluxioEmptyDir() throws Exception {
        String bucketName = "bucket-with-empty-dir-to-delete";
        this.createBucketRestCall("bucket-with-empty-dir-to-delete");
        String objectName = "empty-dir/";
        AlluxioURI bucketUri = new AlluxioURI("/bucket-with-empty-dir-to-delete");
        AlluxioURI dirUri = new AlluxioURI(bucketUri.getPath() + "/" + objectName);
        this.mFileSystemMaster.createDirectory(dirUri, CreateDirectoryContext.defaults());
        Assert.assertFalse((boolean)this.mFileSystemMaster.listStatus(bucketUri, ListStatusContext.defaults()).isEmpty());
        this.deleteObjectRestCall("bucket-with-empty-dir-to-delete/" + objectName);
        Assert.assertTrue((boolean)this.mFileSystemMaster.listStatus(bucketUri, ListStatusContext.defaults()).isEmpty());
    }

    @Test
    public void deleteObjectAsAlluxioNonEmptyDir() throws Exception {
        String bucketName = "bucket-with-non-empty-dir-to-delete";
        this.createBucketRestCall("bucket-with-non-empty-dir-to-delete");
        String objectName = "non-empty-dir/";
        AlluxioURI bucketUri = new AlluxioURI("/bucket-with-non-empty-dir-to-delete");
        AlluxioURI dirUri = new AlluxioURI(bucketUri.getPath() + "/" + objectName);
        this.mFileSystemMaster.createDirectory(dirUri, CreateDirectoryContext.defaults());
        this.mFileSystemMaster.createFile(new AlluxioURI(dirUri.getPath() + "/file"), CreateFileContext.defaults());
        Assert.assertFalse((boolean)this.mFileSystemMaster.listStatus(dirUri, ListStatusContext.defaults()).isEmpty());
        this.deleteObjectRestCall("bucket-with-non-empty-dir-to-delete/" + objectName);
    }

    @Test
    public void deleteNonExistingObject() throws Exception {
        String bucketName = "bucket-with-nothing";
        this.createBucketRestCall("bucket-with-nothing");
        String objectName = "non-existing-object";
        this.deleteObjectRestCall("bucket-with-nothing/" + objectName);
    }

    @Test
    public void initiateMultipartUpload() throws Exception {
        String user = "dummy";
        String bucketName = "bucket";
        this.createBucketRestCall("bucket", "dummy");
        String objectName = "object";
        String objectKey = "bucket/object";
        String result = this.initiateMultipartUploadRestCall(objectKey, "dummy");
        InitiateMultipartUploadResult multipartUploadResult = (InitiateMultipartUploadResult)XML_MAPPER.readValue(result, InitiateMultipartUploadResult.class);
        String uploadId = multipartUploadResult.getUploadId();
        InitiateMultipartUploadResult expected = new InitiateMultipartUploadResult("bucket", "object", uploadId);
        String expectedResult = XML_MAPPER.writeValueAsString((Object)expected);
        Assert.assertEquals((Object)expectedResult, (Object)result);
        URIStatus mpMetaFileStatus = this.mFileSystem.getStatus(new AlluxioURI(S3RestUtils.getMultipartMetaFilepathForUploadId((String)uploadId)));
        Assert.assertTrue((boolean)mpMetaFileStatus.isCompleted());
        AlluxioURI mpTempDirURI = new AlluxioURI(S3RestUtils.getMultipartTemporaryDirForObject((String)S3RestUtils.parsePath((String)"/bucket"), (String)"object", (String)uploadId));
        Assert.assertTrue((boolean)this.mFileSystem.exists(mpTempDirURI));
        URIStatus mpTempDirStatus = this.mFileSystem.getStatus(mpTempDirURI);
        Assert.assertTrue((boolean)mpTempDirStatus.getFileInfo().isFolder());
    }

    @Test
    public void uploadPart() throws Exception {
        String bucketName = "bucket";
        this.createBucketRestCall("bucket");
        String objectName = "object";
        String objectKey = "bucket/object";
        String result = this.initiateMultipartUploadRestCall(objectKey);
        InitiateMultipartUploadResult multipartUploadResult = (InitiateMultipartUploadResult)XML_MAPPER.readValue(result, InitiateMultipartUploadResult.class);
        String uploadId = multipartUploadResult.getUploadId();
        byte[] object = CommonUtils.randomAlphaNumString((int)16384).getBytes();
        this.putObjectTest("bucket", "object", object, uploadId, 1);
        this.putObjectTest("bucket", "object", object, uploadId, 1);
    }

    @Test
    public void uploadPartWithNonExistingUploadId() throws Exception {
        String bucketName = "bucket";
        this.createBucketRestCall("bucket");
        String objectName = "object";
        String objectKey = "bucket/object";
        String result = this.initiateMultipartUploadRestCall(objectKey);
        InitiateMultipartUploadResult multipartUploadResult = (InitiateMultipartUploadResult)XML_MAPPER.readValue(result, InitiateMultipartUploadResult.class);
        String uploadId = multipartUploadResult.getUploadId();
        byte[] object = CommonUtils.randomAlphaNumString((int)16384).getBytes();
        try {
            this.putObjectTest("bucket", "object", object, UUID.randomUUID().toString(), 1);
        }
        catch (AssertionError e) {
            return;
        }
        Assert.fail((String)"Upload part of an object with wrong upload ID should fail");
    }

    @Test
    public void uploadPartWithoutInitiation() throws Exception {
        String bucketName = "bucket";
        this.createBucketRestCall("bucket");
        try {
            String objectName = "object";
            byte[] object = CommonUtils.randomAlphaNumString((int)16384).getBytes();
            this.putObjectTest("bucket", "object", object, UUID.randomUUID().toString(), 1);
        }
        catch (AssertionError e) {
            return;
        }
        Assert.fail((String)"Upload part of an object without multipart upload initialization should fail");
    }

    @Test
    public void testUploadPartCopy() throws Exception {
        String bucketName = "bucket";
        this.createBucketRestCall("bucket");
        String objectName = "src-object";
        String srcObjectKey = "bucket/src-object";
        byte[] srcObjectContent = CommonUtils.randomAlphaNumString((int)16384).getBytes();
        this.putObjectTest("bucket", "src-object", srcObjectContent, null, null);
        String targetObjectName = "target-MP-object";
        String targetMPObjectKey = "bucket/" + targetObjectName;
        String result = this.initiateMultipartUploadRestCall(targetMPObjectKey);
        String uploadId = ((InitiateMultipartUploadResult)XML_MAPPER.readValue(result, InitiateMultipartUploadResult.class)).getUploadId();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uploadId", uploadId);
        params.put("partNumber", "1");
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, targetMPObjectKey, params, "PUT", this.getDefaultOptionsWithAuth().addHeader("x-amz-copy-source", srcObjectKey)).runAndGetResponse();
        ArrayList<CompleteMultipartUploadRequest.Part> partList = new ArrayList<CompleteMultipartUploadRequest.Part>();
        partList.add(new CompleteMultipartUploadRequest.Part("", 1));
        result = this.completeMultipartUploadRestCall(targetMPObjectKey, uploadId, new CompleteMultipartUploadRequest(partList));
        byte[] downloadTargetMpObj = new byte[16384];
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        try (FileInStream is = this.mFileSystem.openFile(new AlluxioURI("/" + targetMPObjectKey));){
            is.read(downloadTargetMpObj, 0, 16384);
            Assert.assertTrue((is.available() <= 0 ? 1 : 0) != 0);
        }
        Assert.assertArrayEquals((byte[])srcObjectContent, (byte[])downloadTargetMpObj);
    }

    @Test
    public void listParts() throws Exception {
        String bucket = "bucket";
        String bucketPath = "/bucket";
        this.createBucketRestCall("bucket");
        String object = "object";
        String objectKey = "bucket/object";
        String result = this.initiateMultipartUploadRestCall("bucket/object");
        InitiateMultipartUploadResult multipartUploadResult = (InitiateMultipartUploadResult)XML_MAPPER.readValue(result, InitiateMultipartUploadResult.class);
        String uploadId = multipartUploadResult.getUploadId();
        result = this.listPartsRestCall("bucket/object", uploadId);
        ListPartsResult listPartsResult = (ListPartsResult)XML_MAPPER.readValue(result, ListPartsResult.class);
        Assert.assertEquals((Object)"/bucket", (Object)listPartsResult.getBucket());
        Assert.assertEquals((Object)"object", (Object)listPartsResult.getKey());
        Assert.assertEquals((Object)uploadId, (Object)listPartsResult.getUploadId());
        Assert.assertEquals((long)0L, (long)listPartsResult.getParts().size());
        String object1 = CommonUtils.randomAlphaNumString((int)16384);
        String object2 = CommonUtils.randomAlphaNumString((int)16384);
        this.createObject("bucket/object", object1.getBytes(), uploadId, 1);
        this.createObject("bucket/object", object2.getBytes(), uploadId, 2);
        result = this.listPartsRestCall("bucket/object", uploadId);
        listPartsResult = (ListPartsResult)XML_MAPPER.readValue(result, ListPartsResult.class);
        Assert.assertEquals((Object)"/bucket", (Object)listPartsResult.getBucket());
        Assert.assertEquals((Object)"object", (Object)listPartsResult.getKey());
        Assert.assertEquals((Object)uploadId, (Object)listPartsResult.getUploadId());
        String tmpDir = S3RestUtils.getMultipartTemporaryDirForObject((String)"/bucket", (String)"object", (String)uploadId);
        List parts = listPartsResult.getParts();
        Assert.assertEquals((long)2L, (long)parts.size());
        for (int partNumber = 1; partNumber <= parts.size(); ++partNumber) {
            ListPartsResult.Part part = (ListPartsResult.Part)parts.get(partNumber - 1);
            Assert.assertEquals((long)partNumber, (long)part.getPartNumber());
            URIStatus status = this.mFileSystem.getStatus(new AlluxioURI(tmpDir + "/" + partNumber));
            Assert.assertEquals((Object)S3RestUtils.toS3Date((long)status.getLastModificationTimeMs()), (Object)part.getLastModified());
            Assert.assertEquals((long)status.getLength(), (long)part.getSize());
        }
        HttpURLConnection connection = new TestCase(this.mHostname, this.mPort, this.mBaseUri, "bucket/object", (Map<String, String>)ImmutableMap.of((Object)"uploadId", (Object)uploadId), "GET", this.getDefaultOptionsWithAuth("dummy")).execute();
        Assert.assertEquals((long)403L, (long)connection.getResponseCode());
        S3Error response = (S3Error)new XmlMapper().readerFor(S3Error.class).readValue(connection.getErrorStream());
        Assert.assertEquals((Object)"AccessDenied", (Object)response.getCode());
    }

    @Test
    public void abortMultipartUpload() throws Exception {
        String bucketName = "bucket";
        this.createBucketRestCall("bucket");
        String objectName = "object";
        String objectKey = "bucket/object";
        String result = this.initiateMultipartUploadRestCall(objectKey);
        InitiateMultipartUploadResult multipartUploadResult = (InitiateMultipartUploadResult)XML_MAPPER.readValue(result, InitiateMultipartUploadResult.class);
        String uploadId = multipartUploadResult.getUploadId();
        AlluxioURI tmpDir = new AlluxioURI(S3RestUtils.getMultipartTemporaryDirForObject((String)"/bucket", (String)"object", (String)uploadId));
        Assert.assertTrue((boolean)this.mFileSystem.exists(tmpDir));
        Assert.assertTrue((boolean)this.mFileSystem.getStatus(tmpDir).isFolder());
        HttpURLConnection connection = this.abortMultipartUploadRestCall(objectKey, uploadId);
        Assert.assertEquals((long)Response.Status.NO_CONTENT.getStatusCode(), (long)connection.getResponseCode());
        Assert.assertFalse((boolean)this.mFileSystem.exists(tmpDir));
    }

    @Test
    public void abortMultipartUploadWithNonExistingUploadId() throws Exception {
        String bucketName = "bucket";
        this.createBucketRestCall("bucket");
        String objectName = "object";
        String objectKey = "bucket/object";
        String result = this.initiateMultipartUploadRestCall(objectKey);
        InitiateMultipartUploadResult multipartUploadResult = (InitiateMultipartUploadResult)XML_MAPPER.readValue(result, InitiateMultipartUploadResult.class);
        String uploadId = multipartUploadResult.getUploadId();
        AlluxioURI tmpDir = new AlluxioURI(S3RestUtils.getMultipartTemporaryDirForObject((String)"/bucket", (String)"object", (String)uploadId));
        Assert.assertTrue((boolean)this.mFileSystem.exists(tmpDir));
        Assert.assertTrue((boolean)this.mFileSystem.getStatus(tmpDir).isFolder());
        try {
            this.abortMultipartUploadRestCall(objectKey, uploadId + 1);
        }
        catch (AssertionError e) {
            Assert.assertTrue((boolean)this.mFileSystem.exists(tmpDir));
            return;
        }
        Assert.fail((String)"Abort multipart upload with non-existing upload ID should fail");
    }

    @Test
    public void completeMultipartUploadTest() throws Exception {
        int numOfTestIter = 3;
        int maxParts = 50;
        int minParts = 15;
        Random random = new Random();
        for (int i = 0; i < numOfTestIter; ++i) {
            this.completeMultipartUpload(random.nextInt(maxParts - minParts) + minParts);
        }
    }

    public void completeMultipartUpload(int partsNum) throws Exception {
        String bucketName = "bucket";
        this.createBucketRestCall("bucket");
        String objectName = "object";
        String objectKey = "bucket/object";
        String result = this.initiateMultipartUploadRestCall(objectKey);
        InitiateMultipartUploadResult multipartUploadResult = (InitiateMultipartUploadResult)XML_MAPPER.readValue(result, InitiateMultipartUploadResult.class);
        String uploadId = multipartUploadResult.getUploadId();
        CharSequence[] objects = new String[partsNum];
        ArrayList<Integer> parts = new ArrayList<Integer>();
        for (int i = 0; i < partsNum; ++i) {
            parts.add(i + 1);
        }
        Collections.shuffle(parts);
        Iterator i = parts.iterator();
        while (i.hasNext()) {
            int partNum = (Integer)i.next();
            int idx = partNum - 1;
            objects[idx] = CommonUtils.randomAlphaNumString((int)16384);
            this.createObject(objectKey, objects[idx].getBytes(), uploadId, partNum);
        }
        AlluxioURI tmpDir = new AlluxioURI(S3RestUtils.getMultipartTemporaryDirForObject((String)"/bucket", (String)"object", (String)uploadId));
        Assert.assertEquals((long)partsNum, (long)this.mFileSystem.listStatus(tmpDir).size());
        ArrayList<CompleteMultipartUploadRequest.Part> partList = new ArrayList<CompleteMultipartUploadRequest.Part>();
        for (int i2 = 1; i2 <= partsNum; ++i2) {
            partList.add(new CompleteMultipartUploadRequest.Part("", i2));
        }
        result = this.completeMultipartUploadRestCall(objectKey, uploadId, new CompleteMultipartUploadRequest(partList));
        String expectedCombinedObject = String.join((CharSequence)"", objects);
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        byte[] digest = md5.digest(expectedCombinedObject.getBytes());
        String etag = Hex.encodeHexString((byte[])digest);
        String objectPath = "/" + objectKey;
        CompleteMultipartUploadResult completeMultipartUploadResult = new CompleteMultipartUploadResult(objectPath, "bucket", "object", etag);
        Assert.assertEquals((Object)XML_MAPPER.writeValueAsString((Object)completeMultipartUploadResult), (Object)result.trim());
        Assert.assertEquals((Object)XML_MAPPER.readValue(result, CompleteMultipartUploadResult.class), (Object)completeMultipartUploadResult);
        Assert.assertFalse((boolean)this.mFileSystem.exists(tmpDir));
        try (FileInStream is = this.mFileSystem.openFile(new AlluxioURI(objectPath));){
            String combinedObject = IOUtils.toString((InputStream)is);
            Assert.assertEquals((Object)expectedCombinedObject, (Object)combinedObject);
        }
    }

    @Test
    public void duplicateMultipartUpload() throws Exception {
        String bucketName = "bucket";
        this.createBucketRestCall("bucket");
        String objectName = "object";
        String objectKey = "bucket/object";
        String result1 = this.initiateMultipartUploadRestCall(objectKey);
        InitiateMultipartUploadResult multipartUploadResult1 = (InitiateMultipartUploadResult)XML_MAPPER.readValue(result1, InitiateMultipartUploadResult.class);
        String uploadId1 = multipartUploadResult1.getUploadId();
        String result2 = this.initiateMultipartUploadRestCall(objectKey);
        InitiateMultipartUploadResult multipartUploadResult2 = (InitiateMultipartUploadResult)XML_MAPPER.readValue(result2, InitiateMultipartUploadResult.class);
        String uploadId2 = multipartUploadResult2.getUploadId();
        String object1 = CommonUtils.randomAlphaNumString((int)16384);
        String object2 = CommonUtils.randomAlphaNumString((int)16384);
        this.createObject(objectKey, object1.getBytes(), uploadId1, 1);
        this.createObject(objectKey, object2.getBytes(), uploadId1, 2);
        String object3 = CommonUtils.randomAlphaNumString((int)16384);
        this.createObject(objectKey, object3.getBytes(), uploadId2, 1);
        AlluxioURI tmpDir1 = new AlluxioURI(S3RestUtils.getMultipartTemporaryDirForObject((String)"/bucket", (String)"object", (String)uploadId1));
        Assert.assertEquals((long)2L, (long)this.mFileSystem.listStatus(tmpDir1).size());
        AlluxioURI tmpDir2 = new AlluxioURI(S3RestUtils.getMultipartTemporaryDirForObject((String)"/bucket", (String)"object", (String)uploadId2));
        Assert.assertEquals((long)1L, (long)this.mFileSystem.listStatus(tmpDir2).size());
        ArrayList<CompleteMultipartUploadRequest.Part> partList1 = new ArrayList<CompleteMultipartUploadRequest.Part>();
        partList1.add(new CompleteMultipartUploadRequest.Part("", 1));
        partList1.add(new CompleteMultipartUploadRequest.Part("", 2));
        result1 = this.completeMultipartUploadRestCall(objectKey, uploadId1, new CompleteMultipartUploadRequest(partList1));
        String result1Retry = this.completeMultipartUploadRestCall(objectKey, uploadId1, new CompleteMultipartUploadRequest(partList1));
        String expectedCombinedObject = object1 + object2;
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        byte[] digest = md5.digest(expectedCombinedObject.getBytes());
        String etag = Hex.encodeHexString((byte[])digest);
        String objectPath = "/" + objectKey;
        CompleteMultipartUploadResult completeMultipartUploadResult1 = new CompleteMultipartUploadResult(objectPath, "bucket", "object", etag);
        Assert.assertEquals((Object)XML_MAPPER.writeValueAsString((Object)completeMultipartUploadResult1), (Object)result1.trim());
        Assert.assertEquals((Object)XML_MAPPER.readValue(result1, CompleteMultipartUploadResult.class), (Object)completeMultipartUploadResult1);
        Assert.assertEquals((Object)result1, (Object)result1Retry);
        Assert.assertFalse((boolean)this.mFileSystem.exists(tmpDir1));
        Assert.assertTrue((boolean)this.mFileSystem.exists(tmpDir2));
        try (FileInStream is = this.mFileSystem.openFile(new AlluxioURI(objectPath));){
            String combinedObject = IOUtils.toString((InputStream)is);
            Assert.assertEquals((Object)expectedCombinedObject, (Object)combinedObject);
        }
        ArrayList<CompleteMultipartUploadRequest.Part> partList2 = new ArrayList<CompleteMultipartUploadRequest.Part>();
        partList2.add(new CompleteMultipartUploadRequest.Part("", 1));
        result2 = this.completeMultipartUploadRestCall(objectKey, uploadId2, new CompleteMultipartUploadRequest(partList2));
        String result2Retry = this.completeMultipartUploadRestCall(objectKey, uploadId2, new CompleteMultipartUploadRequest(partList2));
        Assert.assertEquals((Object)result2, (Object)result2Retry);
        digest = md5.digest(object3.getBytes());
        etag = Hex.encodeHexString((byte[])digest);
        CompleteMultipartUploadResult completeMultipartUploadResult2 = new CompleteMultipartUploadResult(objectPath, "bucket", "object", etag);
        Assert.assertEquals((Object)XML_MAPPER.writeValueAsString((Object)completeMultipartUploadResult2), (Object)result2.trim());
        Assert.assertEquals((Object)XML_MAPPER.readValue(result2, CompleteMultipartUploadResult.class), (Object)completeMultipartUploadResult2);
        Assert.assertFalse((boolean)this.mFileSystem.exists(tmpDir2));
        try (FileInStream is = this.mFileSystem.openFile(new AlluxioURI(objectPath));){
            String newObject = IOUtils.toString((InputStream)is);
            Assert.assertEquals((Object)object3, (Object)newObject);
        }
        HttpURLConnection connection = this.completeMultipartUploadRestCallWithResponse(objectKey, uploadId1, new CompleteMultipartUploadRequest(partList1));
        Assert.assertEquals((long)404L, (long)connection.getResponseCode());
        S3Error response = (S3Error)new XmlMapper().readerFor(S3Error.class).readValue(connection.getErrorStream());
        Assert.assertEquals((Object)"NoSuchUpload", (Object)response.getCode());
    }

    @Test
    public void completeMultipartUploadWithInvalidArgument() throws Exception {
        String bucketName = "bucket";
        this.createBucketRestCall("bucket");
        String objectName = "object";
        String objectKey = "bucket/object";
        String result = this.initiateMultipartUploadRestCall(objectKey);
        InitiateMultipartUploadResult multipartUploadResult = (InitiateMultipartUploadResult)XML_MAPPER.readValue(result, InitiateMultipartUploadResult.class);
        String uploadId = multipartUploadResult.getUploadId();
        TestCase testCase = this.getCompleteMultipartUploadReadCallTestCase(objectKey, uploadId, null);
        HttpURLConnection connection = testCase.execute();
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)connection.getResponseCode());
    }

    @Test
    @Ignore
    public void completeMultipartUploadSpecifyParts() throws Exception {
        ArrayList<CompleteMultipartUploadRequest.Part> partList2;
        String bucketName = "bucket";
        this.createBucketRestCall("bucket");
        String objectName = "object";
        String objectKey = "bucket/object";
        String result = this.initiateMultipartUploadRestCall(objectKey);
        InitiateMultipartUploadResult multipartUploadResult = (InitiateMultipartUploadResult)XML_MAPPER.readValue(result, InitiateMultipartUploadResult.class);
        String uploadId = multipartUploadResult.getUploadId();
        String object1 = CommonUtils.randomAlphaNumString((int)16384);
        String object2 = CommonUtils.randomAlphaNumString((int)262144);
        String object3 = CommonUtils.randomAlphaNumString((int)16384);
        this.createObject(objectKey, object1.getBytes(), uploadId, 1);
        this.createObject(objectKey, object2.getBytes(), uploadId, 2);
        this.createObject(objectKey, object3.getBytes(), uploadId, 3);
        try {
            partList2 = new ArrayList<CompleteMultipartUploadRequest.Part>();
            partList2.add(new CompleteMultipartUploadRequest.Part("", 1));
            partList2.add(new CompleteMultipartUploadRequest.Part("", 2));
            partList2.add(new CompleteMultipartUploadRequest.Part("", 3));
            partList2.add(new CompleteMultipartUploadRequest.Part("", 4));
            this.completeMultipartUploadRestCall(objectKey, uploadId, new CompleteMultipartUploadRequest(partList2, true));
        }
        catch (AssertionError partList2) {
            // empty catch block
        }
        try {
            partList2 = new ArrayList();
            partList2.add(new CompleteMultipartUploadRequest.Part("", 2));
            partList2.add(new CompleteMultipartUploadRequest.Part("", 1));
            partList2.add(new CompleteMultipartUploadRequest.Part("", 3));
            this.completeMultipartUploadRestCall(objectKey, uploadId, new CompleteMultipartUploadRequest(partList2, true));
        }
        catch (AssertionError partList3) {
            // empty catch block
        }
        try {
            partList2 = new ArrayList();
            partList2.add(new CompleteMultipartUploadRequest.Part("", 1));
            partList2.add(new CompleteMultipartUploadRequest.Part("", 2));
            partList2.add(new CompleteMultipartUploadRequest.Part("", 3));
            this.completeMultipartUploadRestCall(objectKey, uploadId, new CompleteMultipartUploadRequest(partList2, true));
        }
        catch (AssertionError partList4) {
            // empty catch block
        }
        partList2 = new ArrayList();
        partList2.add(new CompleteMultipartUploadRequest.Part("", 2));
        partList2.add(new CompleteMultipartUploadRequest.Part("", 3));
        this.completeMultipartUploadRestCall(objectKey, uploadId, new CompleteMultipartUploadRequest(partList2, true));
    }

    @Test
    public void listMultipartUploads() throws Exception {
        String bucketName = "bucket";
        this.createBucketRestCall("bucket");
        String objectName = "object";
        String objectKey = "bucket/object";
        String result1 = this.initiateMultipartUploadRestCall(objectKey);
        InitiateMultipartUploadResult multipartUploadResult1 = (InitiateMultipartUploadResult)XML_MAPPER.readValue(result1, InitiateMultipartUploadResult.class);
        String uploadId1 = multipartUploadResult1.getUploadId();
        String result2 = this.initiateMultipartUploadRestCall(objectKey);
        InitiateMultipartUploadResult multipartUploadResult2 = (InitiateMultipartUploadResult)XML_MAPPER.readValue(result2, InitiateMultipartUploadResult.class);
        String uploadId2 = multipartUploadResult2.getUploadId();
        String otherBucketName = "other_bucket";
        this.createBucketRestCall("other_bucket");
        String otherObjectKey = "other_bucket/object";
        String otherResult = this.initiateMultipartUploadRestCall(otherObjectKey);
        InitiateMultipartUploadResult otherMultipartUploadResult = (InitiateMultipartUploadResult)XML_MAPPER.readValue(otherResult, InitiateMultipartUploadResult.class);
        String otherUploadId = otherMultipartUploadResult.getUploadId();
        String result = this.listMultipartUploadsRestCall("bucket");
        ListMultipartUploadsResult listUploadsResult = (ListMultipartUploadsResult)XML_MAPPER.readValue(result, ListMultipartUploadsResult.class);
        HashMap<String, String> uploads = new HashMap<String, String>();
        for (ListMultipartUploadsResult.Upload upload : listUploadsResult.getUploads()) {
            uploads.put(upload.getUploadId(), upload.getKey());
        }
        Assert.assertEquals((long)2L, (long)uploads.size());
        Assert.assertEquals((Object)"object", uploads.get(uploadId1));
        Assert.assertEquals((Object)"object", uploads.get(uploadId2));
        result = this.listMultipartUploadsRestCall("other_bucket");
        listUploadsResult = (ListMultipartUploadsResult)XML_MAPPER.readValue(result, ListMultipartUploadsResult.class);
        uploads.clear();
        for (ListMultipartUploadsResult.Upload upload : listUploadsResult.getUploads()) {
            uploads.put(upload.getUploadId(), upload.getKey());
        }
        Assert.assertEquals((long)1L, (long)uploads.size());
        Assert.assertEquals((Object)"object", uploads.get(otherUploadId));
        result = this.listMultipartUploadsRestCall("bucket", "dummy");
        listUploadsResult = (ListMultipartUploadsResult)XML_MAPPER.readValue(result, ListMultipartUploadsResult.class);
        Assert.assertNull((Object)listUploadsResult.getUploads());
        result = this.listMultipartUploadsRestCall("other_bucket", "dummy");
        listUploadsResult = (ListMultipartUploadsResult)XML_MAPPER.readValue(result, ListMultipartUploadsResult.class);
        Assert.assertNull((Object)listUploadsResult.getUploads());
        this.abortMultipartUploadRestCall(objectKey, uploadId1);
        result = this.listMultipartUploadsRestCall("bucket");
        listUploadsResult = (ListMultipartUploadsResult)XML_MAPPER.readValue(result, ListMultipartUploadsResult.class);
        uploads.clear();
        for (ListMultipartUploadsResult.Upload upload : listUploadsResult.getUploads()) {
            uploads.put(upload.getUploadId(), upload.getKey());
        }
        Assert.assertEquals((long)1L, (long)uploads.size());
        Assert.assertFalse((boolean)uploads.containsKey(uploadId1));
        Assert.assertEquals((Object)"object", uploads.get(uploadId2));
        String object = CommonUtils.randomAlphaNumString((int)16384);
        this.createObject(objectKey, object.getBytes(), uploadId2, 1);
        ArrayList<CompleteMultipartUploadRequest.Part> partList = new ArrayList<CompleteMultipartUploadRequest.Part>();
        partList.add(new CompleteMultipartUploadRequest.Part("", 1));
        this.completeMultipartUploadRestCall(objectKey, uploadId2, new CompleteMultipartUploadRequest(partList));
        result = this.listMultipartUploadsRestCall("bucket");
        listUploadsResult = (ListMultipartUploadsResult)XML_MAPPER.readValue(result, ListMultipartUploadsResult.class);
        Assert.assertNull((Object)listUploadsResult.getUploads());
    }

    @Test
    public void testObjectContentType() throws Exception {
        String bucketName = "bucket";
        this.createBucketRestCall("bucket");
        String objectName = "object";
        String objectKey = "bucket/object";
        String objectData = CommonUtils.randomAlphaNumString((int)16384);
        this.createObjectRestCall(objectKey, NO_PARAMS, this.getDefaultOptionsWithAuth().setBody(objectData).setContentType("text/plain").setMD5(this.computeObjectChecksum(objectData.getBytes())));
        HttpURLConnection connection = this.getObjectMetadataRestCall(objectKey);
        Assert.assertEquals((Object)"text/plain", (Object)connection.getHeaderField("Content-Type"));
    }

    @Test
    public void testBucketTagging() throws Exception {
        String bucketName = "bucket";
        this.createBucketRestCall("bucket");
        this.testTagging("bucket", (ImmutableMap<String, String>)ImmutableMap.of());
    }

    @Test
    public void testObjectTagsHeader() throws Exception {
        String bucketName = "bucket";
        this.createBucketRestCall("bucket");
        String objectName = "object";
        String objectKey = "bucket/object";
        String objectData = CommonUtils.randomAlphaNumString((int)16384);
        this.createObjectRestCall(objectKey, NO_PARAMS, this.getDefaultOptionsWithAuth().setBody(objectData.getBytes()).setContentType("application/octet-stream").setMD5(this.computeObjectChecksum(objectData.getBytes())).addHeader("x-amz-tagging", "foo=bar&baz"));
        this.testTagging(objectKey, (ImmutableMap<String, String>)ImmutableMap.of((Object)"foo", (Object)"bar", (Object)"baz", (Object)""));
    }

    @Test
    @Ignore
    public void testTaggingNoLimit() throws Exception {
        String bucketName = "bucket";
        this.createBucketRestCall("bucket");
        String objectName = "object";
        String objectKey = "bucket/object";
        String objectData = CommonUtils.randomAlphaNumString((int)16384);
        String longTagKey = Strings.repeat((String)"a", (int)129);
        String longTagValue = Strings.repeat((String)"b", (int)257);
        this.createObjectRestCall(objectKey, NO_PARAMS, this.getDefaultOptionsWithAuth().setBody(objectData.getBytes()).setContentType("application/octet-stream").setMD5(this.computeObjectChecksum(objectData.getBytes())).addHeader("x-amz-tagging", String.format("tag1&tag2&tag3&tag4&tag5&tag6&tag7&tag8&tag9&tag10&%s=%s", longTagKey, longTagValue)));
        HashMap<String, String> tagMap = new HashMap<String, String>();
        tagMap.put("tag1", "");
        tagMap.put("tag2", "");
        tagMap.put("tag3", "");
        tagMap.put("tag4", "");
        tagMap.put("tag5", "");
        tagMap.put("tag6", "");
        tagMap.put("tag7", "");
        tagMap.put("tag8", "");
        tagMap.put("tag9", "");
        tagMap.put("tag10", "");
        tagMap.put(longTagKey, longTagValue);
        this.testTagging(objectKey, (ImmutableMap<String, String>)ImmutableMap.copyOf(tagMap));
    }

    @Test
    public void testCopyObject() throws Exception {
        String bucketName = "bucket";
        String objectKey = "object";
        String targetObject = "/nonExistDir/copyTarget";
        String object = CommonUtils.randomAlphaNumString((int)16384);
        String fullObjectKey = "bucket/object";
        String copiedObjectKey = "bucket/nonExistDir/copyTarget";
        AlluxioURI copiedObjectURI = new AlluxioURI("/" + copiedObjectKey);
        this.createBucketRestCall("bucket");
        this.createObject("bucket/object", object.getBytes(), null, null);
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, copiedObjectKey, NO_PARAMS, "PUT", this.getDefaultOptionsWithAuth().addHeader("x-amz-metadata-directive", S3Constants.Directive.REPLACE.name()).addHeader("x-amz-copy-source", "bucket/object")).runAndGetResponse();
        List fileInfos = this.mFileSystemMaster.listStatus(copiedObjectURI, ListStatusContext.defaults());
        Assert.assertEquals((long)1L, (long)fileInfos.size());
        Assert.assertEquals((Object)copiedObjectURI.getPath(), (Object)((FileInfo)fileInfos.get(0)).getPath());
        FileInStream is = this.mFileSystem.openFile(copiedObjectURI);
        byte[] writtenObjectContent = IOUtils.toString((InputStream)is).getBytes();
        is.close();
        Assert.assertArrayEquals((byte[])object.getBytes(), (byte[])writtenObjectContent);
        Assert.assertNotNull((Object)((FileInfo)fileInfos.get(0)).getXAttr());
        Assert.assertEquals((Object)Hex.encodeHexString((byte[])MessageDigest.getInstance("MD5").digest(writtenObjectContent)), (Object)new String((byte[])((FileInfo)fileInfos.get(0)).getXAttr().get("s3_etag"), S3Constants.XATTR_STR_CHARSET));
    }

    @Test
    public void testCopyObjectMetadata() throws Exception {
        String bucketName = "bucket";
        this.createBucketRestCall("bucket");
        String objectName = "object";
        String objectKey = "bucket/object";
        String objectData = "text data";
        this.createObjectRestCall(objectKey, NO_PARAMS, this.getDefaultOptionsWithAuth().setBody(objectData).setContentType("text/plain").setMD5(this.computeObjectChecksum(objectData.getBytes())).addHeader("x-amz-tagging", "foo=bar&baz"));
        TaggingData newTags = this.getTagsRestCall(objectKey);
        Assert.assertEquals((Object)ImmutableMap.of((Object)"foo", (Object)"bar", (Object)"baz", (Object)""), (Object)newTags.getTagMap());
        String copiedObjectKey = String.format("%s%s%s", "bucket", "/", "copyMeta_copyTags_object");
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, copiedObjectKey, NO_PARAMS, "PUT", this.getDefaultOptionsWithAuth().addHeader("x-amz-copy-source", objectKey)).runAndGetResponse();
        newTags = this.getTagsRestCall(copiedObjectKey);
        Assert.assertEquals((Object)ImmutableMap.of((Object)"foo", (Object)"bar", (Object)"baz", (Object)""), (Object)newTags.getTagMap());
        HttpURLConnection connection = this.getObjectMetadataRestCall(copiedObjectKey);
        Assert.assertEquals((Object)"text/plain", (Object)connection.getContentType());
        Assert.assertEquals((Object)objectData, (Object)this.getObjectRestCall(copiedObjectKey));
        copiedObjectKey = String.format("%s%s%s", "bucket", "/", "replaceMeta_copyTags_object");
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, copiedObjectKey, NO_PARAMS, "PUT", this.getDefaultOptionsWithAuth().addHeader("x-amz-copy-source", objectKey).addHeader("x-amz-metadata-directive", S3Constants.Directive.REPLACE.name()).setContentType("application/octet-stream")).runAndGetResponse();
        newTags = this.getTagsRestCall(copiedObjectKey);
        Assert.assertEquals((Object)ImmutableMap.of((Object)"foo", (Object)"bar", (Object)"baz", (Object)""), (Object)newTags.getTagMap());
        connection = this.getObjectMetadataRestCall(copiedObjectKey);
        Assert.assertEquals((Object)"application/octet-stream", (Object)connection.getContentType());
        Assert.assertEquals((Object)objectData, (Object)this.getObjectRestCall(copiedObjectKey));
        copiedObjectKey = String.format("%s%s%s", "bucket", "/", "copyMeta_replaceTags_object");
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, copiedObjectKey, NO_PARAMS, "PUT", this.getDefaultOptionsWithAuth().addHeader("x-amz-copy-source", objectKey).addHeader("x-amz-tagging-directive", S3Constants.Directive.REPLACE.name()).addHeader("x-amz-tagging", "foo=new")).runAndGetResponse();
        newTags = this.getTagsRestCall(copiedObjectKey);
        Assert.assertEquals((Object)ImmutableMap.of((Object)"foo", (Object)"new"), (Object)newTags.getTagMap());
        connection = this.getObjectMetadataRestCall(copiedObjectKey);
        Assert.assertEquals((Object)"text/plain", (Object)connection.getContentType());
        Assert.assertEquals((Object)objectData, (Object)this.getObjectRestCall(copiedObjectKey));
        copiedObjectKey = String.format("%s%s%s", "bucket", "/", "replaceMeta_replaceTags_object");
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, copiedObjectKey, NO_PARAMS, "PUT", this.getDefaultOptionsWithAuth().addHeader("x-amz-copy-source", objectKey).addHeader("x-amz-metadata-directive", S3Constants.Directive.REPLACE.name()).setContentType("application/octet-stream").addHeader("x-amz-tagging-directive", S3Constants.Directive.REPLACE.name()).addHeader("x-amz-tagging", "foo=new")).runAndGetResponse();
        newTags = this.getTagsRestCall(copiedObjectKey);
        Assert.assertEquals((Object)ImmutableMap.of((Object)"foo", (Object)"new"), (Object)newTags.getTagMap());
        connection = this.getObjectMetadataRestCall(copiedObjectKey);
        Assert.assertEquals((Object)"application/octet-stream", (Object)connection.getContentType());
        Assert.assertEquals((Object)objectData, (Object)this.getObjectRestCall(copiedObjectKey));
    }

    @Test
    public void testObjectTagging() throws Exception {
        String bucketName = "bucket";
        this.createBucketRestCall("bucket");
        String objectName = "object";
        String objectKey = "bucket/object";
        String objectData = CommonUtils.randomAlphaNumString((int)16384);
        this.createObjectRestCall(objectKey, NO_PARAMS, this.getDefaultOptionsWithAuth().setBody(objectData.getBytes()).setContentType("application/octet-stream").setMD5(this.computeObjectChecksum(objectData.getBytes())));
        this.testTagging(objectKey, (ImmutableMap<String, String>)ImmutableMap.of());
    }

    @Test
    public void testFolderTagging() throws Exception {
        String bucketName = "bucket";
        this.createBucketRestCall("bucket");
        String folderName = "folder";
        String folderKey = "bucket/folder";
        String objectName = "object";
        String objectKey = folderKey + "/" + "object";
        String objectData = CommonUtils.randomAlphaNumString((int)16384);
        this.createObjectRestCall(objectKey, NO_PARAMS, this.getDefaultOptionsWithAuth().setBody(objectData.getBytes()).setContentType("application/octet-stream").setMD5(this.computeObjectChecksum(objectData.getBytes())).addHeader("x-amz-tagging", "foo=bar"));
        this.testTagging(folderKey, (ImmutableMap<String, String>)ImmutableMap.of());
    }

    private void testTagging(String resource, ImmutableMap<String, String> expectedTags) throws Exception {
        TaggingData tagData = this.getTagsRestCall(resource);
        if (expectedTags != null) {
            Assert.assertEquals(expectedTags, (Object)tagData.getTagMap());
        }
        ImmutableMap tagMap = ImmutableMap.of((Object)"foo", (Object)"bar", (Object)"fu", (Object)"bar", (Object)"baz", (Object)"");
        tagData.clear();
        tagData.addTags((Map)tagMap);
        this.putTagsRestCall(resource, tagData);
        TaggingData newTags = this.getTagsRestCall(resource);
        Assert.assertEquals((Object)tagMap, (Object)newTags.getTagMap());
        this.deleteTagsRestCall(resource);
        TaggingData deletedTags = this.getTagsRestCall(resource);
        Assert.assertEquals((long)0L, (long)deletedTags.getTagMap().size());
    }

    private void createBucketRestCall(String bucketUri) throws Exception {
        this.createBucketRestCall(bucketUri, "testuser");
    }

    private void createBucketRestCall(String bucketUri, String user) throws Exception {
        TestCaseOptions options = this.getDefaultOptionsWithAuth(user);
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, bucketUri, NO_PARAMS, "PUT", options).runAndCheckResult();
    }

    private HttpURLConnection deleteBucketRestCall(String bucketUri) throws Exception {
        return new TestCase(this.mHostname, this.mPort, this.mBaseUri, bucketUri, NO_PARAMS, "DELETE", this.getDefaultOptionsWithAuth()).executeAndAssertSuccess();
    }

    private HttpURLConnection headBucketRestCall(String bucketUri) throws Exception {
        return new TestCase(this.mHostname, this.mPort, this.mBaseUri, bucketUri, NO_PARAMS, "HEAD", this.getDefaultOptionsWithAuth()).execute();
    }

    private String computeObjectChecksum(byte[] objectContent) throws Exception {
        MessageDigest md5Hash = MessageDigest.getInstance("MD5");
        byte[] md5Digest = md5Hash.digest(objectContent);
        return BaseEncoding.base64().encode(md5Digest);
    }

    private void createObjectRestCall(String objectUri, @NotNull Map<String, String> params, @NotNull TestCaseOptions options) throws Exception {
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, objectUri, params, "PUT", options).runAndCheckResult();
    }

    private String initiateMultipartUploadRestCall(String objectUri) throws Exception {
        return this.initiateMultipartUploadRestCall(objectUri, "testuser");
    }

    private String initiateMultipartUploadRestCall(String objectUri, String user) throws Exception {
        TestCaseOptions options = this.getDefaultOptionsWithAuth(user);
        ImmutableMap params = ImmutableMap.of((Object)"uploads", (Object)"");
        return new TestCase(this.mHostname, this.mPort, this.mBaseUri, objectUri, (Map<String, String>)params, "POST", options).runAndGetResponse();
    }

    private TestCase getCompleteMultipartUploadReadCallTestCase(String objectUri, String uploadId, CompleteMultipartUploadRequest request) throws Exception {
        ImmutableMap params = ImmutableMap.of((Object)"uploadId", (Object)uploadId);
        return new TestCase(this.mHostname, this.mPort, this.mBaseUri, objectUri, (Map<String, String>)params, "POST", this.getDefaultOptionsWithAuth().setBody(request).setContentType("application/xml"));
    }

    private String completeMultipartUploadRestCall(String objectUri, String uploadId, CompleteMultipartUploadRequest request) throws Exception {
        TestCase testCase = this.getCompleteMultipartUploadReadCallTestCase(objectUri, uploadId, request);
        return testCase.runAndGetResponse();
    }

    private HttpURLConnection completeMultipartUploadRestCallWithResponse(String objectUri, String uploadId, CompleteMultipartUploadRequest request) throws Exception {
        TestCase testCase = this.getCompleteMultipartUploadReadCallTestCase(objectUri, uploadId, request);
        return testCase.execute();
    }

    private HttpURLConnection abortMultipartUploadRestCall(String objectUri, String uploadId) throws Exception {
        ImmutableMap params = ImmutableMap.of((Object)"uploadId", (Object)uploadId);
        return new TestCase(this.mHostname, this.mPort, this.mBaseUri, objectUri, (Map<String, String>)params, "DELETE", this.getDefaultOptionsWithAuth()).executeAndAssertSuccess();
    }

    private String listPartsRestCall(String objectUri, String uploadId) throws Exception {
        ImmutableMap params = ImmutableMap.of((Object)"uploadId", (Object)uploadId);
        return new TestCase(this.mHostname, this.mPort, this.mBaseUri, objectUri, (Map<String, String>)params, "GET", this.getDefaultOptionsWithAuth()).runAndGetResponse();
    }

    private String listMultipartUploadsRestCall(String bucketUri) throws Exception {
        return this.listMultipartUploadsRestCall(bucketUri, "testuser");
    }

    private String listMultipartUploadsRestCall(String bucketUri, String user) throws Exception {
        TestCaseOptions options = this.getDefaultOptionsWithAuth(user);
        return new TestCase(this.mHostname, this.mPort, this.mBaseUri, bucketUri, (Map<String, String>)ImmutableMap.of((Object)"uploads", (Object)""), "GET", options).runAndGetResponse();
    }

    private HttpURLConnection getObjectMetadataRestCall(String objectUri) throws Exception {
        return new TestCase(this.mHostname, this.mPort, this.mBaseUri, objectUri, NO_PARAMS, "HEAD", this.getDefaultOptionsWithAuth()).executeAndAssertSuccess();
    }

    private String getObjectRestCall(String objectUri) throws Exception {
        return new TestCase(this.mHostname, this.mPort, this.mBaseUri, objectUri, NO_PARAMS, "GET", this.getDefaultOptionsWithAuth()).runAndGetResponse();
    }

    private HttpURLConnection getObjectRestCallWithError(String objectUri) throws Exception {
        return new TestCase(this.mHostname, this.mPort, this.mBaseUri, objectUri, NO_PARAMS, "GET", this.getDefaultOptionsWithAuth()).execute();
    }

    private void deleteObjectRestCall(String objectUri) throws Exception {
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, objectUri, NO_PARAMS, "DELETE", this.getDefaultOptionsWithAuth()).runAndCheckResult();
    }

    private void deleteTagsRestCall(String uri) throws Exception {
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, uri, (Map<String, String>)ImmutableMap.of((Object)"tagging", (Object)""), "DELETE", this.getDefaultOptionsWithAuth()).runAndCheckResult();
    }

    private TaggingData getTagsRestCall(String uri) throws Exception {
        String res = new TestCase(this.mHostname, this.mPort, this.mBaseUri, uri, (Map<String, String>)ImmutableMap.of((Object)"tagging", (Object)""), "GET", this.getDefaultOptionsWithAuth().setContentType("application/xml")).runAndGetResponse();
        XmlMapper mapper = new XmlMapper();
        return (TaggingData)mapper.readValue(res, TaggingData.class);
    }

    private void putTagsRestCall(String uri, @NotNull TaggingData tags) throws Exception {
        new TestCase(this.mHostname, this.mPort, this.mBaseUri, uri, (Map<String, String>)ImmutableMap.of((Object)"tagging", (Object)""), "PUT", this.getDefaultOptionsWithAuth().setContentType("application/octet-stream").setCharset(S3Constants.TAGGING_CHARSET).setBody(TaggingData.serialize((TaggingData)tags).toByteArray())).runAndCheckResult();
    }

    @Test
    public void testMalformedAuthHeader() throws Exception {
        String bucket = "test-bucket";
        TestCaseOptions options = this.getDefaultOptionsWithAuth();
        options.setAuthorization("");
        HttpURLConnection connection = new TestCase(this.mHostname, this.mPort, this.mBaseUri, bucket, NO_PARAMS, "GET", options).execute();
        Assert.assertEquals((long)400L, (long)connection.getResponseCode());
        S3Error response = (S3Error)new XmlMapper().readerFor(S3Error.class).readValue(connection.getErrorStream());
        Assert.assertEquals((Object)"AuthorizationHeaderMalformed", (Object)response.getCode());
        options = this.getDefaultOptionsWithAuth();
        options.setAuthorization("AWS alluxio:3uRmVm7lWfvclsqfpPJN2Ftigi4=");
        connection = new TestCase(this.mHostname, this.mPort, this.mBaseUri, bucket, NO_PARAMS, "GET", options).execute();
        Assert.assertEquals((long)400L, (long)connection.getResponseCode());
        response = (S3Error)new XmlMapper().readerFor(S3Error.class).readValue(connection.getErrorStream());
        Assert.assertEquals((Object)"AuthorizationHeaderMalformed", (Object)response.getCode());
    }
}

