/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.rest;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import javax.validation.constraints.NotNull;

@NotThreadSafe
public final class TestCaseOptions {
    public static final String JSON_CONTENT_TYPE = "application/json";
    public static final String OCTET_STREAM_CONTENT_TYPE = "application/octet-stream";
    public static final String XML_CONTENT_TYPE = "application/xml";
    public static final String TEXT_PLAIN_CONTENT_TYPE = "text/plain";
    public static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String CONTENT_TYPE_HEADER = "Content-Type";
    public static final String CONTENT_MD5_HEADER = "Content-MD5";
    private String mAuthorization = null;
    private String mContentType = "application/octet-stream";
    private String mMD5 = null;
    private final Map<String, String> mHeaders;
    private Object mBody = null;
    private Charset mCharset = StandardCharsets.UTF_8;
    private boolean mPrettyPrint = false;

    public static TestCaseOptions defaults() {
        TestCaseOptions options = new TestCaseOptions();
        return options;
    }

    private TestCaseOptions() {
        this.mHeaders = new HashMap<String, String>();
    }

    public Object getBody() {
        return this.mBody;
    }

    public boolean isPrettyPrint() {
        return this.mPrettyPrint;
    }

    public String getContentType() {
        return this.mContentType;
    }

    public String getMD5() {
        return this.mMD5;
    }

    public String getAuthorization() {
        return this.mAuthorization;
    }

    public Charset getCharset() {
        return this.mCharset;
    }

    public Map<String, String> getHeaders() {
        return this.mHeaders;
    }

    public TestCaseOptions setBody(Object body) {
        this.mBody = body;
        return this;
    }

    public TestCaseOptions setPrettyPrint(boolean prettyPrint) {
        this.mPrettyPrint = prettyPrint;
        return this;
    }

    public TestCaseOptions setContentType(String contentType) {
        this.mContentType = contentType;
        this.mHeaders.put(CONTENT_TYPE_HEADER, contentType);
        return this;
    }

    public TestCaseOptions setMD5(String md5) {
        this.mMD5 = md5;
        this.mHeaders.put(CONTENT_MD5_HEADER, md5);
        return this;
    }

    public TestCaseOptions setAuthorization(String authorization) {
        this.mAuthorization = authorization;
        this.mHeaders.put(AUTHORIZATION_HEADER, authorization);
        return this;
    }

    public TestCaseOptions setCharset(@NotNull Charset charset) {
        this.mCharset = charset;
        return this;
    }

    public TestCaseOptions addHeaders(@NotNull Map<String, String> headers) {
        this.mHeaders.putAll(headers);
        return this;
    }

    public TestCaseOptions addHeader(String key, String value) {
        this.mHeaders.put(key, value);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TestCaseOptions)) {
            return false;
        }
        TestCaseOptions that = (TestCaseOptions)o;
        return Objects.equal((Object)this.mAuthorization, (Object)that.mAuthorization) && Objects.equal((Object)this.mBody, (Object)that.mBody) && Objects.equal((Object)this.mCharset, (Object)that.mCharset) && Objects.equal((Object)this.mContentType, (Object)that.mContentType) && Objects.equal(this.mHeaders, that.mHeaders) && Objects.equal((Object)this.mMD5, (Object)that.mMD5) && this.mPrettyPrint == that.mPrettyPrint;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mAuthorization, this.mBody, this.mCharset, this.mContentType, this.mHeaders, this.mMD5, this.mPrettyPrint});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("authorization", (Object)this.mAuthorization).add("body", this.mBody).add("charset", (Object)this.mCharset).add("content type", (Object)this.mContentType).add("headers", this.mHeaders).add("MD5", (Object)this.mMD5).add("pretty print", this.mPrettyPrint).toString();
    }
}

