/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.rest;

import alluxio.client.rest.TestCaseOptions;
import alluxio.test.util.CommonUtils;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestCaseOptionsTest {
    @Test
    public void defaults() {
        TestCaseOptions options = TestCaseOptions.defaults();
        Assert.assertNull((Object)options.getBody());
        Assert.assertEquals((Object)"application/octet-stream", (Object)options.getContentType());
        Assert.assertEquals((Object)StandardCharsets.UTF_8, (Object)options.getCharset());
        Assert.assertNull((Object)options.getMD5());
        Assert.assertFalse((boolean)options.isPrettyPrint());
    }

    @Test
    public void fields() {
        Random random = new Random();
        String body = "body";
        byte[] bytes = new byte[5];
        random.nextBytes(bytes);
        boolean prettyPrint = random.nextBoolean();
        TestCaseOptions options = TestCaseOptions.defaults();
        String md5 = RandomStringUtils.random((int)64);
        options.setBody(body);
        options.setCharset(StandardCharsets.US_ASCII);
        options.setPrettyPrint(prettyPrint);
        Assert.assertEquals((Object)body, (Object)options.getBody());
        Assert.assertEquals((Object)StandardCharsets.US_ASCII, (Object)options.getCharset());
        Assert.assertEquals((Object)prettyPrint, (Object)options.isPrettyPrint());
        options.setAuthorization("auth");
        options.setContentType("text/plain");
        options.setMD5(md5);
        Assert.assertEquals((Object)"auth", (Object)options.getAuthorization());
        Assert.assertEquals((Object)"auth", (Object)options.getHeaders().get("Authorization"));
        Assert.assertEquals((Object)"text/plain", (Object)options.getContentType());
        Assert.assertEquals((Object)"text/plain", (Object)options.getHeaders().get("Content-Type"));
        Assert.assertEquals((Object)md5, (Object)options.getMD5());
        Assert.assertEquals((Object)md5, (Object)options.getHeaders().get("Content-MD5"));
    }

    @Test
    public void equals() throws Exception {
        CommonUtils.testEquals(TestCaseOptions.class, (String[])new String[]{"mCharset"});
        Assert.assertEquals((Object)TestCaseOptions.defaults().setCharset(StandardCharsets.US_ASCII), (Object)TestCaseOptions.defaults().setCharset(StandardCharsets.US_ASCII));
        Assert.assertNotEquals((Object)TestCaseOptions.defaults().setCharset(StandardCharsets.US_ASCII), (Object)TestCaseOptions.defaults().setCharset(StandardCharsets.UTF_8));
    }
}

