/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job;

import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.job.util.JobTestUtils;
import alluxio.job.wire.JobInfo;
import alluxio.job.wire.Status;
import alluxio.master.LocalAlluxioJobCluster;
import alluxio.master.job.JobMaster;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import java.util.concurrent.TimeoutException;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;

public abstract class JobIntegrationTest
extends BaseIntegrationTest {
    protected static final int BUFFER_BYTES = 100;
    protected static final long WORKER_CAPACITY_BYTES = 0x40000000L;
    protected static final int BLOCK_SIZE_BYTES = 128;
    protected JobMaster mJobMaster;
    protected FileSystem mFileSystem = null;
    protected FileSystemContext mFsContext;
    protected LocalAlluxioJobCluster mLocalAlluxioJobCluster;
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = this.buildLocalAlluxioCluster();

    private LocalAlluxioClusterResource buildLocalAlluxioCluster() {
        LocalAlluxioClusterResource.Builder resource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.JOB_MASTER_WORKER_HEARTBEAT_INTERVAL, 20).setProperty(PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT, 128).setProperty(PropertyKey.USER_FILE_BUFFER_BYTES, String.valueOf(100)).setProperty(PropertyKey.USER_STREAMING_READER_CHUNK_SIZE_BYTES, "64KB").setProperty(PropertyKey.WORKER_RAMDISK_SIZE, 0x40000000L);
        return resource.build();
    }

    @Before
    public void before() throws Exception {
        this.mLocalAlluxioJobCluster = new LocalAlluxioJobCluster();
        this.mLocalAlluxioJobCluster.start();
        this.mJobMaster = this.mLocalAlluxioJobCluster.getMaster().getJobMaster();
        this.mFsContext = FileSystemContext.create((AlluxioConfiguration)Configuration.global());
        this.mFileSystem = this.mLocalAlluxioClusterResource.get().getClient();
    }

    @After
    public void after() throws Exception {
        this.mFsContext.close();
        this.mLocalAlluxioJobCluster.stop();
    }

    protected JobInfo waitForJobToFinish(long jobId) throws InterruptedException, TimeoutException {
        return JobTestUtils.waitForJobStatus(this.mJobMaster, jobId, Status.COMPLETED);
    }

    protected JobInfo waitForJobFailure(long jobId) throws InterruptedException, TimeoutException {
        return JobTestUtils.waitForJobStatus(this.mJobMaster, jobId, Status.FAILED);
    }

    protected JobInfo waitForJobCancelled(long jobId) throws InterruptedException, TimeoutException {
        return JobTestUtils.waitForJobStatus(this.mJobMaster, jobId, Status.CANCELED);
    }

    protected JobInfo waitForJobRunning(long jobId) throws InterruptedException, TimeoutException {
        return JobTestUtils.waitForJobStatus(this.mJobMaster, jobId, Status.RUNNING);
    }
}

