/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.master;

import alluxio.ConfigurationRule;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.heartbeat.HeartbeatScheduler;
import alluxio.heartbeat.ManuallyScheduleHeartbeat;
import alluxio.master.LocalAlluxioJobCluster;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.util.CommonUtils;
import alluxio.util.WaitForOptions;
import alluxio.worker.JobWorkerIdRegistry;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class LostWorkerIntegrationTest
extends BaseIntegrationTest {
    private static final int WORKER_HEARTBEAT_TIMEOUT_MS = 10;
    @Rule
    public ManuallyScheduleHeartbeat mSchedule = new ManuallyScheduleHeartbeat(new String[]{"Job Master Lost Worker Detection", "Job Worker Command Handling"});
    @Rule
    public ConfigurationRule mConfigurationRule = new ConfigurationRule((Map)ImmutableMap.of((Object)PropertyKey.JOB_MASTER_WORKER_TIMEOUT, (Object)10), Configuration.modifiableGlobal());
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().build();
    private LocalAlluxioJobCluster mLocalAlluxioJobCluster;

    @Before
    public void before() throws Exception {
        this.mLocalAlluxioJobCluster = new LocalAlluxioJobCluster();
        this.mLocalAlluxioJobCluster.start();
    }

    @Test
    public void lostWorkerReregisters() throws Exception {
        Long initialId = JobWorkerIdRegistry.getWorkerId();
        CommonUtils.sleepMs((long)11L);
        HeartbeatScheduler.execute((String)"Job Master Lost Worker Detection");
        Assert.assertTrue((boolean)this.mLocalAlluxioJobCluster.getMaster().getJobMaster().getWorkerInfoList().isEmpty());
        HeartbeatScheduler.execute((String)"Job Worker Command Handling");
        CommonUtils.waitFor((String)"worker to reregister", () -> !this.mLocalAlluxioJobCluster.getMaster().getJobMaster().getWorkerInfoList().isEmpty() && JobWorkerIdRegistry.getWorkerId().longValue() != initialId.longValue(), (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(10000L));
    }
}

