/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.master.PortRegistry;
import java.io.File;
import java.util.HashSet;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public final class PortRegistryTest {
    private PortRegistry.Registry mRegistry = new PortRegistry.Registry();

    @Test
    public void lockOnce() {
        int i;
        int port = -1;
        boolean locked = false;
        for (i = 0; i < 100; ++i) {
            port = PortRegistry.getFreePort();
            if (!this.mRegistry.lockPort(port)) continue;
            locked = true;
            break;
        }
        Assert.assertTrue((boolean)locked);
        for (i = 0; i < 100; ++i) {
            Assert.assertFalse((boolean)this.mRegistry.lockPort(port));
        }
    }

    @Test
    public void lockMany() {
        int numPorts = 20;
        HashSet<Integer> ports = new HashSet<Integer>();
        for (int i = 0; i < numPorts; ++i) {
            ports.add(this.mRegistry.reservePort());
        }
        Assert.assertEquals((long)numPorts, (long)ports.size());
    }

    @Test
    public void lockAndRelease() {
        int port = PortRegistry.getFreePort();
        int successes = 0;
        for (int i = 0; i < 10; ++i) {
            if (!this.mRegistry.lockPort(port)) continue;
            ++successes;
            this.mRegistry.release(port);
        }
        Assert.assertThat((Object)successes, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(5)));
    }

    @Test
    public void releaseDeletesFile() {
        int successes = 0;
        for (int i = 0; i < 5; ++i) {
            int port = this.mRegistry.reservePort();
            File portFile = this.mRegistry.portFile(port);
            Assert.assertTrue((boolean)portFile.exists());
            this.mRegistry.release(port);
            if (portFile.exists()) continue;
            ++successes;
        }
        Assert.assertThat((Object)successes, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(2)));
    }
}

