/*
 * Decompiled with CFR 0.152.
 */
package alluxio.server.ft;

import alluxio.AlluxioURI;
import alluxio.ClientContext;
import alluxio.UnderFileSystemFactoryRegistryRule;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.block.BlockMasterClient;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.DeletePOptions;
import alluxio.grpc.FreePOptions;
import alluxio.grpc.WritePType;
import alluxio.master.MasterClientContext;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.testutils.underfs.delegating.DelegatingUnderFileSystem;
import alluxio.testutils.underfs.delegating.DelegatingUnderFileSystemFactory;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemFactory;
import alluxio.util.CommonUtils;
import alluxio.util.WaitForOptions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ThreadLocalRandom;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="yuyang", comment="fix the tests")
public final class FlakyUfsIntegrationTest
extends BaseIntegrationTest {
    private static final String LOCAL_UFS_PATH = com.google.common.io.Files.createTempDir().getAbsolutePath();
    private static final UnderFileSystem UFS = new DelegatingUnderFileSystem(UnderFileSystem.Factory.create((String)LOCAL_UFS_PATH, (AlluxioConfiguration)Configuration.global())){

        @Override
        public boolean deleteFile(String path) throws IOException {
            if (ThreadLocalRandom.current().nextBoolean()) {
                return this.mUfs.deleteFile(path);
            }
            return false;
        }

        @Override
        public boolean deleteExistingFile(String path) throws IOException {
            if (ThreadLocalRandom.current().nextBoolean()) {
                return this.mUfs.deleteExistingFile(path);
            }
            return false;
        }
    };
    @ClassRule
    public static UnderFileSystemFactoryRegistryRule sUnderfilesystemfactoryregistry = new UnderFileSystemFactoryRegistryRule((UnderFileSystemFactory)new DelegatingUnderFileSystemFactory(UFS));
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS, "delegating://" + LOCAL_UFS_PATH).build();
    private FileSystem mFs;

    @Before
    public void before() throws Exception {
        this.mFs = this.mLocalAlluxioClusterResource.get().getClient();
    }

    @Ignore(value="this test need to be fixed")
    public void deletePartial() throws Exception {
        this.mFs.createDirectory(new AlluxioURI("/dir"));
        for (int i = 0; i < 100; ++i) {
            FileSystemTestUtils.createByteFile((FileSystem)this.mFs, (String)("/dir/test" + i), (int)100, (CreateFilePOptions)CreateFilePOptions.newBuilder().setWriteType(WritePType.CACHE_THROUGH).build());
        }
        String ufs = LOCAL_UFS_PATH;
        Files.createDirectory(Paths.get(ufs, "/dir/testunknown"), new FileAttribute[0]);
        try {
            this.mFs.delete(new AlluxioURI("/dir"), DeletePOptions.newBuilder().setRecursive(true).build());
            Assert.fail((String)"Expected an exception to be thrown");
        }
        catch (AlluxioException alluxioException) {
            // empty catch block
        }
        int deleted = 0;
        for (int i = 0; i < 100; ++i) {
            if (this.mFs.exists(new AlluxioURI("/dir/test" + i))) continue;
            ++deleted;
        }
        Assert.assertThat((Object)deleted, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(10)));
        Assert.assertThat((Object)deleted, (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(90)));
        this.mFs.free(new AlluxioURI("/"), FreePOptions.newBuilder().setRecursive(true).build());
        BlockMasterClient blockClient = BlockMasterClient.Factory.create((MasterClientContext)MasterClientContext.newBuilder((ClientContext)ClientContext.create((AlluxioConfiguration)Configuration.global())).build());
        CommonUtils.waitFor((String)"data to be freed", () -> {
            try {
                return blockClient.getUsedBytes() == 0L;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(10000L));
    }
}

