/*
 * Decompiled with CFR 0.152.
 */
package alluxio.server.ft.journal;

import alluxio.AlluxioURI;
import alluxio.ClientContext;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.RetryHandlingFileSystemMasterClient;
import alluxio.client.meta.RetryHandlingMetaMasterClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AccessControlException;
import alluxio.grpc.BackupPOptions;
import alluxio.grpc.BackupPRequest;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.UfsPMode;
import alluxio.grpc.UpdateUfsModePOptions;
import alluxio.grpc.WritePType;
import alluxio.master.LocalAlluxioCluster;
import alluxio.master.MasterClientContext;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import java.io.File;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.REMOVE, owner="jiacheng", comment="journal is deprecated")
public class JournalCheckpointIntegrationTest
extends BaseIntegrationTest {
    @Rule
    public LocalAlluxioClusterResource mClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.MASTER_JOURNAL_TAILER_SHUTDOWN_QUIET_WAIT_TIME_MS, 0).setNumWorkers(0).build();
    @Rule
    public TemporaryFolder mFolder = new TemporaryFolder();
    public LocalAlluxioCluster mCluster;

    @Before
    public void before() {
        this.mCluster = this.mClusterResource.get();
    }

    @Test
    public void recoverMounts() throws Exception {
        AlluxioURI alluxioMount1 = new AlluxioURI("/mount1");
        AlluxioURI alluxioMount2 = new AlluxioURI("/mount2");
        AlluxioURI fileMount1 = new AlluxioURI(this.mFolder.newFolder("1").getAbsolutePath());
        AlluxioURI fileMount2 = new AlluxioURI(this.mFolder.newFolder("2").getAbsolutePath());
        this.mCluster.getClient().mount(alluxioMount1, fileMount1);
        this.mCluster.getClient().mount(alluxioMount2, fileMount2);
        this.backupAndRestore();
        Assert.assertEquals((long)3L, (long)this.mCluster.getClient().getMountTable().size());
        this.mCluster.getClient().unmount(alluxioMount1);
        Assert.assertEquals((long)2L, (long)this.mCluster.getClient().getMountTable().size());
        Configuration.unset((PropertyKey)PropertyKey.MASTER_JOURNAL_INIT_FROM_BACKUP);
    }

    @Test
    public void recoverUfsState() throws Exception {
        RetryHandlingFileSystemMasterClient client = new RetryHandlingFileSystemMasterClient(MasterClientContext.newBuilder((ClientContext)ClientContext.create((AlluxioConfiguration)Configuration.global())).build());
        client.updateUfsMode(new AlluxioURI(""), UpdateUfsModePOptions.newBuilder().setUfsMode(UfsPMode.READ_ONLY).build());
        this.backupAndRestore();
        try {
            this.mCluster.getClient().createDirectory(new AlluxioURI("/test"), CreateDirectoryPOptions.newBuilder().setWriteType(WritePType.THROUGH).build());
            Assert.fail((String)"Expected an exception to be thrown");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    private void backupAndRestore() throws Exception {
        File backup = this.mFolder.newFolder("backup");
        RetryHandlingMetaMasterClient metaClient = new RetryHandlingMetaMasterClient(MasterClientContext.newBuilder((ClientContext)ClientContext.create((AlluxioConfiguration)Configuration.global())).build());
        AlluxioURI backupURI = metaClient.backup(BackupPRequest.newBuilder().setTargetDirectory(backup.getAbsolutePath()).setOptions(BackupPOptions.newBuilder().setLocalFileSystem(true)).build()).getBackupUri();
        Configuration.set((PropertyKey)PropertyKey.MASTER_JOURNAL_INIT_FROM_BACKUP, (Object)backupURI);
        this.mCluster.formatAndRestartMasters();
    }
}

