/*
 * Decompiled with CFR 0.152.
 */
package alluxio.server.ft.journal;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.WriteType;
import alluxio.client.file.FileSystem;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.exception.FileAlreadyExistsException;
import alluxio.exception.status.CancelledException;
import alluxio.exception.status.UnavailableException;
import alluxio.master.LocalAlluxioCluster;
import alluxio.master.journal.JournalType;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.util.CommonUtils;
import alluxio.util.WaitForOptions;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.REMOVE, owner="jiacheng", comment="journal is deprecated")
public class JournalIntegrationTest {
    private static final Logger LOG = LoggerFactory.getLogger(JournalIntegrationTest.class);
    @Rule
    public LocalAlluxioClusterResource mClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.MASTER_JOURNAL_TYPE, JournalType.UFS).setProperty(PropertyKey.MASTER_JOURNAL_TAILER_SHUTDOWN_QUIET_WAIT_TIME_MS, 0).setProperty(PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT, WriteType.MUST_CACHE).setNumWorkers(0).build();
    private LocalAlluxioCluster mCluster;
    private AtomicReference<Exception> mException = new AtomicReference();

    @Before
    public void before() {
        this.mCluster = this.mClusterResource.get();
    }

    @Test
    public void recoverAfterSingleRestart() throws Exception {
        AlluxioURI testFile = new AlluxioURI("/testFile");
        this.mCluster.getClient().createFile(testFile).close();
        this.mCluster.restartMasters();
        Assert.assertTrue((boolean)this.mCluster.getClient().exists(testFile));
    }

    @Test
    public void recoverAfterDoubleRestart() throws Exception {
        AlluxioURI testFile = new AlluxioURI("/testFile");
        this.mCluster.getClient().createFile(testFile).close();
        this.mCluster.restartMasters();
        this.mCluster.restartMasters();
        Assert.assertTrue((boolean)this.mCluster.getClient().exists(testFile));
    }

    @Test
    public void concurrentWriteAndRestart() throws Exception {
        FileToucher toucher = new FileToucher();
        Thread t = new Thread(toucher);
        t.start();
        try {
            CommonUtils.waitFor((String)"20 files to be created", () -> toucher.getFilesTouched() >= 20, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(5000L));
            this.mCluster.restartMasters();
        }
        catch (Exception e) {
            this.checkException();
            throw e;
        }
        finally {
            t.interrupt();
        }
        t.join();
        this.checkException();
        int numFiles = this.mCluster.getClient().listStatus(new AlluxioURI("/")).size();
        Assert.assertTrue((numFiles == toucher.getFilesTouched() || numFiles == toucher.getFilesTouched() + 1 ? 1 : 0) != 0);
    }

    private void checkException() throws Exception {
        if (this.mException.get() != null) {
            throw this.mException.get();
        }
    }

    private class FileToucher
    implements Runnable {
        private AtomicInteger mFilesTouched = new AtomicInteger(0);

        private FileToucher() {
        }

        @Override
        public void run() {
            FileSystem fs;
            try {
                fs = JournalIntegrationTest.this.mCluster.getClient();
            }
            catch (IOException e) {
                JournalIntegrationTest.this.mException.set(e);
                return;
            }
            while (!Thread.interrupted()) {
                try {
                    fs.createFile(new AlluxioURI("/file-" + UUID.randomUUID()));
                    this.mFilesTouched.incrementAndGet();
                }
                catch (FileAlreadyExistsException e) {
                    this.mFilesTouched.incrementAndGet();
                }
                catch (UnavailableException e) {
                }
                catch (AlluxioException | IOException e) {
                    if (e.getCause() instanceof CancelledException) continue;
                    JournalIntegrationTest.this.mException.set(e);
                }
            }
        }

        public int getFilesTouched() {
            return this.mFilesTouched.get();
        }
    }
}

