/*
 * Decompiled with CFR 0.152.
 */
package alluxio.server.ft.journal;

import alluxio.AlluxioTestDirectory;
import alluxio.AlluxioURI;
import alluxio.ClientContext;
import alluxio.client.file.FileSystem;
import alluxio.client.meta.RetryHandlingMetaMasterClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.BackupPOptions;
import alluxio.grpc.BackupPRequest;
import alluxio.master.MasterClientContext;
import alluxio.master.journal.JournalType;
import alluxio.multi.process.MultiProcessCluster;
import alluxio.multi.process.PortCoordination;
import alluxio.testutils.BaseIntegrationTest;
import java.io.File;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public final class JournalMigrationIntegrationTest
extends BaseIntegrationTest {
    private static final int NUM_DIRS = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void migration() throws Exception {
        MultiProcessCluster cluster = MultiProcessCluster.newBuilder((List)PortCoordination.JOURNAL_MIGRATION).setClusterName("journalMigration").setNumMasters(3).addProperty(PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.UFS).addProperty(PropertyKey.ZOOKEEPER_SESSION_TIMEOUT, (Object)"1sec").addProperty(PropertyKey.MASTER_BACKUP_DELEGATION_ENABLED, (Object)false).build();
        try {
            cluster.start();
            FileSystem fs = cluster.getFileSystemClient();
            RetryHandlingMetaMasterClient metaClient = new RetryHandlingMetaMasterClient(MasterClientContext.newBuilder((ClientContext)ClientContext.create((AlluxioConfiguration)Configuration.global())).setMasterInquireClient(cluster.getMasterInquireClient()).build());
            for (int i = 0; i < 10; ++i) {
                fs.createDirectory(new AlluxioURI("/dir" + i));
            }
            File backupsDir = AlluxioTestDirectory.createTemporaryDirectory((String)"backups");
            AlluxioURI zkBackup = metaClient.backup(BackupPRequest.newBuilder().setTargetDirectory(backupsDir.getAbsolutePath()).setOptions(BackupPOptions.newBuilder().setLocalFileSystem(false)).build()).getBackupUri();
            cluster.updateMasterConf(PropertyKey.MASTER_JOURNAL_INIT_FROM_BACKUP, zkBackup.toString());
            cluster.stopMasters();
            cluster.formatJournal();
            cluster.updateDeployMode(MultiProcessCluster.DeployMode.EMBEDDED);
            cluster.startMasters();
            Assert.assertEquals((long)10L, (long)fs.listStatus(new AlluxioURI("/")).size());
            cluster.stopMasters();
            cluster.formatJournal();
            cluster.updateDeployMode(MultiProcessCluster.DeployMode.ZOOKEEPER_HA);
            cluster.startMasters();
            Assert.assertEquals((long)10L, (long)fs.listStatus(new AlluxioURI("/")).size());
            cluster.notifySuccess();
        }
        finally {
            cluster.destroy();
        }
    }
}

