/*
 * Decompiled with CFR 0.152.
 */
package alluxio.server.ft.journal;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.conf.PropertyKey;
import alluxio.grpc.DeletePOptions;
import alluxio.master.LocalAlluxioCluster;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.REMOVE, owner="jiacheng", comment="journal is deprecated")
public final class JournalReplayIntegrationTest
extends BaseIntegrationTest {
    @Rule
    public LocalAlluxioClusterResource mClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.MASTER_JOURNAL_TAILER_SHUTDOWN_QUIET_WAIT_TIME_MS, 0).setNumWorkers(0).build();
    @Rule
    public TemporaryFolder mFolder = new TemporaryFolder();
    private LocalAlluxioCluster mCluster;
    private FileSystem mFs;

    @Before
    public void before() throws Exception {
        this.mCluster = this.mClusterResource.get();
        this.mFs = this.mCluster.getClient();
    }

    @Test
    public void mountDeleteMount() throws Exception {
        AlluxioURI alluxioPath = new AlluxioURI("/mnt");
        AlluxioURI ufsPath = new AlluxioURI(this.mFolder.newFolder().getAbsolutePath());
        this.mFs.mount(alluxioPath, ufsPath);
        this.mFs.delete(alluxioPath, DeletePOptions.newBuilder().setRecursive(true).setDeleteMountPoint(true).build());
        this.mFs.mount(alluxioPath, ufsPath);
        this.mCluster.restartMasters();
        this.mFs = this.mCluster.getClient();
        List status = this.mFs.listStatus(new AlluxioURI("/"));
        Assert.assertEquals((long)1L, (long)status.size());
        Assert.assertTrue((boolean)((URIStatus)status.get(0)).isMountPoint());
    }
}

