/*
 * Decompiled with CFR 0.152.
 */
package alluxio.server.ft.journal;

import alluxio.AlluxioURI;
import alluxio.AuthenticatedUserRule;
import alluxio.ConfigurationRule;
import alluxio.SystemPropertyRule;
import alluxio.client.WriteType;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.master.LocalAlluxioCluster;
import alluxio.master.MultiMasterLocalAlluxioCluster;
import alluxio.multi.process.MultiProcessCluster;
import alluxio.multi.process.PortCoordination;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.IntegrationTestUtils;
import alluxio.testutils.master.FsMasterResource;
import alluxio.testutils.master.MasterTestUtils;
import alluxio.testutils.underfs.sleeping.SleepingUnderFileSystem;
import alluxio.testutils.underfs.sleeping.SleepingUnderFileSystemFactory;
import alluxio.testutils.underfs.sleeping.SleepingUnderFileSystemOptions;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.UnderFileSystemFactory;
import alluxio.underfs.UnderFileSystemFactoryRegistry;
import alluxio.util.CommonUtils;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@Ignore
public class JournalShutdownIntegrationTest
extends BaseIntegrationTest {
    @ClassRule
    public static SystemPropertyRule sDisableHdfsCacheRule = new SystemPropertyRule("fs.hdfs.impl.disable.cache", "true");
    @Rule
    public AuthenticatedUserRule mAuthenticatedUser = new AuthenticatedUserRule("test", Configuration.global());
    @Rule
    private TestName mTestName = new TestName();
    @Rule
    public ConfigurationRule mConfigRule = new ConfigurationRule((Map)new ImmutableMap.Builder().put((Object)PropertyKey.MASTER_JOURNAL_TAILER_SHUTDOWN_QUIET_WAIT_TIME_MS, (Object)"100").put((Object)PropertyKey.MASTER_JOURNAL_CHECKPOINT_PERIOD_ENTRIES, (Object)2).put((Object)PropertyKey.MASTER_JOURNAL_LOG_SIZE_BYTES_MAX, (Object)128).put((Object)PropertyKey.USER_RPC_RETRY_MAX_SLEEP_MS, (Object)"1sec").build(), Configuration.modifiableGlobal());
    private static final long SHUTDOWN_TIME_MS = 15000L;
    private static final String TEST_FILE_DIR = "/files/";
    private static final int TEST_NUM_MASTERS = 3;
    private static final long TEST_TIME_MS = 1000L;
    private ClientThread mCreateFileThread;
    private ExecutorService mExecutorsForClient;
    private FileSystemContext mFsContext;

    @Before
    public final void before() throws Exception {
        this.mExecutorsForClient = Executors.newFixedThreadPool(1);
        this.mFsContext = FileSystemContext.create((AlluxioConfiguration)Configuration.global());
    }

    @After
    public final void after() throws Exception {
        this.mExecutorsForClient.shutdown();
        this.mFsContext.close();
        Configuration.reloadProperties();
        Configuration.set((PropertyKey)PropertyKey.USER_METRICS_COLLECTION_ENABLED, (Object)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void singleMasterJournalStopIntegration() throws Exception {
        MultiProcessCluster cluster = MultiProcessCluster.newBuilder((List)PortCoordination.JOURNAL_STOP_SINGLE_MASTER).setClusterName("singleMasterJournalStopIntegration").setNumWorkers(0).setNumMasters(1).build();
        try {
            cluster.start();
            FileSystem fs = cluster.getFileSystemClient();
            this.runCreateFileThread(fs);
            cluster.waitForAndKillPrimaryMaster(10000);
            this.awaitClientTermination();
            cluster.startMaster(0);
            int actualFiles = fs.listStatus(new AlluxioURI(TEST_FILE_DIR)).size();
            int successFiles = this.mCreateFileThread.getSuccessNum();
            Assert.assertTrue((String)String.format("successFiles: %s, actualFiles: %s", successFiles, actualFiles), (successFiles == actualFiles || successFiles + 1 == actualFiles ? 1 : 0) != 0);
            cluster.notifySuccess();
        }
        finally {
            cluster.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void multiMasterJournalStopIntegration() throws Exception {
        MultiProcessCluster cluster = MultiProcessCluster.newBuilder((List)PortCoordination.JOURNAL_STOP_MULTI_MASTER).setClusterName("multiMasterJournalStopIntegration").setNumWorkers(0).setNumMasters(3).addProperty(PropertyKey.ZOOKEEPER_SESSION_TIMEOUT, (Object)"6s").build();
        try {
            cluster.start();
            FileSystem fs = cluster.getFileSystemClient();
            this.runCreateFileThread(fs);
            for (int i = 0; i < 3; ++i) {
                cluster.waitForAndKillPrimaryMaster(30000);
            }
            this.awaitClientTermination();
            cluster.startMaster(0);
            int actualFiles = fs.listStatus(new AlluxioURI(TEST_FILE_DIR)).size();
            int successFiles = this.mCreateFileThread.getSuccessNum();
            Assert.assertTrue((String)String.format("successFiles: %s, actualFiles: %s", successFiles, actualFiles), (successFiles == actualFiles || successFiles + 1 == actualFiles ? 1 : 0) != 0);
            cluster.notifySuccess();
        }
        finally {
            cluster.destroy();
        }
    }

    @Test
    public void singleMasterMountUnmountJournal() throws Exception {
        LocalAlluxioCluster cluster = this.setupSingleMasterCluster();
        UnderFileSystemFactory factory = this.mountUnmount(cluster.getClient());
        cluster.stopFS();
        CommonUtils.sleepMs((long)1000L);
        this.awaitClientTermination();
        ((UnderFileSystemFactory)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)factory)).create(ArgumentMatchers.anyString(), (UnderFileSystemConfiguration)ArgumentMatchers.any(UnderFileSystemConfiguration.class));
        this.createFsMasterFromJournal().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void multiMasterMountUnmountJournal() throws Exception {
        MultiMasterLocalAlluxioCluster cluster = null;
        UnderFileSystemFactory factory = null;
        try {
            cluster = new MultiMasterLocalAlluxioCluster(3);
            cluster.initConfiguration(IntegrationTestUtils.getTestName(this.getClass().getSimpleName(), this.mTestName.getMethodName()));
            cluster.start();
            cluster.stopLeader();
            factory = this.mountUnmount(cluster.getClient());
            for (int kills = 0; kills < 3; ++kills) {
                cluster.waitForNewMaster(120000);
                Assert.assertTrue((boolean)cluster.stopLeader());
            }
        }
        finally {
            if (cluster != null) {
                cluster.stopFS();
            }
        }
        CommonUtils.sleepMs((long)1000L);
        this.awaitClientTermination();
        ((UnderFileSystemFactory)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)factory)).create(ArgumentMatchers.anyString(), (UnderFileSystemConfiguration)ArgumentMatchers.any(UnderFileSystemConfiguration.class));
        this.createFsMasterFromJournal().close();
    }

    private UnderFileSystemFactory mountUnmount(FileSystem fs) throws Exception {
        SleepingUnderFileSystem sleepingUfs = new SleepingUnderFileSystem(new AlluxioURI("sleep:///"), new SleepingUnderFileSystemOptions(), UnderFileSystemConfiguration.defaults((AlluxioConfiguration)Configuration.global()));
        SleepingUnderFileSystemFactory sleepingUfsFactory = new SleepingUnderFileSystemFactory(sleepingUfs);
        UnderFileSystemFactoryRegistry.register((UnderFileSystemFactory)sleepingUfsFactory);
        fs.mount(new AlluxioURI("/mnt"), new AlluxioURI("sleep:///"));
        fs.unmount(new AlluxioURI("/mnt"));
        return (UnderFileSystemFactory)Mockito.spy((Object)sleepingUfsFactory);
    }

    private void awaitClientTermination() throws Exception {
        this.mExecutorsForClient.shutdownNow();
        if (!this.mExecutorsForClient.awaitTermination(15000L, TimeUnit.MILLISECONDS)) {
            throw new Exception("Client thread did not terminate");
        }
    }

    private FsMasterResource createFsMasterFromJournal() throws Exception {
        return MasterTestUtils.createLeaderFileSystemMasterFromJournal();
    }

    private LocalAlluxioCluster setupSingleMasterCluster() throws Exception {
        LocalAlluxioCluster cluster = new LocalAlluxioCluster();
        cluster.initConfiguration(IntegrationTestUtils.getTestName(this.getClass().getSimpleName(), this.mTestName.getMethodName()));
        Configuration.set((PropertyKey)PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT, (Object)WriteType.MUST_CACHE);
        cluster.start();
        return cluster;
    }

    private void runCreateFileThread(FileSystem fs) {
        this.mCreateFileThread = new ClientThread(0, fs);
        this.mExecutorsForClient.submit(this.mCreateFileThread);
        CommonUtils.sleepMs((long)1000L);
        while (this.mCreateFileThread.getSuccessNum() == 0) {
            CommonUtils.sleepMs((long)1000L);
        }
    }

    class ClientThread
    implements Runnable {
        private int mSuccessNum = 0;
        private final int mOpType;
        private final FileSystem mFileSystem;

        public ClientThread(int opType, FileSystem fs) {
            this.mOpType = opType;
            this.mFileSystem = fs;
        }

        public int getSuccessNum() {
            return this.mSuccessNum;
        }

        @Override
        public void run() {
            try {
                while (!Thread.interrupted()) {
                    if (this.mOpType == 0) {
                        try {
                            this.mFileSystem.createFile(new AlluxioURI(JournalShutdownIntegrationTest.TEST_FILE_DIR + this.mSuccessNum)).close();
                        }
                        catch (IOException e) {
                            break;
                        }
                    }
                    ++this.mSuccessNum;
                    CommonUtils.sleepMs((long)100L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

