/*
 * Decompiled with CFR 0.152.
 */
package alluxio.server.ft.journal;

import alluxio.AlluxioURI;
import alluxio.client.file.FileSystem;
import alluxio.client.metrics.MetricsMasterClient;
import alluxio.conf.PropertyKey;
import alluxio.grpc.MetricValue;
import alluxio.master.journal.JournalType;
import alluxio.metrics.MetricKey;
import alluxio.multi.process.MultiProcessCluster;
import alluxio.multi.process.PortCoordination;
import alluxio.testutils.IntegrationTestUtils;
import java.net.URI;
import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="In Dora, Client does not use Master/Journal services.")
public class MultiProcessCheckpointTest {
    @Test
    public void testDefault() throws Exception {
        this.runTest(-1, false);
    }

    @Test
    public void testNoCompression() throws Exception {
        this.runTest(0, false);
    }

    @Test
    public void testParallelCompression() throws Exception {
        this.runTest(-1, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runTest(int compressionLevel, boolean parallelCompression) throws Exception {
        MultiProcessCluster cluster = MultiProcessCluster.newBuilder((List)PortCoordination.CHECKPOINT).setClusterName("CheckpointTest").addProperty(PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.UFS).addProperty(PropertyKey.ZOOKEEPER_SESSION_TIMEOUT, (Object)"2sec").addProperty(PropertyKey.ZOOKEEPER_CONNECTION_TIMEOUT, (Object)"1sec").addProperty(PropertyKey.MASTER_METASTORE, (Object)"ROCKS").addProperty(PropertyKey.MASTER_JOURNAL_CHECKPOINT_PERIOD_ENTRIES, (Object)100).addProperty(PropertyKey.MASTER_JOURNAL_LOG_SIZE_BYTES_MAX, (Object)"500").addProperty(PropertyKey.MASTER_JOURNAL_TAILER_SHUTDOWN_QUIET_WAIT_TIME_MS, (Object)"500").addProperty(PropertyKey.MASTER_EMBEDDED_JOURNAL_SNAPSHOT_REPLICATION_COMPRESSION_LEVEL, (Object)compressionLevel).addProperty(PropertyKey.MASTER_METASTORE_ROCKS_PARALLEL_BACKUP, (Object)parallelCompression).setNumMasters(2).setNumWorkers(0).build();
        try {
            cluster.start();
            cluster.waitForAllNodesRegistered(20000);
            String journal = cluster.getJournalDir();
            FileSystem fs = cluster.getFileSystemClient();
            int numFiles = 100;
            for (int i = 0; i < numFiles; ++i) {
                fs.createFile(new AlluxioURI("/file" + i)).close();
            }
            MetricsMasterClient metricsClient = cluster.getMetricsMasterClient();
            Assert.assertEquals((long)(numFiles + 1), (long)((long)((MetricValue)metricsClient.getMetrics().get(MetricKey.MASTER_TOTAL_PATHS.getName())).getDoubleValue()));
            IntegrationTestUtils.waitForUfsJournalCheckpoint("FileSystemMaster", new URI(journal));
            cluster.stopMasters();
            cluster.startMasters();
            cluster.waitForAllNodesRegistered(60000);
            fs = cluster.getFileSystemClient();
            Assert.assertEquals((long)numFiles, (long)fs.listStatus(new AlluxioURI("/")).size());
            Assert.assertEquals((long)(numFiles + 1), (long)((long)((MetricValue)metricsClient.getMetrics().get(MetricKey.MASTER_TOTAL_PATHS.getName())).getDoubleValue()));
            cluster.notifySuccess();
        }
        finally {
            cluster.destroy();
        }
    }
}

