/*
 * Decompiled with CFR 0.152.
 */
package alluxio.server.ft.journal.raft;

import alluxio.ConfigurationRule;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.grpc.NetAddress;
import alluxio.grpc.QuorumServerInfo;
import alluxio.multi.process.MasterNetAddress;
import alluxio.multi.process.MultiProcessCluster;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.util.CommonUtils;
import alluxio.util.WaitForOptions;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import org.junit.After;
import org.junit.Rule;

public class EmbeddedJournalIntegrationTestBase
extends BaseIntegrationTest {
    @Rule
    public ConfigurationRule mConf = new ConfigurationRule(PropertyKey.USER_METRICS_COLLECTION_ENABLED, (Object)false, Configuration.modifiableGlobal());
    public MultiProcessCluster mCluster;
    protected static final int MASTER_INDEX_WAIT_TIME = 5000;

    @After
    public void after() throws Exception {
        if (this.mCluster != null) {
            this.mCluster.destroy();
        }
    }

    protected NetAddress masterEBJAddr2NetAddr(MasterNetAddress masterAddr) {
        return NetAddress.newBuilder().setHost(masterAddr.getHostname()).setRpcPort(masterAddr.getEmbeddedJournalPort()).build();
    }

    protected void waitForQuorumPropertySize(Predicate<? super QuorumServerInfo> pred, int size) throws InterruptedException, TimeoutException {
        int TIMEOUT_1MIN30SEC = 90000;
        CommonUtils.waitFor((String)"quorum property", () -> {
            try {
                return this.mCluster.getJournalMasterClientForMaster().getQuorumInfo().getServerInfoList().stream().filter(pred).count() == (long)size;
            }
            catch (AlluxioStatusException e) {
                return false;
            }
        }, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(90000L));
    }
}

