/*
 * Decompiled with CFR 0.152.
 */
package alluxio.server.ft.journal.ufs;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.FileSystem;
import alluxio.grpc.MountPOptions;
import alluxio.master.file.FileSystemMaster;
import alluxio.master.file.meta.MountTable;
import alluxio.resource.CloseableResource;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.underfs.UfsManager;
import alluxio.underfs.UnderFileSystemConfiguration;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.powermock.reflect.Whitebox;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.REMOVE, owner="jiacheng", comment="journal is deprecated")
public class UfsConfigurationJournalTest {
    private static final String LOCAL_UFS_PATH = Files.createTempDir().getAbsolutePath();
    private FileSystem mFs;
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().build();

    @Before
    public void before() throws Exception {
        this.mFs = this.mLocalAlluxioClusterResource.get().getClient();
    }

    @Test
    public void testOptionsPersisted() throws Exception {
        AlluxioURI mountPoint = new AlluxioURI("/mnt");
        ImmutableMap options = ImmutableMap.of((Object)"k1", (Object)"v1", (Object)"k2", (Object)"v2");
        this.mFs.mount(mountPoint, new AlluxioURI(LOCAL_UFS_PATH), MountPOptions.newBuilder().putAllProperties((Map)options).setReadOnly(true).setShared(true).build());
        MountTable mountTable = (MountTable)Whitebox.getInternalState((Object)this.mLocalAlluxioClusterResource.get().getLocalAlluxioMaster().getMasterProcess().getMaster(FileSystemMaster.class), (String)"mMountTable");
        long mountId = mountTable.resolve(mountPoint).getMountId();
        this.mLocalAlluxioClusterResource.get().restartMasters();
        UfsManager ufsManager = (UfsManager)Whitebox.getInternalState((Object)this.mLocalAlluxioClusterResource.get().getLocalAlluxioMaster().getMasterProcess().getMaster(FileSystemMaster.class), (String)"mUfsManager");
        try (CloseableResource resource = ufsManager.get(mountId).acquireUfsResource();){
            UnderFileSystemConfiguration ufsConf = (UnderFileSystemConfiguration)Whitebox.getInternalState((Object)resource.get(), (String)"mConf");
            Assert.assertEquals((long)ufsConf.getMountSpecificConf().size(), (long)options.size());
            for (Map.Entry entry : options.entrySet()) {
                Assert.assertEquals(entry.getValue(), ufsConf.getMountSpecificConf().get(entry.getKey()));
            }
            Assert.assertTrue((boolean)ufsConf.isReadOnly());
        }
    }
}

