/*
 * Decompiled with CFR 0.152.
 */
package alluxio.server.ft.journal.ufs;

import alluxio.AlluxioTestDirectory;
import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.WriteType;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.DeletePOptions;
import alluxio.grpc.ListStatusPOptions;
import alluxio.grpc.LoadMetadataPType;
import alluxio.grpc.SetAttributePOptions;
import alluxio.grpc.WritePType;
import alluxio.master.LocalAlluxioCluster;
import alluxio.master.Master;
import alluxio.master.NoopMaster;
import alluxio.master.file.FileSystemMaster;
import alluxio.master.file.contexts.GetStatusContext;
import alluxio.master.file.contexts.ListStatusContext;
import alluxio.master.journal.JournalType;
import alluxio.master.journal.ufs.UfsJournal;
import alluxio.master.journal.ufs.UfsJournalSnapshot;
import alluxio.security.authentication.AuthenticatedClientUser;
import alluxio.security.authorization.Mode;
import alluxio.security.group.GroupMappingService;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.testutils.master.FsMasterResource;
import alluxio.testutils.master.MasterTestUtils;
import alluxio.underfs.UfsStatus;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.util.io.PathUtils;
import alluxio.wire.FileInfo;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.REMOVE, owner="jiacheng", comment="journal is deprecated")
public class UfsJournalIntegrationTest
extends BaseIntegrationTest {
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.MASTER_JOURNAL_TYPE, JournalType.UFS).setProperty(PropertyKey.MASTER_JOURNAL_LOG_SIZE_BYTES_MAX, Integer.toString(1024)).setProperty(PropertyKey.MASTER_JOURNAL_CHECKPOINT_PERIOD_ENTRIES, 2).setProperty(PropertyKey.SECURITY_AUTHORIZATION_PERMISSION_ENABLED, false).setProperty(PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT, WriteType.CACHE_THROUGH).setProperty(PropertyKey.MASTER_METASTORE_DIR, AlluxioTestDirectory.createTemporaryDirectory((String)"meta")).build();
    private LocalAlluxioCluster mLocalAlluxioCluster;
    private FileSystem mFileSystem;
    private AlluxioURI mRootUri = new AlluxioURI("/");

    @Before
    public final void before() throws Exception {
        this.mLocalAlluxioCluster = this.mLocalAlluxioClusterResource.get();
        this.mFileSystem = this.mLocalAlluxioCluster.getClient();
    }

    @Test
    public void addBlock() throws Exception {
        AlluxioURI uri = new AlluxioURI("/xyz");
        CreateFilePOptions options = CreateFilePOptions.newBuilder().setBlockSizeBytes(64L).setRecursive(true).build();
        FileOutStream os = this.mFileSystem.createFile(uri, options);
        for (int k = 0; k < 1000; ++k) {
            os.write(k);
        }
        os.close();
        URIStatus status = this.mFileSystem.getStatus(uri);
        this.mLocalAlluxioCluster.stopFS();
        this.addBlockTestUtil(status);
    }

    private void addBlockTestUtil(URIStatus status) throws Exception {
        try (FsMasterResource masterResource = this.createFsMasterFromJournal();){
            FileSystemMaster fsMaster = (FileSystemMaster)masterResource.getRegistry().get(FileSystemMaster.class);
            long rootId = fsMaster.getFileId(this.mRootUri);
            Assert.assertTrue((rootId != -1L ? 1 : 0) != 0);
            Assert.assertEquals((long)1L, (long)fsMaster.listStatus(this.mRootUri, ListStatusContext.mergeFrom((ListStatusPOptions.Builder)ListStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER))).size());
            long xyzId = fsMaster.getFileId(new AlluxioURI("/xyz"));
            Assert.assertTrue((xyzId != -1L ? 1 : 0) != 0);
            FileInfo fsMasterInfo = fsMaster.getFileInfo(xyzId);
            Assert.assertEquals((long)0L, (long)fsMaster.getFileInfo(xyzId).getInMemoryPercentage());
            Assert.assertEquals((Object)status.getBlockIds(), (Object)fsMasterInfo.getBlockIds());
            Assert.assertEquals((long)status.getBlockSizeBytes(), (long)fsMasterInfo.getBlockSizeBytes());
            Assert.assertEquals((long)status.getLength(), (long)fsMasterInfo.getLength());
        }
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.master.journal.log.size.bytes.max", "0"})
    public void multipleFlush() throws Exception {
        String journalFolder = this.mLocalAlluxioCluster.getLocalAlluxioMaster().getJournalFolder();
        this.mLocalAlluxioCluster.stop();
        UfsJournal journal = new UfsJournal(new URI(PathUtils.concatPath((Object)journalFolder, (Object)"FileSystemMaster")), (Master)new NoopMaster(), 0L, Collections::emptySet);
        journal.start();
        journal.gainPrimacy();
        UfsStatus[] paths = UnderFileSystem.Factory.create((String)journalFolder, (AlluxioConfiguration)Configuration.global()).listStatus(journal.getLogDir().toString());
        int expectedSize = paths == null ? 0 : paths.length;
        journal.flush();
        journal.flush();
        journal.flush();
        journal.close();
        paths = UnderFileSystem.Factory.create((String)journalFolder, (AlluxioConfiguration)Configuration.global()).listStatus(journal.getLogDir().toString());
        int actualSize = paths == null ? 0 : paths.length;
        Assert.assertEquals((long)expectedSize, (long)actualSize);
    }

    @Test
    public void loadMetadata() throws Exception {
        String ufsRoot = Configuration.getString((PropertyKey)PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS);
        UnderFileSystem ufs = UnderFileSystem.Factory.createForRoot((AlluxioConfiguration)Configuration.global());
        ufs.create(ufsRoot + "/xyz").close();
        URIStatus status = this.mFileSystem.getStatus(new AlluxioURI("/xyz"));
        this.mLocalAlluxioCluster.stopFS();
        this.loadMetadataTestUtil(status);
        this.deleteFsMasterJournalLogs();
        this.loadMetadataTestUtil(status);
    }

    private void loadMetadataTestUtil(URIStatus status) throws Exception {
        try (FsMasterResource masterResource = this.createFsMasterFromJournal();){
            FileSystemMaster fsMaster = (FileSystemMaster)masterResource.getRegistry().get(FileSystemMaster.class);
            long rootId = fsMaster.getFileId(this.mRootUri);
            Assert.assertTrue((rootId != -1L ? 1 : 0) != 0);
            Assert.assertEquals((long)1L, (long)fsMaster.listStatus(this.mRootUri, ListStatusContext.mergeFrom((ListStatusPOptions.Builder)ListStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER))).size());
            Assert.assertTrue((fsMaster.getFileId(new AlluxioURI("/xyz")) != -1L ? 1 : 0) != 0);
            FileInfo fsMasterInfo = fsMaster.getFileInfo(fsMaster.getFileId(new AlluxioURI("/xyz")));
            Assert.assertEquals((Object)status, (Object)new URIStatus(fsMasterInfo.setMountId(status.getMountId())));
        }
    }

    @Test
    public void completedEditLogDeletion() throws Exception {
        for (int i = 0; i < 124; ++i) {
            this.mFileSystem.createFile(new AlluxioURI("/a" + i), CreateFilePOptions.newBuilder().setBlockSizeBytes((long)((i + 10) / 10 * 64)).build()).close();
        }
        this.mLocalAlluxioCluster.stopFS();
        String journalFolder = PathUtils.concatPath((Object)this.mLocalAlluxioCluster.getLocalAlluxioMaster().getJournalFolder(), (Object)"FileSystemMaster");
        UfsJournal journal = new UfsJournal(new URI(journalFolder), (Master)new NoopMaster(), 0L, Collections::emptySet);
        URI completedLocation = journal.getLogDir();
        Assert.assertTrue((UnderFileSystem.Factory.create((String)completedLocation.toString(), (UnderFileSystemConfiguration)UnderFileSystemConfiguration.defaults((AlluxioConfiguration)Configuration.global())).listStatus(completedLocation.toString()).length > 1 ? 1 : 0) != 0);
        this.multiEditLogTestUtil();
        Assert.assertTrue((UnderFileSystem.Factory.create((String)completedLocation.toString(), (UnderFileSystemConfiguration)UnderFileSystemConfiguration.defaults((AlluxioConfiguration)Configuration.global())).listStatus(completedLocation.toString()).length > 1 ? 1 : 0) != 0);
        this.multiEditLogTestUtil();
    }

    @Test
    public void delete() throws Exception {
        CreateDirectoryPOptions recMkdir = CreateDirectoryPOptions.newBuilder().setRecursive(true).build();
        DeletePOptions recDelete = DeletePOptions.newBuilder().setRecursive(true).build();
        for (int i = 0; i < 10; ++i) {
            String dirPath = "/i" + i;
            this.mFileSystem.createDirectory(new AlluxioURI(dirPath), recMkdir);
            for (int j = 0; j < 10; ++j) {
                CreateFilePOptions option = CreateFilePOptions.newBuilder().setBlockSizeBytes((long)((i + j + 1) * 64)).build();
                String filePath = dirPath + "/j" + j;
                this.mFileSystem.createFile(new AlluxioURI(filePath), option).close();
                if (j < 5) continue;
                this.mFileSystem.delete(new AlluxioURI(filePath), recDelete);
            }
            if (i < 5) continue;
            this.mFileSystem.delete(new AlluxioURI(dirPath), recDelete);
        }
        this.mLocalAlluxioCluster.stopFS();
        this.deleteTestUtil();
        this.deleteFsMasterJournalLogs();
        this.deleteTestUtil();
    }

    private void deleteTestUtil() throws Exception {
        try (FsMasterResource masterResource = this.createFsMasterFromJournal();){
            FileSystemMaster fsMaster = (FileSystemMaster)masterResource.getRegistry().get(FileSystemMaster.class);
            long rootId = fsMaster.getFileId(this.mRootUri);
            Assert.assertTrue((rootId != -1L ? 1 : 0) != 0);
            Assert.assertEquals((long)5L, (long)fsMaster.listStatus(this.mRootUri, ListStatusContext.mergeFrom((ListStatusPOptions.Builder)ListStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER))).size());
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 5; ++j) {
                    Assert.assertTrue((fsMaster.getFileId(new AlluxioURI("/i" + i + "/j" + j)) != -1L ? 1 : 0) != 0);
                }
            }
        }
    }

    @Test
    public void emptyFileSystem() throws Exception {
        Assert.assertEquals((long)0L, (long)this.mFileSystem.listStatus(this.mRootUri).size());
        this.mLocalAlluxioCluster.stopFS();
        try (FsMasterResource masterResource = this.createFsMasterFromJournal();){
            FileSystemMaster fsMaster = (FileSystemMaster)masterResource.getRegistry().get(FileSystemMaster.class);
            long rootId = fsMaster.getFileId(this.mRootUri);
            Assert.assertTrue((rootId != -1L ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)fsMaster.listStatus(this.mRootUri, ListStatusContext.mergeFrom((ListStatusPOptions.Builder)ListStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER))).size());
        }
    }

    @Test
    public void fileDirectory() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.mFileSystem.createDirectory(new AlluxioURI("/i" + i));
            for (int j = 0; j < 10; ++j) {
                CreateFilePOptions option = CreateFilePOptions.newBuilder().setBlockSizeBytes((long)((i + j + 1) * 64)).build();
                this.mFileSystem.createFile(new AlluxioURI("/i" + i + "/j" + j), option).close();
            }
        }
        this.mLocalAlluxioCluster.stopFS();
        this.fileDirectoryTestUtil();
        this.deleteFsMasterJournalLogs();
        this.fileDirectoryTestUtil();
    }

    private void fileDirectoryTestUtil() throws Exception {
        try (FsMasterResource masterResource = this.createFsMasterFromJournal();){
            FileSystemMaster fsMaster = (FileSystemMaster)masterResource.getRegistry().get(FileSystemMaster.class);
            long rootId = fsMaster.getFileId(this.mRootUri);
            Assert.assertTrue((rootId != -1L ? 1 : 0) != 0);
            Assert.assertEquals((long)10L, (long)fsMaster.listStatus(this.mRootUri, ListStatusContext.mergeFrom((ListStatusPOptions.Builder)ListStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER))).size());
            for (int i = 0; i < 10; ++i) {
                for (int j = 0; j < 10; ++j) {
                    Assert.assertTrue((fsMaster.getFileId(new AlluxioURI("/i" + i + "/j" + j)) != -1L ? 1 : 0) != 0);
                }
            }
        }
    }

    @Test
    public void file() throws Exception {
        CreateFilePOptions option = CreateFilePOptions.newBuilder().setBlockSizeBytes(64L).build();
        AlluxioURI filePath = new AlluxioURI("/xyz");
        this.mFileSystem.createFile(filePath, option).close();
        URIStatus status = this.mFileSystem.getStatus(filePath);
        this.mLocalAlluxioCluster.stopFS();
        this.fileTestUtil(status);
        this.deleteFsMasterJournalLogs();
        this.fileTestUtil(status);
    }

    private void fileTestUtil(URIStatus status) throws Exception {
        try (FsMasterResource masterResource = this.createFsMasterFromJournal();){
            FileSystemMaster fsMaster = (FileSystemMaster)masterResource.getRegistry().get(FileSystemMaster.class);
            long rootId = fsMaster.getFileId(this.mRootUri);
            Assert.assertTrue((rootId != -1L ? 1 : 0) != 0);
            Assert.assertEquals((long)1L, (long)fsMaster.listStatus(this.mRootUri, ListStatusContext.mergeFrom((ListStatusPOptions.Builder)ListStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER))).size());
            long fileId = fsMaster.getFileId(new AlluxioURI("/xyz"));
            Assert.assertTrue((fileId != -1L ? 1 : 0) != 0);
            Assert.assertEquals((Object)status, (Object)new URIStatus(fsMaster.getFileInfo(fileId).setMountId(status.getMountId())));
        }
    }

    @Test
    public void pin() throws Exception {
        SetAttributePOptions setPinned = SetAttributePOptions.newBuilder().setPinned(true).build();
        SetAttributePOptions setUnpinned = SetAttributePOptions.newBuilder().setPinned(false).build();
        AlluxioURI dirUri = new AlluxioURI("/myFolder");
        this.mFileSystem.createDirectory(dirUri);
        this.mFileSystem.setAttribute(dirUri, setPinned);
        AlluxioURI file0Path = new AlluxioURI("/myFolder/file0");
        CreateFilePOptions op = CreateFilePOptions.newBuilder().setBlockSizeBytes(64L).build();
        this.mFileSystem.createFile(file0Path, op).close();
        this.mFileSystem.setAttribute(file0Path, setUnpinned);
        AlluxioURI file1Path = new AlluxioURI("/myFolder/file1");
        this.mFileSystem.createFile(file1Path, op).close();
        URIStatus directoryStatus = this.mFileSystem.getStatus(dirUri);
        URIStatus file0Status = this.mFileSystem.getStatus(file0Path);
        URIStatus file1Status = this.mFileSystem.getStatus(file1Path);
        this.mLocalAlluxioCluster.stopFS();
        this.pinTestUtil(directoryStatus, file0Status, file1Status);
        this.deleteFsMasterJournalLogs();
        this.pinTestUtil(directoryStatus, file0Status, file1Status);
    }

    private void pinTestUtil(URIStatus directory, URIStatus file0, URIStatus file1) throws Exception {
        try (FsMasterResource masterResource = this.createFsMasterFromJournal();){
            FileSystemMaster fsMaster = (FileSystemMaster)masterResource.getRegistry().get(FileSystemMaster.class);
            FileInfo info = fsMaster.getFileInfo(fsMaster.getFileId(new AlluxioURI("/myFolder")));
            Assert.assertEquals((Object)directory, (Object)new URIStatus(info.setMountId(directory.getMountId())));
            Assert.assertTrue((boolean)info.isPinned());
            info = fsMaster.getFileInfo(fsMaster.getFileId(new AlluxioURI("/myFolder/file0")));
            Assert.assertEquals((Object)file0, (Object)new URIStatus(info.setMountId(file0.getMountId())));
            Assert.assertFalse((boolean)info.isPinned());
            info = fsMaster.getFileInfo(fsMaster.getFileId(new AlluxioURI("/myFolder/file1")));
            Assert.assertEquals((Object)file1, (Object)new URIStatus(info.setMountId(file1.getMountId())));
            Assert.assertTrue((boolean)info.isPinned());
        }
    }

    @Test
    public void directory() throws Exception {
        AlluxioURI directoryPath = new AlluxioURI("/xyz");
        this.mFileSystem.createDirectory(directoryPath);
        URIStatus status = this.mFileSystem.getStatus(directoryPath);
        this.mLocalAlluxioCluster.stopFS();
        this.directoryTestUtil(status);
        this.deleteFsMasterJournalLogs();
        this.directoryTestUtil(status);
    }

    private void directoryTestUtil(URIStatus status) throws Exception {
        try (FsMasterResource masterResource = this.createFsMasterFromJournal();){
            FileSystemMaster fsMaster = (FileSystemMaster)masterResource.getRegistry().get(FileSystemMaster.class);
            long rootId = fsMaster.getFileId(this.mRootUri);
            Assert.assertTrue((rootId != -1L ? 1 : 0) != 0);
            Assert.assertEquals((long)1L, (long)fsMaster.listStatus(this.mRootUri, ListStatusContext.mergeFrom((ListStatusPOptions.Builder)ListStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER))).size());
            long fileId = fsMaster.getFileId(new AlluxioURI("/xyz"));
            Assert.assertTrue((fileId != -1L ? 1 : 0) != 0);
            Assert.assertEquals((Object)status, (Object)new URIStatus(fsMaster.getFileInfo(fileId).setMountId(status.getMountId())));
        }
    }

    @Test
    public void persistDirectoryLater() throws Exception {
        String[] directories = new String[]{"/d11", "/d11/d21", "/d11/d22", "/d12", "/d12/d21", "/d12/d22"};
        CreateDirectoryPOptions options = CreateDirectoryPOptions.newBuilder().setRecursive(true).setWriteType(WritePType.MUST_CACHE).build();
        for (String directory : directories) {
            this.mFileSystem.createDirectory(new AlluxioURI(directory), options);
        }
        options = options.toBuilder().setWriteType(WritePType.CACHE_THROUGH).setAllowExists(true).build();
        for (String directory : directories) {
            this.mFileSystem.createDirectory(new AlluxioURI(directory), options);
        }
        HashMap<String, URIStatus> directoryStatuses = new HashMap<String, URIStatus>();
        for (String directory : directories) {
            directoryStatuses.put(directory, this.mFileSystem.getStatus(new AlluxioURI(directory)));
        }
        this.mLocalAlluxioCluster.stopFS();
        this.persistDirectoryLaterTestUtil(directoryStatuses);
        this.deleteFsMasterJournalLogs();
        this.persistDirectoryLaterTestUtil(directoryStatuses);
    }

    private void persistDirectoryLaterTestUtil(Map<String, URIStatus> directoryStatuses) throws Exception {
        try (FsMasterResource masterResource = this.createFsMasterFromJournal();){
            FileSystemMaster fsMaster = (FileSystemMaster)masterResource.getRegistry().get(FileSystemMaster.class);
            for (Map.Entry<String, URIStatus> directoryStatus : directoryStatuses.entrySet()) {
                Assert.assertEquals((Object)directoryStatus.getValue(), (Object)new URIStatus(fsMaster.getFileInfo(fsMaster.getFileId(new AlluxioURI(directoryStatus.getKey()))).setMountId(directoryStatus.getValue().getMountId())));
            }
        }
    }

    @Test
    public void manyFile() throws Exception {
        for (int i = 0; i < 10; ++i) {
            CreateFilePOptions option = CreateFilePOptions.newBuilder().setBlockSizeBytes((long)((i + 1) * 64)).build();
            this.mFileSystem.createFile(new AlluxioURI("/a" + i), option).close();
        }
        this.mLocalAlluxioCluster.stopFS();
        this.manyFileTestUtil();
        this.deleteFsMasterJournalLogs();
        this.manyFileTestUtil();
    }

    private void manyFileTestUtil() throws Exception {
        try (FsMasterResource masterResource = this.createFsMasterFromJournal();){
            FileSystemMaster fsMaster = (FileSystemMaster)masterResource.getRegistry().get(FileSystemMaster.class);
            long rootId = fsMaster.getFileId(this.mRootUri);
            Assert.assertTrue((rootId != -1L ? 1 : 0) != 0);
            Assert.assertEquals((long)10L, (long)fsMaster.listStatus(this.mRootUri, ListStatusContext.mergeFrom((ListStatusPOptions.Builder)ListStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER))).size());
            for (int k = 0; k < 10; ++k) {
                Assert.assertTrue((fsMaster.getFileId(new AlluxioURI("/a" + k)) != -1L ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void multiEditLog() throws Exception {
        for (int i = 0; i < 124; ++i) {
            CreateFilePOptions op = CreateFilePOptions.newBuilder().setBlockSizeBytes((long)((i + 10) / 10 * 64)).build();
            this.mFileSystem.createFile(new AlluxioURI("/a" + i), op).close();
        }
        this.mLocalAlluxioCluster.stopFS();
        this.multiEditLogTestUtil();
        this.deleteFsMasterJournalLogs();
        this.multiEditLogTestUtil();
    }

    private void multiEditLogTestUtil() throws Exception {
        try (FsMasterResource masterResource = this.createFsMasterFromJournal();){
            FileSystemMaster fsMaster = (FileSystemMaster)masterResource.getRegistry().get(FileSystemMaster.class);
            long rootId = fsMaster.getFileId(this.mRootUri);
            Assert.assertTrue((rootId != -1L ? 1 : 0) != 0);
            Assert.assertEquals((long)124L, (long)fsMaster.listStatus(this.mRootUri, ListStatusContext.mergeFrom((ListStatusPOptions.Builder)ListStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER))).size());
            for (int k = 0; k < 124; ++k) {
                Assert.assertTrue((fsMaster.getFileId(new AlluxioURI("/a" + k)) != -1L ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void rename() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.mFileSystem.createDirectory(new AlluxioURI("/i" + i));
            for (int j = 0; j < 10; ++j) {
                CreateFilePOptions option = CreateFilePOptions.newBuilder().setBlockSizeBytes((long)((i + j + 1) * 64)).build();
                AlluxioURI path = new AlluxioURI("/i" + i + "/j" + j);
                this.mFileSystem.createFile(path, option).close();
                this.mFileSystem.rename(path, new AlluxioURI("/i" + i + "/jj" + j));
            }
            this.mFileSystem.rename(new AlluxioURI("/i" + i), new AlluxioURI("/ii" + i));
        }
        this.mLocalAlluxioCluster.stopFS();
        this.renameTestUtil();
        this.deleteFsMasterJournalLogs();
        this.renameTestUtil();
    }

    private void renameTestUtil() throws Exception {
        try (FsMasterResource masterResource = this.createFsMasterFromJournal();){
            FileSystemMaster fsMaster = (FileSystemMaster)masterResource.getRegistry().get(FileSystemMaster.class);
            long rootId = fsMaster.getFileId(this.mRootUri);
            Assert.assertTrue((rootId != -1L ? 1 : 0) != 0);
            Assert.assertEquals((long)10L, (long)fsMaster.listStatus(this.mRootUri, ListStatusContext.mergeFrom((ListStatusPOptions.Builder)ListStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER))).size());
            for (int i = 0; i < 10; ++i) {
                for (int j = 0; j < 10; ++j) {
                    Assert.assertTrue((fsMaster.getFileId(new AlluxioURI("/ii" + i + "/jj" + j)) != -1L ? 1 : 0) != 0);
                }
            }
        }
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.security.authentication.type", "SIMPLE", "alluxio.security.authorization.permission.enabled", "true", "alluxio.security.group.mapping.class", "alluxio.server.ft.journal.ufs.UfsJournalIntegrationTest$FakeUserGroupsMapping"})
    public void setAcl() throws Exception {
        AlluxioURI filePath = new AlluxioURI("/file");
        String user = "alluxio";
        Configuration.set((PropertyKey)PropertyKey.SECURITY_LOGIN_USERNAME, (Object)user);
        CreateFilePOptions op = CreateFilePOptions.newBuilder().setBlockSizeBytes(64L).build();
        this.mFileSystem.createFile(filePath, op).close();
        this.mFileSystem.setAttribute(filePath, SetAttributePOptions.newBuilder().setMode(new Mode(256).toProto()).setRecursive(false).build());
        URIStatus status = this.mFileSystem.getStatus(filePath);
        this.mLocalAlluxioCluster.stopFS();
        this.aclTestUtil(status, user);
        this.deleteFsMasterJournalLogs();
        this.aclTestUtil(status, user);
    }

    private void aclTestUtil(URIStatus status, String user) throws Exception {
        try (FsMasterResource masterResource = this.createFsMasterFromJournal();){
            FileSystemMaster fsMaster = (FileSystemMaster)masterResource.getRegistry().get(FileSystemMaster.class);
            AuthenticatedClientUser.set((String)user);
            FileInfo info = fsMaster.getFileInfo(new AlluxioURI("/file"), GetStatusContext.defaults());
            Assert.assertEquals((Object)status, (Object)new URIStatus(info.setMountId(status.getMountId())));
        }
    }

    private FsMasterResource createFsMasterFromJournal() throws Exception {
        return MasterTestUtils.createLeaderFileSystemMasterFromJournal();
    }

    private void deleteFsMasterJournalLogs() throws Exception {
        String journalFolder = this.mLocalAlluxioCluster.getLocalAlluxioMaster().getJournalFolder();
        UfsJournal journal = new UfsJournal(new URI(PathUtils.concatPath((Object)journalFolder, (Object)"FileSystemMaster")), (Master)new NoopMaster(), 0L, Collections::emptySet);
        if (UfsJournalSnapshot.getCurrentLog((UfsJournal)journal) != null) {
            UnderFileSystem.Factory.create((String)journalFolder, (AlluxioConfiguration)Configuration.global()).deleteFile(UfsJournalSnapshot.getCurrentLog((UfsJournal)journal).getLocation().toString());
        }
    }

    public static class FakeUserGroupsMapping
    implements GroupMappingService {
        public static final String FULL_CLASS_NAME = "alluxio.server.ft.journal.ufs.UfsJournalIntegrationTest$FakeUserGroupsMapping";
        private HashMap<String, String> mUserGroups = new HashMap();

        public FakeUserGroupsMapping() {
            this.mUserGroups.put("alluxio", "supergroup");
            this.mUserGroups.put("user1", "group1");
            this.mUserGroups.put("others", "anygroup");
        }

        public List<String> getGroups(String user) throws IOException {
            if (this.mUserGroups.containsKey(user)) {
                return Lists.newArrayList((Object[])this.mUserGroups.get(user).split(","));
            }
            return Lists.newArrayList((Object[])this.mUserGroups.get("others").split(","));
        }
    }
}

