/*
 * Decompiled with CFR 0.152.
 */
package alluxio.server.health;

import alluxio.HealthCheckClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.master.LocalAlluxioCluster;
import alluxio.proxy.ProxyHealthCheckClient;
import alluxio.retry.CountingRetry;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.util.network.NetworkAddressUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class ProxyHealthCheckClientIntegrationTest
extends BaseIntegrationTest {
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setIncludeProxy(true).build();
    private LocalAlluxioCluster mLocalAlluxioCluster = null;
    private HealthCheckClient mHealthCheckClient;

    @Before
    public final void before() throws Exception {
        this.mLocalAlluxioCluster = this.mLocalAlluxioClusterResource.get();
        this.mHealthCheckClient = new ProxyHealthCheckClient(NetworkAddressUtils.getBindAddress((NetworkAddressUtils.ServiceAttributeProvider)NetworkAddressUtils.ServiceType.PROXY_WEB, (AlluxioConfiguration)Configuration.global()), () -> new CountingRetry(1));
    }

    @Test
    public void isServing() {
        Assert.assertTrue((boolean)this.mHealthCheckClient.isServing());
    }

    @Test
    public void isServingStopFS() throws Exception {
        this.mLocalAlluxioCluster.stopFS();
        Assert.assertFalse((boolean)this.mHealthCheckClient.isServing());
    }
}

