/*
 * Decompiled with CFR 0.152.
 */
package alluxio.server.health;

import alluxio.HealthCheckClient;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.master.LocalAlluxioCluster;
import alluxio.retry.CountingRetry;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.worker.WorkerHealthCheckClient;
import java.net.InetSocketAddress;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class WorkerHealthCheckClientIntegrationTest
extends BaseIntegrationTest {
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.WORKER_RPC_PORT, 0).build();
    private LocalAlluxioCluster mLocalAlluxioCluster = null;
    private HealthCheckClient mHealthCheckClient;

    @Before
    public final void before() throws Exception {
        this.mLocalAlluxioCluster = this.mLocalAlluxioClusterResource.get();
        InetSocketAddress address = new InetSocketAddress(this.mLocalAlluxioCluster.getWorkerAddress().getHost(), this.mLocalAlluxioCluster.getWorkerAddress().getRpcPort());
        this.mHealthCheckClient = new WorkerHealthCheckClient(address, () -> new CountingRetry(1), Configuration.global());
    }

    @Test
    public void isServing() {
        Assert.assertTrue((boolean)this.mHealthCheckClient.isServing());
    }

    @Test
    public void isServingStopFS() throws Exception {
        this.mLocalAlluxioCluster.stopFS();
        Assert.assertFalse((boolean)this.mHealthCheckClient.isServing());
    }
}

