/*
 * Decompiled with CFR 0.152.
 */
package alluxio.server.worker;

import alluxio.ConfigurationRule;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.master.block.BlockMaster;
import alluxio.master.block.DefaultBlockMaster;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.util.CommonUtils;
import alluxio.util.WaitForOptions;
import java.util.Map;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.testcontainers.shaded.com.google.common.collect.ImmutableMap;

public class WorkerMetadataSyncIntegrationTest {
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setStartCluster(false).build();
    @Rule
    public ConfigurationRule mConfigurationRule = new ConfigurationRule((Map)new ImmutableMap.Builder().put((Object)PropertyKey.WORKER_BLOCK_HEARTBEAT_INTERVAL_MS, (Object)100).build(), Configuration.modifiableGlobal());

    @Test
    @Ignore
    public void reRegisterWorker() throws Exception {
        this.mLocalAlluxioClusterResource.start();
        DefaultBlockMaster master = (DefaultBlockMaster)this.mLocalAlluxioClusterResource.get().getLocalAlluxioMaster().getMasterProcess().getMaster(BlockMaster.class);
        master.forgetAllWorkers();
        Assert.assertEquals((long)0L, (long)master.getWorkerCount());
        CommonUtils.waitFor((String)"Wait for Worker Registration", () -> master.getWorkerCount() == 1, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(2000L));
    }

    @Test
    @Ignore
    public void acquireLeaseNoStreaming() throws Exception {
        this.mConfigurationRule.set(PropertyKey.WORKER_REGISTER_LEASE_ENABLED, (Object)true);
        this.mConfigurationRule.set(PropertyKey.WORKER_REGISTER_STREAM_ENABLED, (Object)false);
        this.mLocalAlluxioClusterResource.start();
        DefaultBlockMaster master = (DefaultBlockMaster)this.mLocalAlluxioClusterResource.get().getLocalAlluxioMaster().getMasterProcess().getMaster(BlockMaster.class);
        Assert.assertEquals((long)1L, (long)master.getWorkerCount());
    }
}

