/*
 * Decompiled with CFR 0.152.
 */
package alluxio.testutils;

import alluxio.AlluxioURI;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.grpc.CreateFilePOptions;
import alluxio.util.CommonUtils;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlluxioOperationThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(AlluxioOperationThread.class);
    private final FileSystem mFs;
    private List<Op> mOps = Arrays.asList(Op.values());
    private long mIntervalMs = 10L;
    private final AtomicReference<Throwable> mLatestFailure = new AtomicReference();
    private volatile boolean mStarted = false;
    private int mSuccesses = 0;

    public AlluxioOperationThread(FileSystem fs) {
        this.mFs = fs;
    }

    public AlluxioOperationThread withOps(List<Op> ops) {
        Preconditions.checkState((ops.size() > 0 ? 1 : 0) != 0);
        Preconditions.checkState((!this.mStarted ? 1 : 0) != 0);
        this.mOps = ops;
        return this;
    }

    public AlluxioOperationThread withDelay(long intervalMs) {
        Preconditions.checkState((!this.mStarted ? 1 : 0) != 0);
        this.mIntervalMs = intervalMs;
        return this;
    }

    public Throwable getLatestFailure() {
        return this.mLatestFailure.get();
    }

    public int successes() {
        return this.mSuccesses;
    }

    @Override
    public void run() {
        this.mStarted = true;
        while (!Thread.interrupted()) {
            Op op = this.mOps.get(ThreadLocalRandom.current().nextInt(this.mOps.size()));
            try {
                switch (op) {
                    case CREATE_FILE: {
                        this.createFile();
                        break;
                    }
                    case CREATE_AND_DELETE: {
                        this.mFs.delete(this.createFile());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown op: " + op.toString());
                    }
                }
                ++this.mSuccesses;
            }
            catch (Throwable t) {
                LOG.error("Failure during operation {}", (Object)op, (Object)t);
                this.mLatestFailure.set(t);
            }
            CommonUtils.sleepMs((long)this.mIntervalMs);
        }
    }

    private AlluxioURI createFile() {
        String file = "/file" + ThreadLocalRandom.current().nextLong();
        FileSystemTestUtils.createByteFile((FileSystem)this.mFs, (String)file, (int)100, (CreateFilePOptions)CreateFilePOptions.getDefaultInstance());
        return new AlluxioURI(file);
    }

    static enum Op {
        CREATE_FILE,
        CREATE_AND_DELETE;

    }
}

