/*
 * Decompiled with CFR 0.152.
 */
package alluxio.testutils;

import alluxio.util.io.PathUtils;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.LogManager;
import org.apache.log4j.PatternLayout;
import org.junit.AssumptionViolatedException;
import org.junit.Rule;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.rules.Timeout;
import org.junit.runner.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseIntegrationTest {
    private static final Logger LOG = LoggerFactory.getLogger(BaseIntegrationTest.class);
    @Rule
    public RuleChain mRules = RuleChain.outerRule((TestRule)this.logHandler()).around((TestRule)Timeout.millis((long)600000L));

    private TestWatcher logHandler() {
        return new TestWatcher(){
            private String mLogPath;
            private Appender mAppender;

            protected void starting(Description description) {
                try {
                    this.mLogPath = this.logPath(description);
                    new FileWriter(this.mLogPath).close();
                    this.mAppender = new FileAppender((Layout)new PatternLayout("%d{ISO8601} [%t] %-5p %c{2} (%F:%M) - %m%n"), this.mLogPath);
                    LogManager.getRootLogger().addAppender(this.mAppender);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            protected void succeeded(Description description) {
                try {
                    Files.delete(Paths.get(this.mLogPath, new String[0]));
                }
                catch (Throwable t) {
                    LOG.error("Failed to delete success log file {}", (Object)this.mLogPath);
                }
            }

            protected void skipped(AssumptionViolatedException e, Description description) {
                this.succeeded(description);
            }

            protected void finished(Description description) {
                LogManager.getRootLogger().removeAppender(this.mAppender);
            }

            private String logPath(Description description) {
                String basename = String.format("tests-%s-%s.log", description.getClassName(), description.getMethodName());
                return PathUtils.concatPath((Object)"./target/logs", (Object)basename);
            }
        };
    }
}

