/*
 * Decompiled with CFR 0.152.
 */
package alluxio.testutils.master;

import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.master.AlwaysStandbyPrimarySelector;
import alluxio.master.BackupManager;
import alluxio.master.CoreMasterContext;
import alluxio.master.MasterRegistry;
import alluxio.master.MasterUtils;
import alluxio.master.PrimarySelector;
import alluxio.master.SafeModeManager;
import alluxio.master.TestSafeModeManager;
import alluxio.master.block.BlockMasterFactory;
import alluxio.master.file.FileSystemMasterFactory;
import alluxio.master.journal.JournalSystem;
import alluxio.master.journal.JournalTestUtils;
import alluxio.master.metrics.MetricsMasterFactory;
import alluxio.security.user.ServerUserState;
import alluxio.security.user.UserState;
import alluxio.testutils.master.FsMasterResource;
import alluxio.underfs.MasterUfsManager;
import com.google.common.io.Files;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.mockito.Mockito;

public class MasterTestUtils {
    public static FsMasterResource createLeaderFileSystemMasterFromJournal() throws Exception {
        return MasterTestUtils.createFileSystemMasterFromJournal(true, null);
    }

    public static FsMasterResource createLeaderFileSystemMasterFromJournal(UserState userState) throws Exception {
        return MasterTestUtils.createFileSystemMasterFromJournal(true, userState);
    }

    public static FsMasterResource createStandbyFileSystemMasterFromJournal() throws Exception {
        return MasterTestUtils.createFileSystemMasterFromJournal(false, null);
    }

    public static FsMasterResource createLeaderFileSystemMasterFromJournalCopy() throws Exception {
        String masterJournal = Configuration.getString((PropertyKey)PropertyKey.MASTER_JOURNAL_FOLDER);
        File tmpDirFile = Files.createTempDir();
        tmpDirFile.deleteOnExit();
        String tempDir = tmpDirFile.getAbsolutePath();
        FileUtils.copyDirectory((File)new File(masterJournal), (File)new File(tempDir));
        return MasterTestUtils.createFileSystemMasterFromJournal(true, null, tempDir);
    }

    private static FsMasterResource createFileSystemMasterFromJournal(boolean isLeader, UserState userState) throws Exception {
        String masterJournal = Configuration.getString((PropertyKey)PropertyKey.MASTER_JOURNAL_FOLDER);
        return MasterTestUtils.createFileSystemMasterFromJournal(isLeader, userState, masterJournal);
    }

    private static FsMasterResource createFileSystemMasterFromJournal(boolean isLeader, UserState userState, String journalFolder) throws Exception {
        String masterJournal = journalFolder;
        MasterRegistry registry = new MasterRegistry();
        TestSafeModeManager safeModeManager = new TestSafeModeManager();
        long startTimeMs = System.currentTimeMillis();
        int port = Configuration.getInt((PropertyKey)PropertyKey.MASTER_RPC_PORT);
        String baseDir = Configuration.getString((PropertyKey)PropertyKey.MASTER_METASTORE_DIR);
        JournalSystem journalSystem = JournalTestUtils.createJournalSystem((String)masterJournal);
        if (userState == null) {
            userState = ServerUserState.global();
        }
        CoreMasterContext masterContext = CoreMasterContext.newBuilder().setJournalSystem(journalSystem).setPrimarySelector((PrimarySelector)new AlwaysStandbyPrimarySelector()).setSafeModeManager((SafeModeManager)safeModeManager).setBackupManager((BackupManager)Mockito.mock(BackupManager.class)).setBlockStoreFactory(MasterUtils.getBlockStoreFactory((String)baseDir)).setInodeStoreFactory(MasterUtils.getInodeStoreFactory((String)baseDir)).setStartTimeMs(startTimeMs).setUserState(userState).setPort(port).setUfsManager(new MasterUfsManager()).build();
        new MetricsMasterFactory().create(registry, masterContext);
        new BlockMasterFactory().create(registry, masterContext);
        new FileSystemMasterFactory().create(registry, masterContext);
        journalSystem.start();
        if (isLeader) {
            journalSystem.gainPrimacy();
        }
        registry.start((Object)isLeader);
        return new FsMasterResource(registry, journalSystem);
    }
}

