/*
 * Decompiled with CFR 0.152.
 */
package alluxio.testutils.underfs.delegating;

import alluxio.AlluxioURI;
import alluxio.PositionReader;
import alluxio.collections.Pair;
import alluxio.conf.AlluxioConfiguration;
import alluxio.file.options.DescendantType;
import alluxio.security.authorization.AccessControlList;
import alluxio.security.authorization.AclEntry;
import alluxio.security.authorization.DefaultAccessControlList;
import alluxio.underfs.Fingerprint;
import alluxio.underfs.UfsDirectoryStatus;
import alluxio.underfs.UfsFileStatus;
import alluxio.underfs.UfsLoadResult;
import alluxio.underfs.UfsMode;
import alluxio.underfs.UfsStatus;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.options.CreateOptions;
import alluxio.underfs.options.DeleteOptions;
import alluxio.underfs.options.FileLocationOptions;
import alluxio.underfs.options.GetStatusOptions;
import alluxio.underfs.options.ListOptions;
import alluxio.underfs.options.MkdirsOptions;
import alluxio.underfs.options.OpenOptions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class DelegatingUnderFileSystem
implements UnderFileSystem {
    protected final UnderFileSystem mUfs;

    public DelegatingUnderFileSystem(UnderFileSystem ufs) {
        this.mUfs = ufs;
    }

    public void cleanup() throws IOException {
        this.mUfs.cleanup();
    }

    public void close() throws IOException {
        this.mUfs.close();
    }

    public void connectFromMaster(String hostname) throws IOException {
        this.mUfs.connectFromMaster(hostname);
    }

    public void connectFromWorker(String hostname) throws IOException {
        this.mUfs.connectFromWorker(hostname);
    }

    public OutputStream create(String path) throws IOException {
        return this.mUfs.create(path);
    }

    public OutputStream create(String path, CreateOptions options) throws IOException {
        return this.mUfs.create(path, options);
    }

    public OutputStream createNonexistingFile(String path, CreateOptions options) throws IOException {
        return this.mUfs.createNonexistingFile(path, options);
    }

    public OutputStream createNonexistingFile(String path) throws IOException {
        return this.mUfs.createNonexistingFile(path);
    }

    public boolean deleteDirectory(String path) throws IOException {
        return this.mUfs.deleteDirectory(path);
    }

    public boolean deleteDirectory(String path, DeleteOptions options) throws IOException {
        return this.mUfs.deleteDirectory(path, options);
    }

    public boolean deleteExistingDirectory(String path) throws IOException {
        return this.mUfs.deleteExistingDirectory(path);
    }

    public boolean deleteExistingDirectory(String path, DeleteOptions options) throws IOException {
        return this.mUfs.deleteExistingDirectory(path, options);
    }

    public boolean deleteFile(String path) throws IOException {
        return this.mUfs.deleteFile(path);
    }

    public boolean deleteExistingFile(String path) throws IOException {
        return this.mUfs.deleteExistingFile(path);
    }

    public boolean exists(String path) throws IOException {
        return this.mUfs.exists(path);
    }

    public Pair<AccessControlList, DefaultAccessControlList> getAclPair(String path) throws IOException {
        return this.mUfs.getAclPair(path);
    }

    public long getBlockSizeByte(String path) throws IOException {
        return this.mUfs.getBlockSizeByte(path);
    }

    public AlluxioConfiguration getConfiguration() throws IOException {
        return this.mUfs.getConfiguration();
    }

    public UfsDirectoryStatus getDirectoryStatus(String path) throws IOException {
        return this.mUfs.getDirectoryStatus(path);
    }

    public UfsDirectoryStatus getExistingDirectoryStatus(String path) throws IOException {
        return this.mUfs.getExistingDirectoryStatus(path);
    }

    public List<String> getFileLocations(String path) throws IOException {
        return this.mUfs.getFileLocations(path);
    }

    public List<String> getFileLocations(String path, FileLocationOptions options) throws IOException {
        return this.mUfs.getFileLocations(path, options);
    }

    public UfsFileStatus getFileStatus(String path, GetStatusOptions options) throws IOException {
        return this.mUfs.getFileStatus(path, options);
    }

    public UfsFileStatus getExistingFileStatus(String path) throws IOException {
        return this.mUfs.getExistingFileStatus(path);
    }

    public String getFingerprint(String path) {
        return this.mUfs.getFingerprint(path);
    }

    public Fingerprint getParsedFingerprint(String path) {
        return this.mUfs.getParsedFingerprint(path);
    }

    public Fingerprint getParsedFingerprint(String path, @Nullable String contentHash) {
        return this.mUfs.getParsedFingerprint(path, contentHash);
    }

    public UfsMode getOperationMode(Map<String, UfsMode> physicalUfsState) {
        return this.mUfs.getOperationMode(physicalUfsState);
    }

    public List<String> getPhysicalStores() {
        return this.mUfs.getPhysicalStores();
    }

    public long getSpace(String path, UnderFileSystem.SpaceType type) throws IOException {
        return this.mUfs.getSpace(path, type);
    }

    public UfsStatus getStatus(String path, GetStatusOptions options) throws IOException {
        return this.mUfs.getStatus(path, options);
    }

    public UfsStatus getExistingStatus(String path) throws IOException {
        return this.mUfs.getExistingStatus(path);
    }

    public String getUnderFSType() {
        return this.mUfs.getUnderFSType();
    }

    public boolean isDirectory(String path) throws IOException {
        return this.mUfs.isDirectory(path);
    }

    public boolean isExistingDirectory(String path) throws IOException {
        return this.mUfs.isExistingDirectory(path);
    }

    public boolean isFile(String path) throws IOException {
        return this.mUfs.isFile(path);
    }

    public boolean isObjectStorage() {
        return this.mUfs.isObjectStorage();
    }

    public boolean isSeekable() {
        return this.mUfs.isSeekable();
    }

    public UfsStatus[] listStatus(String path) throws IOException {
        return this.mUfs.listStatus(path);
    }

    public UfsStatus[] listStatus(String path, ListOptions options) throws IOException {
        return this.mUfs.listStatus(path, options);
    }

    @Nullable
    public Iterator<UfsStatus> listStatusIterable(String path, ListOptions options, String startAfter, int batchSize) throws IOException {
        return this.mUfs.listStatusIterable(path, options, startAfter, batchSize);
    }

    public boolean mkdirs(String path) throws IOException {
        return this.mUfs.mkdirs(path);
    }

    public boolean mkdirs(String path, MkdirsOptions options) throws IOException {
        return this.mUfs.mkdirs(path, options);
    }

    public InputStream open(String path) throws IOException {
        return this.mUfs.open(path);
    }

    public InputStream open(String path, OpenOptions options) throws IOException {
        return this.mUfs.open(path, options);
    }

    public InputStream openExistingFile(String path, OpenOptions options) throws IOException {
        return this.mUfs.openExistingFile(path, options);
    }

    public InputStream openExistingFile(String path) throws IOException {
        return this.mUfs.openExistingFile(path);
    }

    public PositionReader openPositionRead(String path, long fileLength) {
        return this.mUfs.openPositionRead(path, fileLength);
    }

    public boolean renameDirectory(String src, String dst) throws IOException {
        return this.mUfs.renameDirectory(src, dst);
    }

    public boolean renameRenamableDirectory(String src, String dst) throws IOException {
        return this.mUfs.renameRenamableDirectory(src, dst);
    }

    public boolean renameFile(String src, String dst) throws IOException {
        return this.mUfs.renameFile(src, dst);
    }

    public boolean renameRenamableFile(String src, String dst) throws IOException {
        return this.mUfs.renameRenamableFile(src, dst);
    }

    public AlluxioURI resolveUri(AlluxioURI ufsBaseUri, String alluxioPath) {
        return this.mUfs.resolveUri(ufsBaseUri, alluxioPath);
    }

    public void setAclEntries(String path, List<AclEntry> aclEntries) throws IOException {
        this.mUfs.setAclEntries(path, aclEntries);
    }

    public void setOwner(String path, String owner, String group) throws IOException {
        this.mUfs.setOwner(path, owner, group);
    }

    public void setMode(String path, short mode) throws IOException {
        this.mUfs.setMode(path, mode);
    }

    public boolean supportsFlush() throws IOException {
        return this.mUfs.supportsFlush();
    }

    public void performListingAsync(String path, @Nullable String continuationToken, @Nullable String startAfter, DescendantType descendantType, boolean checkStatus, Consumer<UfsLoadResult> onComplete, Consumer<Throwable> onError) {
        this.mUfs.performListingAsync(path, continuationToken, startAfter, descendantType, checkStatus, onComplete, onError);
    }
}

