/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.cephfs;

import alluxio.AlluxioURI;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.UnderFileSystemFactory;
import alluxio.underfs.cephfs.CephFSUnderFileSystem;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class CephFSUnderFileSystemFactory
implements UnderFileSystemFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CephFSUnderFileSystemFactory.class);

    public UnderFileSystem create(String path, UnderFileSystemConfiguration conf) {
        Preconditions.checkNotNull((Object)path, (Object)"path");
        try {
            return CephFSUnderFileSystem.createInstance(new AlluxioURI(path), conf);
        }
        catch (IOException e) {
            LOG.error("Failed to create CephFSUnderFileSystem.", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    public boolean supportsPath(String path) {
        return path != null && path.startsWith("cephfs://");
    }
}

