/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.cephfs;

import com.ceph.fs.CephMount;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class CephOutputStream
extends OutputStream {
    private CephMount mMount;
    private int mFileHandle;
    private AtomicBoolean mClosed = new AtomicBoolean(false);

    public CephOutputStream(CephMount mount, int fh) {
        this.mMount = mount;
        this.mFileHandle = fh;
    }

    @Override
    public void write(int b) throws IOException {
        byte[] buf = new byte[]{(byte)b};
        this.write(buf, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new IOException("ceph.write: data buffer is null pointer");
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (off == 0) {
            int ret = (int)this.mMount.write(this.mFileHandle, b, (long)len, -1L);
            if (ret < 0) {
                throw new IOException("ceph.write: ret = " + ret);
            }
        } else {
            byte[] sub = new byte[len];
            System.arraycopy(b, off, sub, 0, len);
            int ret = (int)this.mMount.write(this.mFileHandle, sub, (long)len, -1L);
            if (ret < 0) {
                throw new IOException("ceph.write: ret = " + ret);
            }
        }
    }

    @Override
    public void flush() throws IOException {
        this.mMount.fsync(this.mFileHandle, false);
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed.getAndSet(true)) {
            return;
        }
        this.flush();
        this.mMount.close(this.mFileHandle);
    }
}

