/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.cephfs;

import com.ceph.fs.CephMount;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class CephInputStream
extends InputStream {
    private CephMount mMount;
    private final int mFileHandle;
    private final long mFileLength;
    private long mCephPos = 0L;
    private byte[] mBuf;
    private int mBufPos = 0;
    private int mBufValid = 0;
    private byte[] mOneByteBuf = new byte[1];
    private final AtomicBoolean mClosed = new AtomicBoolean(false);

    public CephInputStream(CephMount mount, int fh, long flength) {
        this.mFileLength = flength;
        this.mFileHandle = fh;
        this.mMount = mount;
        this.mBuf = new byte[0x200000];
    }

    public synchronized long getPos() throws IOException {
        return this.mCephPos - (long)this.mBufValid + (long)this.mBufPos;
    }

    @Override
    public synchronized int available() throws IOException {
        if (this.mClosed.get()) {
            throw new IOException("file is closed");
        }
        return (int)(this.mFileLength - this.getPos());
    }

    public synchronized void seek(long targetPos) throws IOException {
        if (targetPos > this.mFileLength) {
            throw new IOException(String.format("CephInputStream.seek: failed seek to position %d on fd %d : Cannot seek after EOF fileSize %d", targetPos, this.mFileHandle, this.mFileLength));
        }
        long oldPos = this.mCephPos;
        this.mCephPos = this.mMount.lseek(this.mFileHandle, targetPos, 1);
        if (this.mCephPos < 0L) {
            int ret = (int)this.mCephPos;
            this.mCephPos = oldPos;
            throw new IOException(String.format("ceph.lseek: failed ret = %d", ret));
        }
        this.mBufValid = 0;
        this.mBufPos = 0;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        long targetPos = this.getPos() + n;
        this.seek(targetPos);
        return n;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.getPos() >= this.mFileLength) {
            return -1;
        }
        if (-1 == this.read(this.mOneByteBuf, 0, 1)) {
            return -1;
        }
        if (this.mOneByteBuf[0] < 0) {
            return 256 + this.mOneByteBuf[0];
        }
        return this.mOneByteBuf[0];
    }

    @Override
    public synchronized int read(byte[] buf, int off, int len) throws IOException {
        int read;
        if (this.mClosed.get()) {
            throw new IOException(String.format("CephInputStream.read: cannot read %d bytes from fd %d : stream closed", len, this.mFileHandle));
        }
        if (buf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > buf.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.getPos() >= this.mFileLength) {
            return -1;
        }
        int totalRead = 0;
        int initialLen = len;
        do {
            read = Math.min(len, this.mBufValid - this.mBufPos);
            try {
                System.arraycopy(this.mBuf, this.mBufPos, buf, off, read);
            }
            catch (IndexOutOfBoundsException ie) {
                throw new IOException(String.format("CephInputStream.read: Indices out of bounds: read length is %d, buffer offset is %d, and buffer size is %d", len, off, buf.length));
            }
            catch (ArrayStoreException ae) {
                throw new IOException(String.format("CephInputStream.read: failed to do an arraycopy due to type mismatch...", new Object[0]));
            }
            catch (NullPointerException ne) {
                throw new IOException(String.format("CephInputStream.read: cannot read %d bytes from fd %d: mBuf is null", len, this.mFileHandle));
            }
            this.mBufPos += read;
            off += read;
            totalRead += read;
        } while ((len -= read) > 0 && this.fillBuffer());
        return totalRead;
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed.getAndSet(true)) {
            return;
        }
        this.mMount.close(this.mFileHandle);
    }

    private synchronized boolean fillBuffer() throws IOException {
        this.mBufValid = (int)this.mMount.read(this.mFileHandle, this.mBuf, (long)this.mBuf.length, -1L);
        this.mBufPos = 0;
        if (this.mBufValid < 0) {
            int err = this.mBufValid;
            this.mBufValid = 0;
            this.mMount.lseek(this.mFileHandle, this.mCephPos, 1);
            throw new IOException(String.format("Failed to fill read buffer! Error code: %d", err));
        }
        this.mCephPos += (long)this.mBufValid;
        return this.mBufValid != 0;
    }
}

