/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.cephfs;

import alluxio.AlluxioURI;
import alluxio.PositionReader;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.InvalidPathException;
import alluxio.exception.runtime.UnimplementedRuntimeException;
import alluxio.retry.CountingRetry;
import alluxio.underfs.AtomicFileOutputStream;
import alluxio.underfs.AtomicFileOutputStreamCallback;
import alluxio.underfs.ConsistentUnderFileSystem;
import alluxio.underfs.UfsDirectoryStatus;
import alluxio.underfs.UfsFileStatus;
import alluxio.underfs.UfsStatus;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.cephfs.CephInputStream;
import alluxio.underfs.cephfs.CephOutputStream;
import alluxio.underfs.cephfs.CephSeekableInputStream;
import alluxio.underfs.options.CreateOptions;
import alluxio.underfs.options.DeleteOptions;
import alluxio.underfs.options.FileLocationOptions;
import alluxio.underfs.options.GetStatusOptions;
import alluxio.underfs.options.MkdirsOptions;
import alluxio.underfs.options.OpenOptions;
import alluxio.util.UnderFileSystemUtils;
import alluxio.util.io.PathUtils;
import com.ceph.fs.CephFileAlreadyExistsException;
import com.ceph.fs.CephMount;
import com.ceph.fs.CephStat;
import com.ceph.fs.CephStatVFS;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CephFSUnderFileSystem
extends ConsistentUnderFileSystem
implements AtomicFileOutputStreamCallback {
    private static final Logger LOG = LoggerFactory.getLogger(CephFSUnderFileSystem.class);
    private static final int MAX_TRY = 5;
    private CephMount mMount;
    private static final String CEPH_AUTH_KEY = "key";
    private static final String CEPH_AUTH_KEYFILE = "keyfile";
    private static final String CEPH_AUTH_KEYRING = "keyring";
    private static final String CEPH_MON_HOST = "mon_host";
    private static final String CEPH_CLIENT_MDS_NAMESPACE = "client_mds_namespace";
    private static final String CEPH_CLIENT_MOUNT_UID = "client_mount_uid";
    private static final String CEPH_CLIENT_MOUNT_GID = "client_mount_gid";

    public static CephFSUnderFileSystem createInstance(AlluxioURI ufsUri, UnderFileSystemConfiguration conf) throws IOException {
        String monHost;
        String key;
        LOG.info("CephFS URI: {}", (Object)ufsUri.toString());
        String userId = null;
        if (conf.isSetByUser(PropertyKey.UNDERFS_CEPHFS_AUTH_ID)) {
            userId = conf.getString(PropertyKey.UNDERFS_CEPHFS_AUTH_ID);
            LOG.info("CephFS config: {} = {}", (Object)PropertyKey.UNDERFS_CEPHFS_AUTH_ID, (Object)userId);
            if (userId != null && userId.isEmpty()) {
                userId = null;
            }
        }
        CephMount mount = new CephMount(userId);
        if (conf.isSetByUser(PropertyKey.UNDERFS_CEPHFS_CONF_FILE)) {
            File file;
            String confFile = conf.getString(PropertyKey.UNDERFS_CEPHFS_CONF_FILE);
            LOG.info("CephFS config: {} = {}", (Object)PropertyKey.UNDERFS_CEPHFS_CONF_FILE, (Object)confFile);
            if (confFile != null && !confFile.isEmpty() && (file = new File(confFile)).exists() && file.isFile()) {
                mount.conf_read_file(confFile);
            }
        }
        if (conf.isSetByUser(PropertyKey.UNDERFS_CEPHFS_CONF_OPTS)) {
            String confOpts = conf.getString(PropertyKey.UNDERFS_CEPHFS_CONF_OPTS);
            LOG.info("CephFS config: {} = {}", (Object)PropertyKey.UNDERFS_CEPHFS_CONF_OPTS, (Object)confOpts);
            if (confOpts != null && !confOpts.isEmpty()) {
                String[] options;
                for (String option : options = confOpts.split(";")) {
                    String[] keyval = option.split("=");
                    if (keyval.length != 2) {
                        throw new IllegalArgumentException("Invalid Ceph option: " + option);
                    }
                    String k = keyval[0];
                    String v = keyval[1];
                    try {
                        mount.conf_set(k, v);
                    }
                    catch (Exception e) {
                        throw new IOException("Error setting Ceph option " + k + " = " + v);
                    }
                }
            }
        }
        if (conf.isSetByUser(PropertyKey.UNDERFS_CEPHFS_AUTH_KEY) && (key = conf.getString(PropertyKey.UNDERFS_CEPHFS_AUTH_KEY)) != null && !key.isEmpty()) {
            mount.conf_set(CEPH_AUTH_KEY, key);
        }
        if (conf.isSetByUser(PropertyKey.UNDERFS_CEPHFS_AUTH_KEYFILE)) {
            String keyfile = conf.getString(PropertyKey.UNDERFS_CEPHFS_AUTH_KEYFILE);
            LOG.info("CephFS config: {} = {}", (Object)PropertyKey.UNDERFS_CEPHFS_AUTH_KEYFILE, (Object)keyfile);
            if (keyfile != null && !keyfile.isEmpty()) {
                mount.conf_set(CEPH_AUTH_KEYFILE, keyfile);
            }
        }
        if (conf.isSetByUser(PropertyKey.UNDERFS_CEPHFS_AUTH_KEYRING)) {
            String keyring = conf.getString(PropertyKey.UNDERFS_CEPHFS_AUTH_KEYRING);
            LOG.info("CephFS config: {} = {}", (Object)PropertyKey.UNDERFS_CEPHFS_AUTH_KEYRING, (Object)keyring);
            if (keyring != null && !keyring.isEmpty()) {
                mount.conf_set(CEPH_AUTH_KEYRING, keyring);
            }
        }
        if (((monHost = ufsUri.getAuthority().toString()) == null || monHost.isEmpty()) && conf.isSetByUser(PropertyKey.UNDERFS_CEPHFS_MON_HOST)) {
            monHost = conf.getString(PropertyKey.UNDERFS_CEPHFS_MON_HOST);
            LOG.info("CephFS config: {} = {}", (Object)PropertyKey.UNDERFS_CEPHFS_MON_HOST, (Object)monHost);
        }
        if (monHost != null && !monHost.isEmpty()) {
            mount.conf_set(CEPH_MON_HOST, monHost);
        }
        if (conf.isSetByUser(PropertyKey.UNDERFS_CEPHFS_MDS_NAMESPACE)) {
            String namespace = conf.getString(PropertyKey.UNDERFS_CEPHFS_MDS_NAMESPACE);
            LOG.info("CephFS config: {} = {}", (Object)PropertyKey.UNDERFS_CEPHFS_MDS_NAMESPACE, (Object)namespace);
            if (namespace != null && !namespace.isEmpty()) {
                mount.conf_set(CEPH_CLIENT_MDS_NAMESPACE, namespace);
            }
        }
        if (conf.isSetByUser(PropertyKey.UNDERFS_CEPHFS_MOUNT_UID)) {
            String uid = conf.getString(PropertyKey.UNDERFS_CEPHFS_MOUNT_UID);
            LOG.info("CephFS config: {} = {}", (Object)PropertyKey.UNDERFS_CEPHFS_MOUNT_UID, (Object)uid);
            if (uid != null && !uid.isEmpty()) {
                mount.conf_set(CEPH_CLIENT_MOUNT_UID, uid);
            }
        }
        if (conf.isSetByUser(PropertyKey.UNDERFS_CEPHFS_MOUNT_GID)) {
            String gid = conf.getString(PropertyKey.UNDERFS_CEPHFS_MOUNT_GID);
            LOG.info("CephFS config: {} = {}", (Object)PropertyKey.UNDERFS_CEPHFS_MOUNT_GID, (Object)gid);
            if (gid != null && !gid.isEmpty()) {
                mount.conf_set(CEPH_CLIENT_MOUNT_GID, gid);
            }
        }
        String root = null;
        if (conf.isSetByUser(PropertyKey.UNDERFS_CEPHFS_MOUNT_POINT)) {
            root = conf.getString(PropertyKey.UNDERFS_CEPHFS_MOUNT_POINT);
            LOG.info("CephFS config: {} = {}", (Object)PropertyKey.UNDERFS_CEPHFS_MOUNT_POINT, (Object)root);
            if (root != null && root.isEmpty()) {
                root = null;
            }
        }
        mount.mount(root);
        if (conf.isSetByUser(PropertyKey.UNDERFS_CEPHFS_LOCALIZE_READS)) {
            boolean localizeReads = conf.getBoolean(PropertyKey.UNDERFS_CEPHFS_LOCALIZE_READS);
            LOG.info("CephFS config: {} = {}", (Object)PropertyKey.UNDERFS_CEPHFS_LOCALIZE_READS, (Object)localizeReads);
            mount.localize_reads(localizeReads);
        }
        return new CephFSUnderFileSystem(ufsUri, mount, conf);
    }

    public CephFSUnderFileSystem(AlluxioURI ufsUri, CephMount mount, UnderFileSystemConfiguration conf) {
        super(ufsUri, conf);
        this.mMount = mount;
    }

    public String getUnderFSType() {
        return "cephfs";
    }

    public void close() throws IOException {
        if (null != this.mMount) {
            this.mMount.unmount();
        }
        this.mMount = null;
    }

    public OutputStream create(String path, CreateOptions options) throws IOException {
        if (!options.isEnsureAtomic()) {
            return this.createDirect(path, options);
        }
        return new AtomicFileOutputStream(path, (AtomicFileOutputStreamCallback)this, options);
    }

    public void cleanup() throws IOException {
    }

    public OutputStream createDirect(String path, CreateOptions options) throws IOException {
        String parentPath;
        path = this.stripPath(path);
        try {
            parentPath = PathUtils.getParent((String)path);
        }
        catch (InvalidPathException e) {
            throw new IOException("Invalid path " + path, e);
        }
        IOException te = null;
        CountingRetry retryPolicy = new CountingRetry(5);
        while (retryPolicy.attempt()) {
            try {
                if (options.getCreateParent() && this.mkdirs(parentPath, MkdirsOptions.defaults((AlluxioConfiguration)this.mUfsConf)) && !this.isDirectory(parentPath)) {
                    throw new IOException(ExceptionMessage.PARENT_CREATION_FAILED.getMessage(new Object[]{path}));
                }
                int flags = 88;
                short mode = options.getMode().toShort();
                int fd = this.openInternal(path, flags, mode);
                return new CephOutputStream(this.mMount, fd);
            }
            catch (IOException e) {
                LOG.warn("Retry count {} : {}", (Object)retryPolicy.getAttemptCount(), (Object)e.toString());
                te = e;
            }
        }
        throw te;
    }

    public boolean deleteDirectory(String path, DeleteOptions options) throws IOException {
        if (this.isDirectory(path = this.stripPath(path))) {
            IOException te = null;
            CountingRetry retryPolicy = new CountingRetry(5);
            while (retryPolicy.attempt()) {
                try {
                    return this.deleteInternal(path, options.isRecursive());
                }
                catch (IOException e) {
                    LOG.warn("Retry count {} : {}", (Object)retryPolicy.getAttemptCount(), (Object)e.toString());
                    te = e;
                }
            }
            throw te;
        }
        return false;
    }

    public boolean deleteFile(String path) throws IOException {
        if (this.isFile(path = this.stripPath(path))) {
            IOException te = null;
            CountingRetry retryPolicy = new CountingRetry(5);
            while (retryPolicy.attempt()) {
                try {
                    return this.deleteInternal(path, false);
                }
                catch (IOException e) {
                    LOG.warn("Retry count {} : {}", (Object)retryPolicy.getAttemptCount(), (Object)e.toString());
                    te = e;
                }
            }
            throw te;
        }
        return false;
    }

    public boolean exists(String path) throws IOException {
        path = this.stripPath(path);
        try {
            CephStat stat = new CephStat();
            this.lstat(path, stat);
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public long getBlockSizeByte(String path) throws IOException {
        path = this.stripPath(path);
        CephStat stat = new CephStat();
        this.lstat(path, stat);
        return stat.blksize;
    }

    public UfsDirectoryStatus getDirectoryStatus(String path) throws IOException {
        path = this.stripPath(path);
        CephStat stat = new CephStat();
        this.lstat(path, stat);
        return new UfsDirectoryStatus(path, "", "", (short)stat.mode);
    }

    public UfsStatus getStatus(String path, GetStatusOptions options) throws IOException {
        path = this.stripPath(path);
        CephStat stat = new CephStat();
        this.lstat(path, stat);
        if (stat.isFile()) {
            return this.getFileStatus(path);
        }
        if (stat.isDir()) {
            return this.getDirectoryStatus(path);
        }
        throw new IOException("Failed to getStatus: " + path);
    }

    public List<String> getFileLocations(String path) throws IOException {
        return null;
    }

    @Nullable
    public List<String> getFileLocations(String path, FileLocationOptions options) throws IOException {
        return null;
    }

    public UfsFileStatus getFileStatus(String path, GetStatusOptions options) throws IOException {
        path = this.stripPath(path);
        CephStat stat = new CephStat();
        this.lstat(path, stat);
        String contentHash = UnderFileSystemUtils.approximateContentHash((long)stat.size, (long)stat.m_time);
        return new UfsFileStatus(path, contentHash, stat.size, Long.valueOf(stat.m_time), "", "", (short)stat.mode);
    }

    public long getSpace(String path, UnderFileSystem.SpaceType type) throws IOException {
        path = this.stripPath(path);
        CephStatVFS stat = new CephStatVFS();
        this.statfs(path, stat);
        switch (type) {
            case SPACE_TOTAL: {
                return stat.bsize * stat.blocks;
            }
            case SPACE_USED: {
                return stat.bsize * (stat.blocks - stat.bavail);
            }
            case SPACE_FREE: {
                return stat.bsize * stat.bavail;
            }
        }
        throw new IOException("Unknown space type: " + type);
    }

    public boolean isDirectory(String path) throws IOException {
        path = this.stripPath(path);
        try {
            CephStat stat = new CephStat();
            this.lstat(path, stat);
            return stat.isDir();
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public boolean isFile(String path) throws IOException {
        path = this.stripPath(path);
        try {
            CephStat stat = new CephStat();
            this.lstat(path, stat);
            return stat.isFile();
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    @Nullable
    public UfsStatus[] listStatus(String path) throws IOException {
        String[] lst = this.listDirectory(path = this.stripPath(path));
        if (lst != null) {
            UfsStatus[] status = new UfsStatus[lst.length];
            for (int i = 0; i < status.length; ++i) {
                CephStat stat = new CephStat();
                this.lstat(PathUtils.concatPath((Object)path, (Object)lst[i]), stat);
                if (!stat.isDir()) {
                    String contentHash = UnderFileSystemUtils.approximateContentHash((long)stat.size, (long)stat.m_time);
                    status[i] = new UfsFileStatus(lst[i], contentHash, stat.size, Long.valueOf(stat.m_time), "", "", (short)stat.mode);
                    continue;
                }
                status[i] = new UfsDirectoryStatus(lst[i], "", "", (short)stat.mode);
            }
            return status;
        }
        return null;
    }

    public void connectFromMaster(String host) throws IOException {
    }

    public void connectFromWorker(String host) throws IOException {
    }

    public boolean mkdirs(String path, MkdirsOptions options) throws IOException {
        path = this.stripPath(path);
        IOException te = null;
        CountingRetry retryPolicy = new CountingRetry(5);
        while (retryPolicy.attempt()) {
            try {
                if (this.exists(path)) {
                    LOG.debug("Trying to create existing directory at {}", (Object)path);
                    return false;
                }
                String parent = this.getParentPath(path);
                if (!options.getCreateParent() && !this.isDirectory(parent)) {
                    return false;
                }
                Stack<String> dirsToMake = new Stack<String>();
                dirsToMake.push(path);
                while (!this.exists(parent)) {
                    dirsToMake.push(parent);
                    parent = this.getParentPath(parent);
                }
                while (!dirsToMake.empty()) {
                    String dirToMake = (String)dirsToMake.pop();
                    try {
                        this.mMount.mkdirs(dirToMake, (int)options.getMode().toShort());
                    }
                    catch (CephFileAlreadyExistsException cephFileAlreadyExistsException) {
                        // empty catch block
                    }
                    try {
                        this.setOwner(dirToMake, options.getOwner(), options.getGroup());
                    }
                    catch (IOException e) {
                        LOG.warn("Failed to update the ufs dir ownership, default values will be used. " + e);
                    }
                }
                return true;
            }
            catch (IOException e) {
                LOG.warn("{} try to make directory for {} : {}", new Object[]{retryPolicy.getAttemptCount(), path, e.toString()});
                te = e;
            }
        }
        throw te;
    }

    public InputStream open(String path, OpenOptions options) throws IOException {
        path = this.stripPath(path);
        IOException te = null;
        CountingRetry retryPolicy = new CountingRetry(5);
        while (retryPolicy.attempt()) {
            try {
                short mode = CreateOptions.defaults((AlluxioConfiguration)this.mUfsConf).getMode().toShort();
                int fd = this.openInternal(path, 1, mode);
                CephStat stat = new CephStat();
                this.mMount.fstat(fd, stat);
                CephInputStream inputStream = new CephInputStream(this.mMount, fd, stat.size);
                try {
                    inputStream.seek(options.getOffset());
                }
                catch (IOException e) {
                    inputStream.close();
                    throw e;
                }
                return new CephSeekableInputStream(inputStream);
            }
            catch (IOException e) {
                LOG.warn("{} try to open {} : {}", new Object[]{retryPolicy.getAttemptCount(), path, e.toString()});
                te = e;
            }
        }
        throw te;
    }

    public PositionReader openPositionRead(String path, long fileLength) {
        throw new UnimplementedRuntimeException("Position read is not implemented");
    }

    public boolean renameDirectory(String src, String dst) throws IOException {
        if (!this.isDirectory(src)) {
            LOG.warn("Unable to rename {} to {} because source does not exist or is a file", (Object)src, (Object)dst);
            return false;
        }
        return this.rename(src, dst);
    }

    public boolean renameFile(String src, String dst) throws IOException {
        if (!this.isFile(src)) {
            LOG.warn("Unable to rename {} to {} because source does not exist or is a directory", (Object)src, (Object)dst);
            return false;
        }
        return this.rename(src, dst);
    }

    public boolean renameRenamableDirectory(String src, String dst) throws IOException {
        return this.renameDirectory(src, dst);
    }

    public boolean renameRenamableFile(String src, String dst) throws IOException {
        return this.renameFile(src, dst);
    }

    public void setOwner(String path, String user, String group) throws IOException {
    }

    public void setMode(String path, short mode) throws IOException {
        path = this.stripPath(path);
        this.mMount.chmod(path, (int)mode);
    }

    public boolean supportsFlush() {
        return true;
    }

    private String stripPath(String path) {
        return new AlluxioURI(path).getPath();
    }

    private String getParentPath(String path) throws IOException {
        try {
            return PathUtils.getParent((String)path);
        }
        catch (InvalidPathException e) {
            throw new IOException(e);
        }
    }

    private String getFileName(String path) throws IOException {
        try {
            String parent = PathUtils.getParent((String)path);
            return PathUtils.subtractPaths((String)path, (String)parent);
        }
        catch (InvalidPathException e) {
            throw new IOException(e);
        }
    }

    private String[] listDirectory(String path) throws IOException {
        CephStat stat = new CephStat();
        try {
            this.mMount.lstat(path, stat);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        if (!stat.isDir()) {
            return null;
        }
        return this.mMount.listdir(path);
    }

    private int openInternal(String path, int flags, int mode) throws IOException {
        int fd = this.mMount.open(path, flags, mode);
        CephStat stat = new CephStat();
        this.mMount.fstat(fd, stat);
        if (stat.isDir()) {
            this.mMount.close(fd);
            throw new FileNotFoundException();
        }
        return fd;
    }

    private boolean deleteInternal(String path, boolean recursive) throws IOException {
        CephStat stat = new CephStat();
        try {
            this.lstat(path, stat);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        if (stat.isFile()) {
            this.mMount.unlink(path);
            return true;
        }
        String[] lst = this.listDirectory(path);
        if (lst == null) {
            return false;
        }
        if (!recursive && lst.length > 0) {
            throw new IOException("Directory " + path + " is not empty.");
        }
        for (String fname : lst) {
            String fullPath = PathUtils.concatPath((Object)path, (Object)fname);
            if (this.deleteInternal(fullPath, recursive)) continue;
            return false;
        }
        this.mMount.rmdir(path);
        return true;
    }

    private boolean rename(String src, String dst) throws IOException {
        src = this.stripPath(src);
        dst = this.stripPath(dst);
        IOException te = null;
        CountingRetry retryPolicy = new CountingRetry(5);
        while (retryPolicy.attempt()) {
            try {
                try {
                    CephStat stat = new CephStat();
                    this.lstat(dst, stat);
                    if (stat.isDir()) {
                        String fileName = this.getFileName(src);
                        this.mMount.rename(src, PathUtils.concatPath((Object)dst, (Object)fileName));
                        return true;
                    }
                    return false;
                }
                catch (FileNotFoundException stat) {
                    this.mMount.rename(src, dst);
                    return true;
                }
            }
            catch (IOException e) {
                LOG.warn("{} try to rename {} to {} : {}", new Object[]{retryPolicy.getAttemptCount(), src, dst, e.toString()});
                te = e;
            }
        }
        throw te;
    }

    private void lstat(String path, CephStat stat) throws IOException {
        this.mMount.lstat(path, stat);
    }

    private void statfs(String path, CephStatVFS stat) throws IOException {
        this.mMount.statfs(path, stat);
    }

    public boolean isSeekable() {
        return true;
    }
}

