/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.cos;

import alluxio.underfs.MultiRangeObjectInputStream;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.ObjectMetadata;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class COSInputStream
extends MultiRangeObjectInputStream {
    private final String mBucketName;
    private final String mKey;
    private final COSClient mCosClient;
    private final long mContentLength;

    COSInputStream(String bucketName, String key, COSClient client, long multiRangeChunkSize) throws IOException {
        this(bucketName, key, client, 0L, multiRangeChunkSize);
    }

    COSInputStream(String bucketName, String key, COSClient client, long position, long multiRangeChunkSize) throws IOException {
        super(multiRangeChunkSize);
        this.mBucketName = bucketName;
        this.mKey = key;
        this.mCosClient = client;
        this.mPos = position;
        ObjectMetadata meta = this.mCosClient.getObjectMetadata(this.mBucketName, key);
        this.mContentLength = meta == null ? 0L : meta.getContentLength();
    }

    protected InputStream createStream(long startPos, long endPos) throws IOException {
        GetObjectRequest req = new GetObjectRequest(this.mBucketName, this.mKey);
        req.setRange(startPos, endPos < this.mContentLength ? endPos - 1L : this.mContentLength - 1L);
        COSObject object = this.mCosClient.getObject(req);
        return new BufferedInputStream((InputStream)object.getObjectContent());
    }
}

