/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.cos;

import alluxio.retry.RetryPolicy;
import alluxio.underfs.MultiRangeObjectInputStream;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.ObjectMetadata;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class COSInputStream
extends MultiRangeObjectInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(COSInputStream.class);
    private final String mBucketName;
    private final String mKey;
    private final COSClient mCosClient;
    private final long mContentLength;
    private final RetryPolicy mRetryPolicy;

    COSInputStream(String bucketName, String key, COSClient client, RetryPolicy retryPolicy, long multiRangeChunkSize) throws IOException {
        this(bucketName, key, client, 0L, retryPolicy, multiRangeChunkSize);
    }

    COSInputStream(String bucketName, String key, COSClient client, long position, RetryPolicy retryPolicy, long multiRangeChunkSize) throws IOException {
        super(multiRangeChunkSize);
        this.mBucketName = bucketName;
        this.mKey = key;
        this.mCosClient = client;
        this.mPos = position;
        this.mRetryPolicy = retryPolicy;
        ObjectMetadata meta = this.mCosClient.getObjectMetadata(this.mBucketName, key);
        this.mContentLength = meta == null ? 0L : meta.getContentLength();
    }

    protected InputStream createStream(long startPos, long endPos) throws IOException {
        GetObjectRequest req = new GetObjectRequest(this.mBucketName, this.mKey);
        req.setRange(startPos, endPos < this.mContentLength ? endPos - 1L : this.mContentLength - 1L);
        CosServiceException lastException = null;
        String errorMessage = String.format("Failed to open key: %s bucket: %s", this.mKey, this.mBucketName);
        while (this.mRetryPolicy.attempt()) {
            try {
                COSObject object = this.mCosClient.getObject(req);
                return new BufferedInputStream((InputStream)object.getObjectContent());
            }
            catch (CosServiceException e) {
                errorMessage = String.format("Failed to open key: %s bucket: %s attempts: %d error: %s", this.mKey, this.mBucketName, this.mRetryPolicy.getAttemptCount(), e.getMessage());
                if (e.getStatusCode() != 404) {
                    throw new IOException(errorMessage, e);
                }
                lastException = e;
            }
        }
        throw new IOException(errorMessage, lastException);
    }
}

