/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.cos;

import alluxio.exception.runtime.AlluxioRuntimeException;
import alluxio.grpc.ErrorType;
import com.google.protobuf.Any;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import io.grpc.Status;

public class AlluxioCosException
extends AlluxioRuntimeException {
    private static final ErrorType ERROR_TYPE = ErrorType.External;

    public static AlluxioCosException from(CosClientException cause) {
        return AlluxioCosException.from(null, cause);
    }

    public static AlluxioCosException from(String errorMessage, CosClientException cause) {
        Status status = Status.UNKNOWN;
        String errorDescription = "ClientException:" + cause.getMessage();
        if (cause instanceof CosServiceException) {
            CosServiceException exception = (CosServiceException)cause;
            status = AlluxioCosException.httpStatusToGrpcStatus(exception.getStatusCode());
            errorDescription = exception.getErrorCode() + ":" + exception.getErrorMessage();
        }
        if (errorMessage == null) {
            errorMessage = errorDescription;
        }
        return new AlluxioCosException(status, errorMessage, (Throwable)cause, cause.isRetryable());
    }

    private AlluxioCosException(Status status, String message, Throwable cause, boolean isRetryAble) {
        super(status, message, cause, ERROR_TYPE, isRetryAble, new Any[0]);
    }

    private static Status httpStatusToGrpcStatus(int httpStatusCode) {
        if (httpStatusCode >= 100 && httpStatusCode < 200) {
            return Status.INTERNAL;
        }
        switch (httpStatusCode) {
            case 400: {
                return Status.INVALID_ARGUMENT;
            }
            case 401: {
                return Status.UNAUTHENTICATED;
            }
            case 403: {
                return Status.PERMISSION_DENIED;
            }
            case 404: {
                return Status.NOT_FOUND;
            }
            case 405: 
            case 501: {
                return Status.UNIMPLEMENTED;
            }
            case 409: {
                return Status.ABORTED;
            }
            case 411: 
            case 412: {
                return Status.FAILED_PRECONDITION;
            }
            case 416: {
                return Status.OUT_OF_RANGE;
            }
            case 500: {
                return Status.INTERNAL;
            }
            case 301: 
            case 304: 
            case 307: 
            case 502: 
            case 503: {
                return Status.UNAVAILABLE;
            }
            case 504: {
                return Status.DEADLINE_EXCEEDED;
            }
        }
        return Status.UNKNOWN;
    }
}

