/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.cos;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.underfs.ObjectMultipartUploadOutputStream;
import com.amazonaws.SdkClientException;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.qcloud.cos.COS;
import com.qcloud.cos.model.AbortMultipartUploadRequest;
import com.qcloud.cos.model.CompleteMultipartUploadRequest;
import com.qcloud.cos.model.InitiateMultipartUploadRequest;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PartETag;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.UploadPartRequest;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class COSMultipartUploadOutputStream
extends ObjectMultipartUploadOutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(COSMultipartUploadOutputStream.class);
    private final COS mClient;
    private final List<PartETag> mTags = Collections.synchronizedList(new ArrayList());
    protected volatile String mUploadId;
    private String mContentHash;

    public COSMultipartUploadOutputStream(String bucketName, String key, COS COSClient2, ListeningExecutorService executor, AlluxioConfiguration ufsConf) {
        super(bucketName, key, executor, ufsConf.getBytes(PropertyKey.UNDERFS_COS_MULTIPART_UPLOAD_PARTITION_SIZE), ufsConf);
        this.mClient = (COS)Preconditions.checkNotNull((Object)COSClient2);
    }

    protected void uploadPartInternal(byte[] buf, int partNumber, boolean isLastPart, long length) throws IOException {
        try {
            BufferedInputStream inputStream = new BufferedInputStream(new ByteArrayInputStream(buf, 0, (int)length));
            UploadPartRequest uploadRequest = new UploadPartRequest().withBucketName(this.mBucketName).withKey(this.mKey).withUploadId(this.mUploadId).withPartNumber(partNumber).withInputStream((InputStream)inputStream).withPartSize(length);
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(buf, 0, (int)length);
            uploadRequest.setMd5Digest(Base64.getEncoder().encodeToString(md.digest()));
            uploadRequest.setLastPart(isLastPart);
            PartETag partETag = this.getClient().uploadPart(uploadRequest).getPartETag();
            this.mTags.add(partETag);
        }
        catch (SdkClientException e) {
            LOG.debug("failed to upload part.", (Throwable)e);
            throw new IOException(String.format("failed to upload part. key: %s part number: %s uploadId: %s", this.mKey, partNumber, this.mUploadId), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    protected void initMultipartUploadInternal() throws IOException {
        try {
            ObjectMetadata meta = new ObjectMetadata();
            this.mUploadId = this.getClient().initiateMultipartUpload(new InitiateMultipartUploadRequest(this.mBucketName, this.mKey, meta)).getUploadId();
        }
        catch (SdkClientException e) {
            LOG.debug("failed to init multi part upload", (Throwable)e);
            throw new IOException("failed to init multi part upload", e);
        }
    }

    protected void completeMultipartUploadInternal() throws IOException {
        try {
            LOG.debug("complete multi part {}", (Object)this.mUploadId);
            this.mContentHash = this.getClient().completeMultipartUpload(new CompleteMultipartUploadRequest(this.mBucketName, this.mKey, this.mUploadId, this.mTags)).getETag();
        }
        catch (SdkClientException e) {
            LOG.debug("failed to complete multi part upload", (Throwable)e);
            throw new IOException(String.format("failed to complete multi part upload, key: %s, upload id: %s", this.mKey, this.mUploadId), e);
        }
    }

    protected void abortMultipartUploadInternal() throws IOException {
        try {
            this.getClient().abortMultipartUpload(new AbortMultipartUploadRequest(this.mBucketName, this.mKey, this.mUploadId));
        }
        catch (SdkClientException e) {
            LOG.debug("failed to abort multi part upload", (Throwable)e);
            throw new IOException(String.format("failed to abort multi part upload, key: %s, upload id: %s", this.mKey, this.mUploadId), e);
        }
    }

    protected void createEmptyObject(String key) throws IOException {
        try {
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentLength(0L);
            this.mContentHash = this.getClient().putObject(new PutObjectRequest(this.mBucketName, key, (InputStream)new ByteArrayInputStream(new byte[0]), meta)).getETag();
        }
        catch (SdkClientException e) {
            throw new IOException(e);
        }
    }

    protected void putObject(String key, byte[] buf, long length) throws IOException {
        try {
            ObjectMetadata meta = new ObjectMetadata();
            BufferedInputStream inputStream = new BufferedInputStream(new ByteArrayInputStream(buf, 0, (int)length));
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(buf, 0, (int)length);
            meta.setContentMD5(Base64.getEncoder().encodeToString(md.digest()));
            meta.setContentLength(length);
            PutObjectRequest putReq = new PutObjectRequest(this.mBucketName, key, (InputStream)inputStream, meta);
            this.mContentHash = this.getClient().putObject(putReq).getETag();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected COS getClient() {
        return this.mClient;
    }

    public Optional<String> getContentHash() {
        return Optional.ofNullable(this.mContentHash);
    }
}

