/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.cos;

import alluxio.AlluxioURI;
import alluxio.PositionReader;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.retry.RetryPolicy;
import alluxio.underfs.ObjectUnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.cos.COSInputStream;
import alluxio.underfs.cos.COSMultipartUploadOutputStream;
import alluxio.underfs.cos.COSOutputStream;
import alluxio.underfs.cos.COSPositionReader;
import alluxio.underfs.options.OpenOptions;
import alluxio.util.UnderFileSystemUtils;
import alluxio.util.executor.ExecutorServiceFactories;
import alluxio.util.io.PathUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.qcloud.cos.COS;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.model.COSObjectSummary;
import com.qcloud.cos.model.DeleteObjectsRequest;
import com.qcloud.cos.model.DeleteObjectsResult;
import com.qcloud.cos.model.ListObjectsRequest;
import com.qcloud.cos.model.ObjectListing;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.region.Region;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class COSUnderFileSystem
extends ObjectUnderFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(COSUnderFileSystem.class);
    private static final String FOLDER_SUFFIX = "/";
    private final COSClient mClient;
    private final String mBucketName;
    private final String mBucketNameInternal;
    private final Supplier<ListeningExecutorService> mMultipartUploadExecutor;

    public static COSUnderFileSystem createInstance(AlluxioURI uri, UnderFileSystemConfiguration conf) throws Exception {
        String bucketName = UnderFileSystemUtils.getBucketName((AlluxioURI)uri);
        Preconditions.checkArgument((boolean)conf.isSet(PropertyKey.COS_ACCESS_KEY), (String)"Property %s is required to connect to COS", (Object)PropertyKey.COS_ACCESS_KEY);
        Preconditions.checkArgument((boolean)conf.isSet(PropertyKey.COS_SECRET_KEY), (String)"Property %s is required to connect to COS", (Object)PropertyKey.COS_SECRET_KEY);
        Preconditions.checkArgument((boolean)conf.isSet(PropertyKey.COS_REGION), (String)"Property %s is required to connect to COS", (Object)PropertyKey.COS_REGION);
        Preconditions.checkArgument((boolean)conf.isSet(PropertyKey.COS_APP_ID), (String)"Property %s is required to connect to COS", (Object)PropertyKey.COS_APP_ID);
        String accessKey = conf.getString(PropertyKey.COS_ACCESS_KEY);
        String secretKey = conf.getString(PropertyKey.COS_SECRET_KEY);
        String regionName = conf.getString(PropertyKey.COS_REGION);
        String appId = conf.getString(PropertyKey.COS_APP_ID);
        BasicCOSCredentials cred = new BasicCOSCredentials(accessKey, secretKey);
        ClientConfig clientConfig = COSUnderFileSystem.createCOSClientConfig(regionName, conf);
        COSClient client = new COSClient((COSCredentials)cred, clientConfig);
        return new COSUnderFileSystem(uri, client, bucketName, appId, conf);
    }

    protected COSUnderFileSystem(AlluxioURI uri, COSClient client, String bucketName, String appId, UnderFileSystemConfiguration conf) {
        super(uri, conf);
        this.mClient = client;
        this.mBucketName = bucketName;
        this.mBucketNameInternal = bucketName + "-" + appId;
        this.mMultipartUploadExecutor = Suppliers.memoize(() -> {
            int numTransferThreads = conf.getInt(PropertyKey.UNDERFS_COS_MULTIPART_UPLOAD_THREADS);
            ExecutorService service = ExecutorServiceFactories.fixedThreadPool((String)"alluxio-cos-multipart-upload-worker", (int)numTransferThreads).create();
            return MoreExecutors.listeningDecorator((ExecutorService)service);
        });
    }

    public String getUnderFSType() {
        return "cos";
    }

    public void setOwner(String path, String user, String group) {
    }

    public void setMode(String path, short mode) {
    }

    protected boolean copyObject(String src, String dst) {
        try {
            LOG.debug("Copying {} to {}", (Object)src, (Object)dst);
            this.mClient.copyObject(this.mBucketNameInternal, src, this.mBucketNameInternal, dst);
            return true;
        }
        catch (CosClientException e) {
            LOG.error("Failed to rename file {} to {}", new Object[]{src, dst, e});
            return false;
        }
    }

    public boolean createEmptyObject(String key) {
        try {
            ObjectMetadata objMeta = new ObjectMetadata();
            objMeta.setContentLength(0L);
            this.mClient.putObject(this.mBucketNameInternal, key, (InputStream)new ByteArrayInputStream(new byte[0]), objMeta);
            return true;
        }
        catch (CosClientException e) {
            LOG.error("Failed to create object: {}", (Object)key, (Object)e);
            return false;
        }
    }

    protected OutputStream createObject(String key) throws IOException {
        if (this.mUfsConf.getBoolean(PropertyKey.UNDERFS_COS_MULTIPART_UPLOAD_ENABLED)) {
            return new COSMultipartUploadOutputStream(this.mBucketNameInternal, key, (COS)this.mClient, (ListeningExecutorService)this.mMultipartUploadExecutor.get(), (AlluxioConfiguration)this.mUfsConf);
        }
        return new COSOutputStream(this.mBucketNameInternal, key, this.mClient, this.mUfsConf.getList(PropertyKey.TMP_DIRS));
    }

    protected boolean deleteObject(String key) {
        try {
            this.mClient.deleteObject(this.mBucketNameInternal, key);
        }
        catch (CosClientException e) {
            LOG.error("Failed to delete {}", (Object)key, (Object)e);
            return false;
        }
        return true;
    }

    protected List<String> deleteObjects(List<String> keys) throws IOException {
        try {
            DeleteObjectsRequest request = new DeleteObjectsRequest(this.mBucketNameInternal);
            List keyVersions = keys.stream().map(DeleteObjectsRequest.KeyVersion::new).collect(Collectors.toList());
            request.setKeys(keyVersions);
            DeleteObjectsResult result = this.mClient.deleteObjects(request);
            return result.getDeletedObjects().stream().map(DeleteObjectsResult.DeletedObject::getKey).collect(Collectors.toList());
        }
        catch (CosClientException e) {
            throw new IOException("failed to delete objects", e);
        }
    }

    protected String getFolderSuffix() {
        return FOLDER_SUFFIX;
    }

    protected ObjectUnderFileSystem.ObjectListingChunk getObjectListingChunk(String key, boolean recursive) throws IOException {
        String delimiter = recursive ? "" : PATH_SEPARATOR;
        key = PathUtils.normalizePath((String)key, (String)PATH_SEPARATOR);
        key = key.equals(PATH_SEPARATOR) ? "" : key;
        ListObjectsRequest request = new ListObjectsRequest();
        request.setBucketName(this.mBucketNameInternal);
        request.setPrefix(key);
        request.setMaxKeys(Integer.valueOf(this.getListingChunkLength((AlluxioConfiguration)this.mUfsConf)));
        request.setDelimiter(delimiter);
        ObjectListing result = this.getObjectListingChunk(request);
        if (result != null) {
            return new COSObjectListingChunk(request, result);
        }
        return null;
    }

    private ObjectListing getObjectListingChunk(ListObjectsRequest request) {
        ObjectListing result;
        try {
            result = this.mClient.listObjects(request);
        }
        catch (CosClientException e) {
            LOG.error("Failed to list path {}", (Object)request.getPrefix(), (Object)e);
            result = null;
        }
        return result;
    }

    public boolean isDirectory(String path) throws IOException {
        if (this.isRoot(path) || path.equals(PATH_SEPARATOR)) {
            return true;
        }
        String keyAsFolder = this.convertToFolderName(this.stripPrefixIfPresent(path));
        if (this.getObjectStatus(keyAsFolder) != null) {
            return true;
        }
        return this.getObjectListingChunkForPath(path, true) != null;
    }

    public PositionReader openPositionRead(String path, long fileLength) {
        return new COSPositionReader(this.mClient, this.mBucketNameInternal, this.stripPrefixIfPresent(path), fileLength);
    }

    protected ObjectUnderFileSystem.ObjectStatus getObjectStatus(String key) {
        try {
            ObjectMetadata meta = this.mClient.getObjectMetadata(this.mBucketNameInternal, key);
            if (meta == null) {
                return null;
            }
            return new ObjectUnderFileSystem.ObjectStatus(key, meta.getETag(), meta.getContentLength(), Long.valueOf(meta.getLastModified().getTime()));
        }
        catch (CosClientException e) {
            return null;
        }
    }

    protected ObjectUnderFileSystem.ObjectPermissions getPermissions() {
        return new ObjectUnderFileSystem.ObjectPermissions("", "", 511);
    }

    protected String getRootKey() {
        return "cos://" + this.mBucketName;
    }

    private static ClientConfig createCOSClientConfig(String regionName, UnderFileSystemConfiguration conf) {
        ClientConfig config = new ClientConfig(new Region(regionName));
        config.setConnectionTimeout((int)conf.getMs(PropertyKey.COS_CONNECTION_TIMEOUT));
        config.setSocketTimeout((int)conf.getMs(PropertyKey.COS_SOCKET_TIMEOUT));
        config.setMaxConnectionsCount(conf.getInt(PropertyKey.COS_CONNECTION_MAX));
        return config;
    }

    protected InputStream openObject(String key, OpenOptions options, RetryPolicy retryPolicy) throws IOException {
        try {
            return new COSInputStream(this.mBucketNameInternal, key, this.mClient, options.getOffset(), retryPolicy, this.mUfsConf.getBytes(PropertyKey.UNDERFS_OBJECT_STORE_MULTI_RANGE_CHUNK_SIZE));
        }
        catch (CosClientException e) {
            throw new IOException(e.getMessage());
        }
    }

    private final class COSObjectListingChunk
    implements ObjectUnderFileSystem.ObjectListingChunk {
        final ListObjectsRequest mRequest;
        final ObjectListing mResult;

        COSObjectListingChunk(ListObjectsRequest request, ObjectListing result) throws IOException {
            Preconditions.checkNotNull((Object)result, (Object)"result");
            this.mRequest = request;
            this.mResult = result;
        }

        public ObjectUnderFileSystem.ObjectStatus[] getObjectStatuses() {
            List objects = this.mResult.getObjectSummaries();
            ObjectUnderFileSystem.ObjectStatus[] ret = new ObjectUnderFileSystem.ObjectStatus[objects.size()];
            int i = 0;
            for (COSObjectSummary obj : objects) {
                ret[i++] = new ObjectUnderFileSystem.ObjectStatus(obj.getKey(), obj.getETag(), obj.getSize(), Long.valueOf(obj.getLastModified().getTime()));
            }
            return ret;
        }

        public String[] getCommonPrefixes() {
            List res = this.mResult.getCommonPrefixes();
            return res.toArray(new String[0]);
        }

        public ObjectUnderFileSystem.ObjectListingChunk getNextChunk() throws IOException {
            if (this.mResult.isTruncated()) {
                this.mRequest.setMarker(this.mResult.getNextMarker());
                ObjectListing nextResult = COSUnderFileSystem.this.mClient.listObjects(this.mRequest);
                if (nextResult != null) {
                    return new COSObjectListingChunk(this.mRequest, nextResult);
                }
            }
            return null;
        }
    }
}

