/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.cos;

import alluxio.underfs.ObjectPositionReader;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.GetObjectRequest;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class COSPositionReader
extends ObjectPositionReader {
    protected final COSClient mClient;

    public COSPositionReader(COSClient client, String bucketName, String path, long fileLength) {
        super(bucketName, path, fileLength);
        this.mClient = client;
    }

    protected InputStream openObjectInputStream(long position, int bytesToRead) throws IOException {
        COSObject object;
        try {
            GetObjectRequest getObjectRequest = new GetObjectRequest(this.mBucketName, this.mPath);
            getObjectRequest.setRange(position, position + (long)bytesToRead - 1L);
            object = this.mClient.getObject(getObjectRequest);
        }
        catch (CosServiceException e) {
            String errorMessage = String.format("Failed to get object: %s bucket: %s", this.mPath, this.mBucketName);
            throw new IOException(errorMessage, e);
        }
        return object.getObjectContent();
    }
}

