/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.cos;

import alluxio.AlluxioURI;
import alluxio.conf.PropertyKey;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.UnderFileSystemFactory;
import alluxio.underfs.cos.COSUnderFileSystem;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class COSUnderFileSystemFactory
implements UnderFileSystemFactory {
    public UnderFileSystem create(String path, UnderFileSystemConfiguration conf) {
        Preconditions.checkNotNull((Object)path, (Object)"Unable to create UnderFileSystem instance: URI path should not be null");
        if (this.checkCOSCredentials(conf)) {
            try {
                return COSUnderFileSystem.createInstance(new AlluxioURI(path), conf);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        String err = "COS Credentials not available, cannot create COS Under File System.";
        throw Throwables.propagate((Throwable)new IOException(err));
    }

    public boolean supportsPath(String path) {
        return path != null && path.startsWith("cos://");
    }

    private boolean checkCOSCredentials(UnderFileSystemConfiguration conf) {
        return conf.isSet(PropertyKey.COS_ACCESS_KEY) && conf.isSet(PropertyKey.COS_SECRET_KEY) && conf.isSet(PropertyKey.COS_REGION);
    }
}

