/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.cosn;

import alluxio.AlluxioURI;
import alluxio.conf.PropertyKey;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.cosn.CosnUnderFileSystem;
import alluxio.underfs.hdfs.HdfsUnderFileSystemFactory;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class CosNUnderFileSystemFactory
extends HdfsUnderFileSystemFactory {
    public UnderFileSystem create(String path, UnderFileSystemConfiguration conf) {
        Preconditions.checkNotNull((Object)path, (Object)"path");
        return CosnUnderFileSystem.createInstance(new AlluxioURI(path), conf);
    }

    public boolean supportsPath(String path) {
        return path != null && path.startsWith("cosn://");
    }

    public boolean supportsPath(String path, UnderFileSystemConfiguration conf) {
        if (!this.supportsPath(path)) {
            return false;
        }
        return !conf.isSetByUser(PropertyKey.UNDERFS_VERSION) || conf.get(PropertyKey.UNDERFS_VERSION).equals(this.getVersion());
    }

    public String getVersion() {
        return "3.1.0-5.8.5";
    }
}

