/*
 * Decompiled with CFR 0.152.
 */
package alluxio.org.jets3t.service.model;

import alluxio.org.jets3t.service.model.MultipartPart;
import alluxio.org.jets3t.service.model.S3Owner;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartUpload {
    private String uploadId;
    private String bucketName;
    private String objectKey;
    private Map<String, Object> metadata = null;
    private String storageClass;
    private S3Owner initiator;
    private S3Owner owner;
    private Date initiatedDate;
    private List<MultipartPart> multipartsPartsUploaded = new ArrayList<MultipartPart>();

    public MultipartUpload(String uploadId, String bucketName, String objectKey) {
        this.uploadId = uploadId;
        this.objectKey = objectKey;
        this.bucketName = bucketName;
    }

    public MultipartUpload(String uploadId, String objectKey, String storageClass, S3Owner initiator, S3Owner owner, Date initiatedDate) {
        this.uploadId = uploadId;
        this.objectKey = objectKey;
        this.storageClass = storageClass;
        this.initiator = initiator;
        this.owner = owner;
        this.initiatedDate = initiatedDate;
    }

    public String toString() {
        return this.getClass().getName() + " [" + "uploadId=" + this.getUploadId() + ", bucketName=" + this.getBucketName() + ", objectKey=" + this.getObjectKey() + (this.metadata != null ? ", metadata=" + this.getMetadata() : "") + (this.storageClass != null ? ", storageClass=" + this.getStorageClass() : "") + (this.initiator != null ? ", initiator=" + this.getInitiator() : "") + (this.owner != null ? ", owner=" + this.getOwner() : "") + (this.initiatedDate != null ? ", initiatedDate=" + this.getInitiatedDate() : "") + ", multipartsPartsUploaded=" + this.multipartsPartsUploaded + "]";
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getObjectKey() {
        return this.objectKey;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public S3Owner getOwner() {
        return this.owner;
    }

    public Date getInitiatedDate() {
        return this.initiatedDate;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public void setBucketName(String name) {
        this.bucketName = name;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public S3Owner getInitiator() {
        return this.initiator;
    }

    public void addMultipartPartToUploadedList(MultipartPart part) {
        this.multipartsPartsUploaded.add(part);
    }

    public List<MultipartPart> getMultipartPartsUploaded() {
        return this.multipartsPartsUploaded;
    }
}

