/*
 * Decompiled with CFR 0.152.
 */
package alluxio.org.jets3t.service.multi;

import alluxio.org.jets3t.service.io.GZipInflatingOutputStream;
import alluxio.org.jets3t.service.model.StorageObject;
import alluxio.org.jets3t.service.security.EncryptionUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DownloadPackage {
    private static final Log log = LogFactory.getLog(DownloadPackage.class);
    protected StorageObject object = null;
    protected File outputFile = null;
    protected OutputStream outputStream = null;
    protected boolean isUnzipping = false;
    protected EncryptionUtil encryptionUtil = null;
    private boolean appendToFile = false;

    public DownloadPackage(StorageObject object, File outputFile) {
        this(object, outputFile, false, null);
    }

    public DownloadPackage(StorageObject object, File outputFile, boolean isUnzipping, EncryptionUtil encryptionUtil) {
        this.object = object;
        this.outputFile = outputFile;
        this.isUnzipping = isUnzipping;
        this.encryptionUtil = encryptionUtil;
    }

    public DownloadPackage(StorageObject object, OutputStream outputStream) {
        this(object, outputStream, false, null);
    }

    public DownloadPackage(StorageObject object, OutputStream outputStream, boolean isUnzipping, EncryptionUtil encryptionUtil) {
        this.object = object;
        this.outputStream = outputStream;
        this.isUnzipping = isUnzipping;
        this.encryptionUtil = encryptionUtil;
    }

    public StorageObject getObject() {
        return this.object;
    }

    public void setObject(StorageObject object) {
        this.object = object;
    }

    public File getDataFile() {
        return this.outputFile;
    }

    public boolean isAppendToFile() {
        return this.appendToFile;
    }

    public void setAppendToFile(boolean appendToFile) {
        this.appendToFile = appendToFile;
    }

    public OutputStream getOutputStream() throws Exception {
        OutputStream outputStream = null;
        if (this.outputFile != null) {
            if (this.outputFile.getParentFile() != null) {
                this.outputFile.getParentFile().mkdirs();
            }
            outputStream = new FileOutputStream(this.outputFile, this.appendToFile);
        } else {
            outputStream = this.outputStream;
        }
        if (this.isUnzipping) {
            log.debug((Object)("Inflating gzipped data for object: " + this.object.getKey()));
            outputStream = new GZipInflatingOutputStream(outputStream);
        }
        if (this.encryptionUtil != null) {
            log.debug((Object)("Decrypting encrypted data for object: " + this.object.getKey()));
            outputStream = this.encryptionUtil.decrypt(outputStream);
        }
        return outputStream;
    }
}

