/*
 * Decompiled with CFR 0.152.
 */
package alluxio.org.jets3t.service.multithread;

import alluxio.org.jets3t.service.model.S3Object;
import alluxio.org.jets3t.service.multithread.ServiceEvent;
import alluxio.org.jets3t.service.multithread.ThreadWatcher;

public class DownloadObjectsEvent
extends ServiceEvent {
    private S3Object[] objects = null;

    private DownloadObjectsEvent(int eventCode, Object uniqueOperationId) {
        super(eventCode, uniqueOperationId);
    }

    public static DownloadObjectsEvent newErrorEvent(Throwable t, Object uniqueOperationId) {
        DownloadObjectsEvent event = new DownloadObjectsEvent(0, uniqueOperationId);
        event.setErrorCause(t);
        return event;
    }

    public static DownloadObjectsEvent newStartedEvent(ThreadWatcher threadWatcher, Object uniqueOperationId) {
        DownloadObjectsEvent event = new DownloadObjectsEvent(1, uniqueOperationId);
        event.setThreadWatcher(threadWatcher);
        return event;
    }

    public static DownloadObjectsEvent newInProgressEvent(ThreadWatcher threadWatcher, S3Object[] completedObjects, Object uniqueOperationId) {
        DownloadObjectsEvent event = new DownloadObjectsEvent(3, uniqueOperationId);
        event.setThreadWatcher(threadWatcher);
        event.setObjects(completedObjects);
        return event;
    }

    public static DownloadObjectsEvent newCompletedEvent(Object uniqueOperationId) {
        DownloadObjectsEvent event = new DownloadObjectsEvent(2, uniqueOperationId);
        return event;
    }

    public static DownloadObjectsEvent newCancelledEvent(S3Object[] incompletedObjects, Object uniqueOperationId) {
        DownloadObjectsEvent event = new DownloadObjectsEvent(4, uniqueOperationId);
        event.setObjects(incompletedObjects);
        return event;
    }

    public static DownloadObjectsEvent newIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors, Object uniqueOperationId) {
        DownloadObjectsEvent event = new DownloadObjectsEvent(5, uniqueOperationId);
        event.setIgnoredErrors(ignoredErrors);
        return event;
    }

    private void setObjects(S3Object[] objects) {
        this.objects = objects;
    }

    public S3Object[] getDownloadedObjects() throws IllegalStateException {
        if (this.getEventCode() != 3) {
            throw new IllegalStateException("Downloaded Objects are only available from EVENT_IN_PROGRESS events");
        }
        return this.objects;
    }

    public S3Object[] getCancelledObjects() throws IllegalStateException {
        if (this.getEventCode() != 4) {
            throw new IllegalStateException("Cancelled Objects are  only available from EVENT_CANCELLED events");
        }
        return this.objects;
    }
}

