/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.gcs;

import alluxio.org.jets3t.service.ServiceException;
import alluxio.org.jets3t.service.impl.rest.httpclient.GoogleStorageService;
import alluxio.org.jets3t.service.model.GSObject;
import alluxio.util.io.PathUtils;
import com.google.common.base.Preconditions;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class GCSOutputStream
extends OutputStream {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private final String mBucketName;
    private final String mKey;
    private final File mFile;
    private final GoogleStorageService mClient;
    private OutputStream mLocalOutputStream;
    private MessageDigest mHash;
    private AtomicBoolean mClosed = new AtomicBoolean(false);

    public GCSOutputStream(String bucketName, String key, GoogleStorageService client) throws IOException {
        Preconditions.checkArgument((bucketName != null && !bucketName.isEmpty() ? 1 : 0) != 0, (Object)"Bucket name must not be null or empty.");
        this.mBucketName = bucketName;
        this.mKey = key;
        this.mClient = client;
        this.mFile = new File(PathUtils.concatPath((Object)"/tmp", (Object[])new Object[]{UUID.randomUUID()}));
        try {
            this.mHash = MessageDigest.getInstance("MD5");
            this.mLocalOutputStream = new BufferedOutputStream(new DigestOutputStream(new FileOutputStream(this.mFile), this.mHash));
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn("Algorithm not available for MD5 hash.", (Throwable)e);
            this.mHash = null;
            this.mLocalOutputStream = new BufferedOutputStream(new FileOutputStream(this.mFile));
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.mLocalOutputStream.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.mLocalOutputStream.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.mLocalOutputStream.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.mLocalOutputStream.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed.getAndSet(true)) {
            return;
        }
        this.mLocalOutputStream.close();
        try {
            GSObject obj = new GSObject(this.mKey);
            obj.setBucketName(this.mBucketName);
            obj.setDataInputFile(this.mFile);
            obj.setContentLength(this.mFile.length());
            obj.setContentEncoding("binary/octet-stream");
            if (this.mHash != null) {
                obj.setMd5Hash(this.mHash.digest());
            } else {
                LOG.warn("MD5 was not computed for: {}", (Object)this.mKey);
            }
            this.mClient.putObject(this.mBucketName, obj);
            if (!this.mFile.delete()) {
                LOG.error("Failed to delete temporary file @ {}", (Object)this.mFile.getPath());
            }
        }
        catch (ServiceException e) {
            LOG.error("Failed to upload {}. Temporary file @ {}", (Object)this.mKey, (Object)this.mFile.getPath());
            throw new IOException(e);
        }
    }
}

