/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.gcs;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.PropertyKey;
import alluxio.org.jets3t.service.ServiceException;
import alluxio.org.jets3t.service.StorageObjectsChunk;
import alluxio.org.jets3t.service.acl.gs.GSAccessControlList;
import alluxio.org.jets3t.service.impl.rest.httpclient.GoogleStorageService;
import alluxio.org.jets3t.service.model.GSObject;
import alluxio.org.jets3t.service.model.StorageObject;
import alluxio.org.jets3t.service.security.GSCredentials;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.gcs.GCSInputStream;
import alluxio.underfs.gcs.GCSOutputStream;
import alluxio.underfs.gcs.GCSUtils;
import alluxio.underfs.options.CreateOptions;
import alluxio.underfs.options.MkdirsOptions;
import alluxio.util.CommonUtils;
import alluxio.util.io.PathUtils;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class GCSUnderFileSystem
extends UnderFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private static final String FOLDER_SUFFIX = "_$folder$";
    private static final String PATH_SEPARATOR = "/";
    private static final byte[] DIR_HASH;
    private final GoogleStorageService mClient;
    private final String mBucketName;
    private final String mBucketPrefix;
    private final String mAccountOwner;
    private final short mBucketMode;

    public static GCSUnderFileSystem createInstance(AlluxioURI uri) throws ServiceException {
        String bucketName = uri.getHost();
        Preconditions.checkArgument((boolean)Configuration.containsKey((PropertyKey)PropertyKey.GCS_ACCESS_KEY), (Object)("Property " + PropertyKey.GCS_ACCESS_KEY + " is required to connect to GCS"));
        Preconditions.checkArgument((boolean)Configuration.containsKey((PropertyKey)PropertyKey.GCS_SECRET_KEY), (Object)("Property " + PropertyKey.GCS_SECRET_KEY + " is required to connect to GCS"));
        GSCredentials googleCredentials = new GSCredentials(Configuration.get((PropertyKey)PropertyKey.GCS_ACCESS_KEY), Configuration.get((PropertyKey)PropertyKey.GCS_SECRET_KEY));
        GoogleStorageService googleStorageService = new GoogleStorageService(googleCredentials);
        String bucketPrefix = PathUtils.normalizePath((String)("gs://" + bucketName), (String)PATH_SEPARATOR);
        String accountOwnerId = googleStorageService.getAccountOwner().getId();
        String owner = CommonUtils.getValueFromStaticMapping((String)Configuration.get((PropertyKey)PropertyKey.UNDERFS_GCS_OWNER_ID_TO_USERNAME_MAPPING), (String)accountOwnerId);
        if (owner == null) {
            owner = googleStorageService.getAccountOwner().getDisplayName();
        }
        String accountOwner = owner == null ? accountOwnerId : owner;
        GSAccessControlList acl = googleStorageService.getBucketAcl(bucketName);
        short bucketMode = GCSUtils.translateBucketAcl(acl, accountOwnerId);
        return new GCSUnderFileSystem(uri, googleStorageService, bucketName, bucketPrefix, bucketMode, accountOwner);
    }

    protected GCSUnderFileSystem(AlluxioURI uri, GoogleStorageService googleStorageService, String bucketName, String bucketPrefix, short bucketMode, String accountOwner) {
        super(uri);
        this.mClient = googleStorageService;
        this.mBucketName = bucketName;
        this.mBucketPrefix = bucketPrefix;
        this.mBucketMode = bucketMode;
        this.mAccountOwner = accountOwner;
    }

    public String getUnderFSType() {
        return "gcs";
    }

    public void close() throws IOException {
    }

    public void connectFromMaster(String hostname) {
    }

    public void connectFromWorker(String hostname) {
    }

    public OutputStream create(String path) throws IOException {
        return this.create(path, new CreateOptions());
    }

    public OutputStream create(String path, CreateOptions options) throws IOException {
        if (this.mkdirs(this.getParentKey(path), true)) {
            return new GCSOutputStream(this.mBucketName, this.stripPrefixIfPresent(path), this.mClient);
        }
        return null;
    }

    public boolean delete(String path, boolean recursive) throws IOException {
        if (!recursive) {
            String[] children = this.listInternal(path, false);
            if (children == null) {
                LOG.error("Unable to delete {} because listInternal returns null", (Object)path);
                return false;
            }
            if (this.isFolder(path) && children.length != 0) {
                LOG.error("Unable to delete {} because it is a non empty directory. Specify recursive as true in order to delete non empty directories.", (Object)path);
                return false;
            }
            return this.deleteInternal(path);
        }
        String[] pathsToDelete = this.listInternal(path, true);
        if (pathsToDelete == null) {
            LOG.error("Unable to delete {} because listInternal returns null", (Object)path);
            return false;
        }
        for (String pathToDelete : pathsToDelete) {
            if (this.deleteInternal(PathUtils.concatPath((Object)path, (Object[])new Object[]{pathToDelete}))) continue;
            LOG.error("Failed to delete path {}, aborting delete.", (Object)pathToDelete);
            return false;
        }
        return this.deleteInternal(path);
    }

    public boolean exists(String path) throws IOException {
        return this.isRoot(path) || this.getObjectDetails(path) != null;
    }

    public long getBlockSizeByte(String path) throws IOException {
        return Configuration.getBytes((PropertyKey)PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT);
    }

    public Object getConf() {
        LOG.debug("getConf is not supported when using GCSUnderFileSystem, returning null.");
        return null;
    }

    public List<String> getFileLocations(String path) throws IOException {
        LOG.debug("getFileLocations is not supported when using GCSUnderFileSystem, returning null.");
        return null;
    }

    public List<String> getFileLocations(String path, long offset) throws IOException {
        LOG.debug("getFileLocations is not supported when using GCSUnderFileSystem, returning null.");
        return null;
    }

    public long getFileSize(String path) throws IOException {
        GSObject details = this.getObjectDetails(path);
        if (details != null) {
            return details.getContentLength();
        }
        throw new FileNotFoundException(path);
    }

    public long getModificationTimeMs(String path) throws IOException {
        GSObject details = this.getObjectDetails(path);
        if (details != null) {
            return details.getLastModifiedDate().getTime();
        }
        throw new FileNotFoundException(path);
    }

    public long getSpace(String path, UnderFileSystem.SpaceType type) throws IOException {
        return -1L;
    }

    public boolean isFile(String path) throws IOException {
        return this.exists(path) && !this.isFolder(path);
    }

    public String[] list(String path) throws IOException {
        if (!this.exists(path) || this.isFile(path)) {
            return null;
        }
        path = PathUtils.normalizePath((String)path, (String)PATH_SEPARATOR);
        return this.listInternal(path, false);
    }

    public boolean mkdirs(String path, boolean createParent) throws IOException {
        return this.mkdirs(path, new MkdirsOptions().setCreateParent(createParent));
    }

    public boolean mkdirs(String path, MkdirsOptions options) throws IOException {
        if (path == null) {
            return false;
        }
        if (this.isFolder(path)) {
            return true;
        }
        if (this.exists(path)) {
            LOG.error("Cannot create directory {} because it is already a file.", (Object)path);
            return false;
        }
        if (!options.getCreateParent()) {
            if (this.parentExists(path)) {
                return this.mkdirsInternal(path);
            }
            LOG.error("Cannot create directory {} because parent does not exist", (Object)path);
            return false;
        }
        if (this.parentExists(path)) {
            return this.mkdirsInternal(path);
        }
        String parentKey = this.getParentKey(path);
        return this.mkdirs(parentKey, true) && this.mkdirsInternal(path);
    }

    public InputStream open(String path) throws IOException {
        try {
            path = this.stripPrefixIfPresent(path);
            return new GCSInputStream(this.mBucketName, path, this.mClient);
        }
        catch (ServiceException e) {
            LOG.error("Failed to open file: {}", (Object)path, (Object)e);
            return null;
        }
    }

    public InputStream openAtPosition(String path, long pos) throws IOException {
        try {
            path = this.stripPrefixIfPresent(path);
            return new GCSInputStream(this.mBucketName, path, this.mClient, pos);
        }
        catch (ServiceException e) {
            LOG.error("Failed to open file {} at position {}:", new Object[]{path, pos, e});
            return null;
        }
    }

    public boolean rename(String src, String dst) throws IOException {
        if (!this.exists(src)) {
            LOG.error("Unable to rename {} to {} because source does not exist.", (Object)src, (Object)dst);
            return false;
        }
        if (this.exists(dst)) {
            LOG.error("Unable to rename {} to {} because destination already exists.", (Object)src, (Object)dst);
            return false;
        }
        if (this.isFolder(src)) {
            if (!this.copy(this.convertToFolderName(src), this.convertToFolderName(dst))) {
                return false;
            }
            String[] children = this.list(src);
            if (children == null) {
                LOG.error("Failed to list path {}, aborting rename.", (Object)src);
                return false;
            }
            for (String child : children) {
                if (this.rename(PathUtils.concatPath((Object)src, (Object[])new Object[]{child}), PathUtils.concatPath((Object)dst, (Object[])new Object[]{child}))) continue;
                LOG.error("Failed to rename path {}, aborting rename.", (Object)child);
                return false;
            }
            return this.delete(src, true);
        }
        return this.copy(src, dst) && this.deleteInternal(src);
    }

    public void setConf(Object conf) {
    }

    public void setOwner(String path, String user, String group) {
    }

    public void setMode(String path, short mode) throws IOException {
    }

    public String getOwner(String path) throws IOException {
        return this.mAccountOwner;
    }

    public String getGroup(String path) throws IOException {
        return this.mAccountOwner;
    }

    public short getMode(String path) throws IOException {
        return this.mBucketMode;
    }

    private String convertToFolderName(String key) {
        if (key.endsWith(PATH_SEPARATOR)) {
            key = key.substring(0, key.length() - PATH_SEPARATOR.length());
        }
        return key + FOLDER_SUFFIX;
    }

    private boolean copy(String src, String dst) {
        src = this.stripPrefixIfPresent(src);
        dst = this.stripPrefixIfPresent(dst);
        LOG.debug("Copying {} to {}", (Object)src, (Object)dst);
        GSObject obj = new GSObject(dst);
        int retries = 3;
        for (int i = 0; i < retries; ++i) {
            try {
                this.mClient.copyObject(this.mBucketName, src, this.mBucketName, obj, false);
                return true;
            }
            catch (ServiceException e) {
                LOG.error("Failed to copy file {} to {}", new Object[]{src, dst, e});
                if (i == retries - 1) continue;
                LOG.error("Retrying copying file {} to {}", (Object)src, (Object)dst);
                continue;
            }
        }
        LOG.error("Failed to copy file {} to {}, after {} retries", new Object[]{src, dst, retries});
        return false;
    }

    private boolean deleteInternal(String key) {
        try {
            if (this.isFolder(key)) {
                String keyAsFolder = this.convertToFolderName(this.stripPrefixIfPresent(key));
                this.mClient.deleteObject(this.mBucketName, keyAsFolder);
            } else {
                this.mClient.deleteObject(this.mBucketName, this.stripPrefixIfPresent(key));
            }
        }
        catch (ServiceException e) {
            LOG.error("Failed to delete {}", (Object)key, (Object)e);
            return false;
        }
        return true;
    }

    private String getChildName(String child, String parent) {
        if (child.startsWith(parent)) {
            return child.substring(parent.length());
        }
        LOG.error("Attempted to get childname with an invalid parent argument. Parent: {} Child: {}", (Object)parent, (Object)child);
        return null;
    }

    private GSObject getObjectDetails(String key) {
        try {
            if (this.isFolder(key)) {
                String keyAsFolder = this.convertToFolderName(this.stripPrefixIfPresent(key));
                return this.mClient.getObjectDetails(this.mBucketName, keyAsFolder);
            }
            return this.mClient.getObjectDetails(this.mBucketName, this.stripPrefixIfPresent(key));
        }
        catch (ServiceException e) {
            return null;
        }
    }

    private String getParentKey(String key) {
        if (this.isRoot(key)) {
            return null;
        }
        int separatorIndex = key.lastIndexOf(PATH_SEPARATOR);
        if (separatorIndex < 0) {
            return null;
        }
        return key.substring(0, separatorIndex);
    }

    private boolean isFolder(String key) {
        if (this.isRoot(key)) {
            return true;
        }
        try {
            String keyAsFolder = this.convertToFolderName(this.stripPrefixIfPresent(key));
            this.mClient.getObjectDetails(this.mBucketName, keyAsFolder);
            return true;
        }
        catch (ServiceException s) {
            try {
                String path = PathUtils.normalizePath((String)this.stripPrefixIfPresent(key), (String)PATH_SEPARATOR);
                GSObject[] objs = this.mClient.listObjects(this.mBucketName, path, "");
                if (objs.length > 0) {
                    this.mkdirsInternal(path);
                    return true;
                }
                return false;
            }
            catch (ServiceException s2) {
                return false;
            }
        }
    }

    private boolean isRoot(String key) {
        return PathUtils.normalizePath((String)key, (String)PATH_SEPARATOR).equals(PathUtils.normalizePath((String)("gs://" + this.mBucketName), (String)PATH_SEPARATOR));
    }

    private String[] listInternal(String path, boolean recursive) throws IOException {
        path = this.stripPrefixIfPresent(path);
        path = (path = PathUtils.normalizePath((String)path, (String)PATH_SEPARATOR)).equals(PATH_SEPARATOR) ? "" : path;
        String delimiter = recursive ? "" : PATH_SEPARATOR;
        String priorLastKey = null;
        HashSet<String> children = new HashSet<String>();
        try {
            boolean done = false;
            while (!done) {
                String child;
                StorageObjectsChunk chunk = this.mClient.listObjectsChunked(this.mBucketName, path, delimiter, LISTING_LENGTH, priorLastKey);
                for (StorageObject obj : chunk.getObjects()) {
                    child = this.getChildName(obj.getKey(), path);
                    if ((child = CommonUtils.stripSuffixIfPresent((String)child, (String)FOLDER_SUFFIX)).isEmpty()) continue;
                    children.add(child);
                }
                for (String commonPrefix : chunk.getCommonPrefixes()) {
                    child = this.getChildName(commonPrefix, path);
                    if (child == null) continue;
                    int childNameIndex = child.lastIndexOf(PATH_SEPARATOR);
                    String string = child = childNameIndex != -1 ? child.substring(0, childNameIndex) : child;
                    if (child.isEmpty() || children.contains(child)) continue;
                    this.mkdirsInternal(commonPrefix);
                    children.add(child);
                }
                done = chunk.isListingComplete();
                priorLastKey = chunk.getPriorLastKey();
            }
            return children.toArray(new String[children.size()]);
        }
        catch (ServiceException e) {
            LOG.error("Failed to list path {}", (Object)path, (Object)e);
            return null;
        }
    }

    private boolean mkdirsInternal(String key) {
        try {
            String keyAsFolder = this.convertToFolderName(this.stripPrefixIfPresent(key));
            GSObject obj = new GSObject(keyAsFolder);
            obj.setDataInputStream(new ByteArrayInputStream(new byte[0]));
            obj.setContentLength(0L);
            obj.setMd5Hash(DIR_HASH);
            obj.setContentType("binary/octet-stream");
            this.mClient.putObject(this.mBucketName, obj);
            return true;
        }
        catch (ServiceException e) {
            LOG.error("Failed to create directory: {}", (Object)key, (Object)e);
            return false;
        }
    }

    private boolean parentExists(String key) {
        if (this.isRoot(key)) {
            return true;
        }
        String parentKey = this.getParentKey(key);
        return parentKey != null && this.isFolder(parentKey);
    }

    private String stripPrefixIfPresent(String key) {
        String stripedKey = CommonUtils.stripPrefixIfPresent((String)key, (String)this.mBucketPrefix);
        if (!stripedKey.equals(key)) {
            return stripedKey;
        }
        return CommonUtils.stripPrefixIfPresent((String)key, (String)PATH_SEPARATOR);
    }

    public boolean supportsFlush() {
        return false;
    }

    static {
        try {
            DIR_HASH = MessageDigest.getInstance("MD5").digest(new byte[0]);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }
}

