/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.gcs;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.PropertyKey;
import alluxio.org.jets3t.service.ServiceException;
import alluxio.org.jets3t.service.StorageObjectsChunk;
import alluxio.org.jets3t.service.acl.gs.GSAccessControlList;
import alluxio.org.jets3t.service.impl.rest.httpclient.GoogleStorageService;
import alluxio.org.jets3t.service.model.GSObject;
import alluxio.org.jets3t.service.model.StorageObject;
import alluxio.org.jets3t.service.security.GSCredentials;
import alluxio.underfs.ObjectUnderFileSystem;
import alluxio.underfs.gcs.GCSInputStream;
import alluxio.underfs.gcs.GCSOutputStream;
import alluxio.underfs.gcs.GCSUtils;
import alluxio.underfs.options.OpenOptions;
import alluxio.util.CommonUtils;
import alluxio.util.io.PathUtils;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class GCSUnderFileSystem
extends ObjectUnderFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private static final String FOLDER_SUFFIX = "_$folder$";
    private static final byte[] DIR_HASH;
    private final GoogleStorageService mClient;
    private final String mBucketName;
    private final String mAccountOwner;
    private final short mBucketMode;

    public static GCSUnderFileSystem createInstance(AlluxioURI uri) throws ServiceException {
        String bucketName = uri.getHost();
        Preconditions.checkArgument((boolean)Configuration.containsKey((PropertyKey)PropertyKey.GCS_ACCESS_KEY), (Object)("Property " + PropertyKey.GCS_ACCESS_KEY + " is required to connect to GCS"));
        Preconditions.checkArgument((boolean)Configuration.containsKey((PropertyKey)PropertyKey.GCS_SECRET_KEY), (Object)("Property " + PropertyKey.GCS_SECRET_KEY + " is required to connect to GCS"));
        GSCredentials googleCredentials = new GSCredentials(Configuration.get((PropertyKey)PropertyKey.GCS_ACCESS_KEY), Configuration.get((PropertyKey)PropertyKey.GCS_SECRET_KEY));
        GoogleStorageService googleStorageService = new GoogleStorageService(googleCredentials);
        String accountOwnerId = googleStorageService.getAccountOwner().getId();
        String owner = CommonUtils.getValueFromStaticMapping((String)Configuration.get((PropertyKey)PropertyKey.UNDERFS_GCS_OWNER_ID_TO_USERNAME_MAPPING), (String)accountOwnerId);
        if (owner == null) {
            owner = googleStorageService.getAccountOwner().getDisplayName();
        }
        String accountOwner = owner == null ? accountOwnerId : owner;
        GSAccessControlList acl = googleStorageService.getBucketAcl(bucketName);
        short bucketMode = GCSUtils.translateBucketAcl(acl, accountOwnerId);
        return new GCSUnderFileSystem(uri, googleStorageService, bucketName, bucketMode, accountOwner);
    }

    protected GCSUnderFileSystem(AlluxioURI uri, GoogleStorageService googleStorageService, String bucketName, short bucketMode, String accountOwner) {
        super(uri);
        this.mClient = googleStorageService;
        this.mBucketName = bucketName;
        this.mBucketMode = bucketMode;
        this.mAccountOwner = accountOwner;
    }

    public String getUnderFSType() {
        return "gcs";
    }

    public void setOwner(String path, String user, String group) {
    }

    public void setMode(String path, short mode) throws IOException {
    }

    public String getOwner(String path) throws IOException {
        return this.mAccountOwner;
    }

    public String getGroup(String path) throws IOException {
        return this.mAccountOwner;
    }

    public short getMode(String path) throws IOException {
        return this.mBucketMode;
    }

    protected boolean copyObject(String src, String dst) {
        LOG.debug("Copying {} to {}", (Object)src, (Object)dst);
        GSObject obj = new GSObject(dst);
        int retries = 3;
        for (int i = 0; i < retries; ++i) {
            try {
                this.mClient.copyObject(this.mBucketName, src, this.mBucketName, obj, false);
                return true;
            }
            catch (ServiceException e) {
                LOG.error("Failed to copy file {} to {}", new Object[]{src, dst, e});
                if (i == retries - 1) continue;
                LOG.error("Retrying copying file {} to {}", (Object)src, (Object)dst);
                continue;
            }
        }
        LOG.error("Failed to copy file {} to {}, after {} retries", new Object[]{src, dst, retries});
        return false;
    }

    protected boolean createEmptyObject(String key) {
        try {
            GSObject obj = new GSObject(key);
            obj.setDataInputStream(new ByteArrayInputStream(new byte[0]));
            obj.setContentLength(0L);
            obj.setMd5Hash(DIR_HASH);
            obj.setContentType("binary/octet-stream");
            this.mClient.putObject(this.mBucketName, obj);
            return true;
        }
        catch (ServiceException e) {
            LOG.error("Failed to create directory: {}", (Object)key, (Object)e);
            return false;
        }
    }

    protected OutputStream createObject(String key) throws IOException {
        return new GCSOutputStream(this.mBucketName, key, this.mClient);
    }

    protected boolean deleteObject(String key) throws IOException {
        try {
            this.mClient.deleteObject(this.mBucketName, key);
        }
        catch (ServiceException e) {
            LOG.error("Failed to delete {}", (Object)key, (Object)e);
            return false;
        }
        return true;
    }

    protected String getFolderSuffix() {
        return FOLDER_SUFFIX;
    }

    protected ObjectUnderFileSystem.ObjectListingChunk getObjectListingChunk(String key, boolean recursive) throws IOException {
        String delimiter;
        StorageObjectsChunk chunk = this.getObjectListingChunk(key = (key = PathUtils.normalizePath((String)key, (String)PATH_SEPARATOR)).equals(PATH_SEPARATOR) ? "" : key, delimiter = recursive ? "" : PATH_SEPARATOR, null);
        if (chunk != null) {
            return new GCSObjectListingChunk(chunk);
        }
        return null;
    }

    private StorageObjectsChunk getObjectListingChunk(String key, String delimiter, String priorLastKey) {
        StorageObjectsChunk res;
        try {
            res = this.mClient.listObjectsChunked(this.mBucketName, key, delimiter, this.getListingChunkLength(), priorLastKey);
        }
        catch (ServiceException e) {
            LOG.error("Failed to list path {}", (Object)key, (Object)e);
            res = null;
        }
        return res;
    }

    protected ObjectUnderFileSystem.ObjectStatus getObjectStatus(String key) {
        try {
            GSObject meta = this.mClient.getObjectDetails(this.mBucketName, key);
            if (meta == null) {
                return null;
            }
            return new ObjectUnderFileSystem.ObjectStatus((ObjectUnderFileSystem)this, meta.getContentLength(), meta.getLastModifiedDate().getTime());
        }
        catch (ServiceException e) {
            return null;
        }
    }

    protected String getRootKey() {
        return "gs://" + this.mBucketName;
    }

    protected InputStream openObject(String key, OpenOptions options) throws IOException {
        try {
            return new GCSInputStream(this.mBucketName, key, this.mClient, options.getOffset());
        }
        catch (ServiceException e) {
            throw new IOException(e.getMessage());
        }
    }

    static {
        try {
            DIR_HASH = MessageDigest.getInstance("MD5").digest(new byte[0]);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    private final class GCSObjectListingChunk
    implements ObjectUnderFileSystem.ObjectListingChunk {
        final StorageObjectsChunk mChunk;

        GCSObjectListingChunk(StorageObjectsChunk chunk) throws IOException {
            this.mChunk = chunk;
            if (this.mChunk == null) {
                throw new IOException("GCS listing result is null");
            }
        }

        public String[] getObjectNames() {
            StorageObject[] objects = this.mChunk.getObjects();
            String[] ret = new String[objects.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = objects[i].getKey();
            }
            return ret;
        }

        public String[] getCommonPrefixes() {
            return this.mChunk.getCommonPrefixes();
        }

        public ObjectUnderFileSystem.ObjectListingChunk getNextChunk() throws IOException {
            StorageObjectsChunk nextChunk;
            if (!this.mChunk.isListingComplete() && (nextChunk = GCSUnderFileSystem.this.getObjectListingChunk(this.mChunk.getPrefix(), this.mChunk.getDelimiter(), this.mChunk.getPriorLastKey())) != null) {
                return new GCSObjectListingChunk(nextChunk);
            }
            return null;
        }
    }
}

